#ifndef WINDOW_H
#define WINDOW_H

#include <QMainWindow>
#include <QWidget>
#include <QDebug>
#include <QString>
#include <QLabel>
#include <QLineEdit>
#include <QCheckBox>
#include <QSpinBox>
#include "sourcedata.h"
#include "cdata.h"
#include "group.h"
#include "glwidget.h"
#include "cbar.h"
#include "sourcedata.h"
#include "hierarchy.h"
#include "cmap.h"
#include "linetext.h"

#ifndef SUB
#define SUB "../DATA/SUB/MPI_SUB"
#endif


class Window : public QMainWindow
{

    Q_OBJECT

public:

    Window(QWidget *parent);

    Window(int width, int height, int pad, QString infile_1, QString infile_2,
           QWidget *parent = 0);

    Window(int width, int height, int pad, QString infile_1,
           Hierarchy* &hierarchy, CMap* &map,
           int time, string time1, QWidget *parent = 0);

    Window(int width, int height, int pad, int cluster, int sender, int recver,
           QString infile_1,  Hierarchy* &hierarchy,
           CMap* &map, int time, string time1, QWidget *parent = 0);

protected:

    inline QSlider* &createSlider(const char *changedSignal,
                                  const char *setterSlot1,
                                  const char *setterSlot2,
                                  GLWidget *widget,
                                  int range,
                                  int step,
                                  int start,
                                  int init,
                                  int interval)
    {
        QSlider *slider = new QSlider(Qt::Horizontal);
        slider->setRange(start, range);
        slider->setSingleStep(step);
        slider->setPageStep(step);
        slider->setTickInterval(interval);
        slider->setTickPosition(QSlider::TicksAbove);
        slider->setValue(init);
        connect(slider, SIGNAL(valueChanged(int)), widget, setterSlot1);
        connect(slider, SIGNAL(sliderReleased()), widget, setterSlot2);
        connect(widget, changedSignal, slider, SLOT(setValue(int)));
        return slider;
    }

    inline QLabel* &createLabel(QSlider *slider, int init)
    {
        QLabel *sBox = new QLabel();
        sBox->setNum(init);
        connect(slider, SIGNAL(valueChanged(int)), sBox, SLOT(setNum(int)));
        return sBox;
    }

    inline QCheckBox* &createCheckBox(const char *changedSignal,
                                      const char *setterSlot,
                                      GLWidget *widget,
                                      QString init)
    {
        QCheckBox *box = new QCheckBox();
        box->setText(init);
        box->setTristate(false);
        box->setMaximumSize(20, 20);
        connect(box, SIGNAL(stateChanged(int)), widget, setterSlot);
        return box;
    }

private slots:

    inline void addWindow(Hierarchy* hierarchy, CMap* map,
                          int time, int cluster, int sender, int recver,
                          string time1)
    {
        int width = 800;
        int height = 1000;
        int pad = 80;
        QString infile(SUB);
        Window *extra = new Window(width, height, pad, cluster, sender, recver,
                                   infile, hierarchy, map, time, time1);
        extra->show();
    }

    inline void addWindow_full(Hierarchy* hierarchy, CMap* map, int time,
                          string time1)
    {
        int width = 800;
        int height = 1000;
        int pad = 80;
        QString infile(SUB);
        Window *extra = new Window(width, height, pad, infile,
                                   hierarchy, map, time, time1);
        extra->show();
    }

private:

    QWidget         *m_centralWidget;

    GLWidget        *m_glWidget;

    QScrollArea     *m_glWidgetArea;

    QCheckBox       *m_Cardiograph;

    QCheckBox       *m_PolyGraph;

    QCheckBox       *m_LineGraph;

    QCheckBox       *m_Xzoomin;

    QCheckBox       *m_Yzoomin;

    QCheckBox       *m_Fullzoomin;

    QSlider         *m_xSlider;         /* size impact */

    QSlider         *m_ySlider;         /* cluster difference */

    QSlider         *m_zSlider;         /* Time intervel */

    QSlider         *m_kSlider;         /* Cluster */

    QSlider         *m_sSlider;         /* show scale */

    QLabel          *m_xBox;            /* size impact */

    QLabel          *m_yBox;            /* cluster difference */

    QLabel          *m_zBox;            /* Time intervel */

    QLabel          *m_kBox;            /* Cluster */

    QLabel          *m_sBox;            /* show scale */

    Hierarchy       *m_pHierarchy;

    CMap            *m_pMap;



};

#endif // WINDOW_H
