#include "window.h"

Window::Window(QWidget *parent)
    : QMainWindow(parent)
{

}

Window::Window(int width, int height, int pad,
               QString infile_1,
               QString infile_2,
               QWidget *parent)
    : QMainWindow(parent)
{
    m_centralWidget = new QWidget;
    setCentralWidget(m_centralWidget);
    m_glWidget = new GLWidget(width, height, pad, infile_1, infile_2);

    m_glWidgetArea = new QScrollArea;
    m_glWidgetArea->setWidget(m_glWidget);
    m_glWidgetArea->setWidgetResizable(false);
    m_glWidgetArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOn);
    m_glWidgetArea->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOn);
    m_glWidgetArea->setMinimumSize(width, height);
    m_glWidgetArea->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    //m_glWidgetArea->setSizePolicy(QSizePolicy::Ignored, QSizePolicy::Ignored);

    int n_init;
    /**
     *size impact
     */
    n_init = 0;
    m_xSlider = createSlider(SIGNAL(xAxisChanged(int)),
                             SLOT(setXAxis(int)),
                             SLOT(setGraph()),
                             m_glWidget, 100, 10, 0, n_init, 10);
    m_xBox = createLabel(m_xSlider, n_init);

    /**
     *cluster difference
     */
    n_init = 0;
    m_ySlider = createSlider(SIGNAL(yAxisChanged(int)),
                             SLOT(setYAxis(int)),
                             SLOT(setGraph()),
                             m_glWidget, 10, 1, 0, n_init, 1);
    m_yBox = createLabel(m_ySlider, n_init);

    /**
     *time intervel
     */
    n_init = 12;
    m_zSlider = createSlider(SIGNAL(zAxisChanged(int)),
                             SLOT(setZAxis(int)),
                             SLOT(setInterval()),
                             m_glWidget, 50, 1, 1, n_init, 1);
    m_zBox = createLabel(m_zSlider, n_init);

    /**
     *cluster size
     */
    n_init = 18;
    m_kSlider = createSlider(SIGNAL(kAxisChanged(int)),
                             SLOT(setKAxis(int)),
                             SLOT(setCluster()),
                             m_glWidget, 73, 1, 1, n_init, 1);
    m_kBox = createLabel(m_kSlider, n_init);

    /**
     *graph scale
     */
    n_init = 13;
    m_sSlider = createSlider(SIGNAL(sAxisChanged(int)),
                             SLOT(setSAxis(int)),
                             SLOT(setGraph()),
                             m_glWidget, 50, 1, 1, n_init, 1);
    m_sBox = createLabel(m_sSlider, n_init);

    /**
     *show cardiograph
     */
    m_Cardiograph = createCheckBox(SIGNAL(cAxisChanged(int)),
                                   SLOT(setCState(int)),
                                   m_glWidget, QString("Cardiograph"));
    m_Cardiograph->setChecked(false);

    /**
     *show polygon
     */
    m_PolyGraph = createCheckBox(SIGNAL(kAxisChanged(int)),
                                 SLOT(setKState(int)),
                                 m_glWidget, QString("Polygraph"));
    m_PolyGraph->setChecked(true);

    /**
     *show line
     */
    m_LineGraph = createCheckBox(SIGNAL(lAxisChanged(int)),
                                 SLOT(setLState(int)),
                                 m_glWidget, QString("Line"));
    m_LineGraph->setChecked(false);

    /**
     *activate x zoom-in
     */
    m_Xzoomin = createCheckBox(SIGNAL(xZoomAxisChanged(int)),
                               SLOT(setXZoomState(int)),
                               m_glWidget, QString("X Zoom-in"));
    m_Xzoomin->setChecked(false);

    /**
     *activate y zoom-in
     */
    m_Yzoomin = createCheckBox(SIGNAL(yZoomAxisChanged(int)),
                               SLOT(setYZoomState(int)),
                               m_glWidget, QString("Y Zoom-in"));
    m_Yzoomin->setChecked(false);

    /**
     *activate full zoom-in
     */
    m_Fullzoomin = createCheckBox(SIGNAL(fullZoomAxisChanged(int)),
                                  SLOT(setFullZoomState(int)),
                                  m_glWidget, QString("Full Zoom-in"));
    m_Fullzoomin->setChecked(false);

    QLabel *label_1  = new QLabel();
    QLabel *label_2  = new QLabel();
    QLabel *label_3  = new QLabel();
    QLabel *label_4  = new QLabel();
    QLabel *label_5  = new QLabel();
    QLabel *label_6  = new QLabel();
    QLabel *label_7  = new QLabel();
    QLabel *label_8  = new QLabel();
    QLabel *label_9  = new QLabel();
    QLabel *label_10 = new QLabel();
    QLabel *label_11 = new QLabel();
    QFont font = QFont("Arial", 12, QFont::Bold);
    label_1->setText("Size impact");
    label_2->setText("Cluster difference");
    label_3->setText("Column scale");
    label_4->setText("Cluster number");
    label_5->setText("Time interval");
    label_6->setText("CardioGraph");
    label_7->setText("PolyGraph");
    label_8->setText("LineGraph");
    label_9->setText("X-Zoom in");
    label_10->setText("Y-Zoom in");
    label_11->setText("Full zoom in");
    label_1->setFont(font);
    label_2->setFont(font);
    label_3->setFont(font);
    label_4->setFont(font);
    label_5->setFont(font);
    label_6->setFont(font);
    label_7->setFont(font);
    label_8->setFont(font);
    label_9->setFont(font);
    label_10->setFont(font);
    label_11->setFont(font);

    QGridLayout *subLayout = new QGridLayout;
    subLayout->addWidget(m_Cardiograph, 1, 0, Qt::AlignLeft);
    subLayout->addWidget(m_PolyGraph, 1, 1, Qt::AlignLeft);
    subLayout->addWidget(m_LineGraph, 1, 2, Qt::AlignLeft);
    subLayout->addWidget(m_Xzoomin, 1, 3, Qt::AlignLeft);
    subLayout->addWidget(m_Yzoomin, 1, 4, Qt::AlignLeft);
    subLayout->addWidget(m_Fullzoomin, 1, 5, Qt::AlignLeft);
    subLayout->addWidget(label_6, 0, 0, Qt::AlignLeft);
    subLayout->addWidget(label_7, 0, 1, Qt::AlignLeft);
    subLayout->addWidget(label_8, 0, 2, Qt::AlignLeft);
    subLayout->addWidget(label_9, 0, 3, Qt::AlignLeft);
    subLayout->addWidget(label_10, 0, 4, Qt::AlignLeft);
    subLayout->addWidget(label_11, 0, 5, Qt::AlignLeft);

    QGridLayout *centralLayout = new QGridLayout;
    centralLayout->addWidget(m_glWidgetArea, 0, 0);
    centralLayout->addWidget(m_xSlider, 2, 0);
    centralLayout->addWidget(m_ySlider, 4, 0);
    centralLayout->addWidget(m_sSlider, 6, 0);
    centralLayout->addWidget(m_kSlider, 8, 0);
    centralLayout->addWidget(m_zSlider, 10, 0);
    centralLayout->addWidget(label_1, 1, 0);
    centralLayout->addWidget(label_2, 3, 0);
    centralLayout->addWidget(label_3, 5, 0);
    centralLayout->addWidget(label_4, 7, 0);
    centralLayout->addWidget(label_5, 9, 0);
    centralLayout->addWidget(m_xBox, 2, 1);
    centralLayout->addWidget(m_yBox, 4, 1);
    centralLayout->addWidget(m_zBox, 10, 1);
    centralLayout->addWidget(m_kBox, 8, 1);
    centralLayout->addWidget(m_sBox, 6, 1);
    centralLayout->addLayout(subLayout, 11, 0);
    m_centralWidget->setLayout(centralLayout);

    connect(m_glWidget,
            SIGNAL(shiftWindow(Hierarchy*, CMap*, int, int, int, int, string)),
            this, SLOT(addWindow(Hierarchy*,CMap*,int, int, int, int, string)));

    connect(m_glWidget, SIGNAL(shiftWindow_full(Hierarchy*,CMap*,int,string)),
            this, SLOT(addWindow_full(Hierarchy*,CMap*,int,string)));

}

Window::Window(int width, int height, int pad,
               int cluster, int sender, int recver,
               QString infile_1,
               Hierarchy* &hierarchy,
               CMap* &map,
               int time,
               string time1,
               QWidget *parent)
    : QMainWindow(parent)
{
    GLWidget *glWidget = new GLWidget(width, height, pad, cluster,sender,recver,
                                      infile_1, hierarchy, map, time, time1);

    QScrollArea *glWidgetArea = new QScrollArea;
    glWidgetArea->setWidget(glWidget);
    glWidgetArea->setWidgetResizable(false);
    glWidgetArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOn);
    glWidgetArea->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOn);
    glWidgetArea->setMinimumSize(width, height);
    glWidgetArea->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    int n_init;
    /**
     *size impact
     */
    n_init = 0;
    m_xSlider = createSlider(SIGNAL(xAxisChanged(int)),
                                    SLOT(setXAxis(int)),
                                    SLOT(setGraph()), glWidget,
                                    100, 10, 0, n_init, 10);
    m_xBox = createLabel(m_xSlider, n_init);

    /**
     *graph scale
     */
    /*
    m_ySlider = createSlider(SIGNAL(sAxisChanged(int)), SLOT(setSAxis(int)),
                             SLOT(setGraph()), glWidget, 10, 1, 1, 1);
    m_ySlider->setValue(1);
    */
    n_init = 1;
    m_zSlider = createSlider(SIGNAL(subAxisChanged(int)),
                             SLOT(setSubAxis(int)),
                             SLOT(setSubCluster()),
                             glWidget, 4320, 1, 1, n_init, 1);
    m_zBox = createLabel(m_zSlider, n_init);
    /**
     *show polygon
     */
    m_PolyGraph = createCheckBox(SIGNAL(kAxisChanged(int)),
                                 SLOT(setKState(int)),
                                 glWidget, QString("Polygraph"));
    m_PolyGraph->setChecked(true);

    /**
     *show line
     */
    m_LineGraph = createCheckBox(SIGNAL(lAxisChanged(int)),
                                 SLOT(setLState(int)),
                                 glWidget, QString("Line"));
    m_LineGraph->setChecked(false);

    QLabel *label_1 = new QLabel();
    //QLabel *label_2 = new QLabel();
    QLabel *label_5 = new QLabel();
    QLabel *label_3 = new QLabel();
    QLabel *label_4 = new QLabel();
    QFont font = QFont("Arial", 12, QFont::Bold);
    label_1->setText("Size impact");
    //label_2->setText("Column scale");
    label_3->setText("PolyGraph");
    label_4->setText("LineGraph");
    label_5->setText("Cluster number");
    label_1->setFont(font);
    //label_2->setFont(font);
    label_3->setFont(font);
    label_4->setFont(font);
    label_5->setFont(font);

    QGridLayout *subLayout = new QGridLayout;
    subLayout->addWidget(m_PolyGraph, 1, 0, Qt::AlignLeft);
    subLayout->addWidget(m_LineGraph, 1, 1, Qt::AlignLeft);
    subLayout->addWidget(label_3, 0, 0, Qt::AlignLeft);
    subLayout->addWidget(label_4, 0, 1, Qt::AlignLeft);

    QGridLayout *centralLayout = new QGridLayout;
    centralLayout->addWidget(glWidgetArea, 0, 0);
    centralLayout->addWidget(m_xSlider, 2, 0);
    //centralLayout->addWidget(m_ySlider, 4, 0);
    centralLayout->addWidget(m_zSlider, 6, 0);
    centralLayout->addWidget(label_1, 1, 0);
    //centralLayout->addWidget(label_2, 3, 0);
    centralLayout->addWidget(label_5, 5, 0);
    centralLayout->addWidget(m_xBox, 2, 1);
    centralLayout->addWidget(m_zBox, 6, 1);
    centralLayout->addLayout(subLayout, 7, 0);

    QWidget *centralWidget = new QWidget;
    this->setCentralWidget(centralWidget);
    centralWidget->setLayout(centralLayout);
}

Window::Window(int width, int height, int pad,
               QString infile_1,
               Hierarchy* &hierarchy,
               CMap* &map,
               int time,
               string time1,
               QWidget *parent)
    : QMainWindow(parent)
{
    GLWidget *glWidget = new GLWidget(width, height, pad, infile_1,
                                      hierarchy, map, time, time1);
    QScrollArea *glWidgetArea = new QScrollArea;
    glWidgetArea->setWidget(glWidget);
    glWidgetArea->setWidgetResizable(false);
    glWidgetArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOn);
    glWidgetArea->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOn);
    glWidgetArea->setMinimumSize(width, height);
    glWidgetArea->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    int n_init;
    /**
     *size impact
     */
    n_init = 0;
    m_xSlider = createSlider(SIGNAL(xAxisChanged(int)),
                                    SLOT(setXAxis(int)),
                                    SLOT(setGraph()), glWidget,
                                    100, 10, 0, n_init, 10);
    m_xBox = createLabel(m_xSlider, n_init);

    /**
     *graph scale
     */
    /*
    m_ySlider = createSlider(SIGNAL(sAxisChanged(int)), SLOT(setSAxis(int)),
                             SLOT(setGraph()), glWidget, 10, 1, 1, 1);
    m_ySlider->setValue(1);
    */
    n_init = 1;
    m_zSlider = createSlider(SIGNAL(subAxisChanged(int)),
                             SLOT(setSubAxis(int)),
                             SLOT(setSubCluster()),
                             glWidget, 4320, 1, 1, n_init, 1);
    m_zBox = createLabel(m_zSlider, n_init);
    /**
     *show polygon
     */
    m_PolyGraph = createCheckBox(SIGNAL(kAxisChanged(int)),
                                 SLOT(setKState(int)),
                                 glWidget, QString("Polygraph"));
    m_PolyGraph->setChecked(true);

    /**
     *show line
     */
    m_LineGraph = createCheckBox(SIGNAL(lAxisChanged(int)),
                                 SLOT(setLState(int)),
                                 glWidget, QString("Line"));
    m_LineGraph->setChecked(false);

    QLabel *label_1 = new QLabel();
    //QLabel *label_2 = new QLabel();
    QLabel *label_5 = new QLabel();
    QLabel *label_3 = new QLabel();
    QLabel *label_4 = new QLabel();
    QFont font = QFont("Arial", 12, QFont::Bold);
    label_1->setText("Size impact");
    //label_2->setText("Column scale");
    label_3->setText("PolyGraph");
    label_4->setText("LineGraph");
    label_5->setText("Cluster number");
    label_1->setFont(font);
    //label_2->setFont(font);
    label_3->setFont(font);
    label_4->setFont(font);
    label_5->setFont(font);

    QGridLayout *subLayout = new QGridLayout;
    subLayout->addWidget(m_PolyGraph, 1, 0, Qt::AlignLeft);
    subLayout->addWidget(m_LineGraph, 1, 1, Qt::AlignLeft);
    subLayout->addWidget(label_3, 0, 0, Qt::AlignLeft);
    subLayout->addWidget(label_4, 0, 1, Qt::AlignLeft);

    QGridLayout *centralLayout = new QGridLayout;
    centralLayout->addWidget(glWidgetArea, 0, 0);
    centralLayout->addWidget(m_xSlider, 2, 0);
    //centralLayout->addWidget(m_ySlider, 4, 0);
    centralLayout->addWidget(m_zSlider, 6, 0);
    centralLayout->addWidget(label_1, 1, 0);
    //centralLayout->addWidget(label_2, 3, 0);
    centralLayout->addWidget(label_5, 5, 0);
    centralLayout->addWidget(m_xBox, 2, 1);
    centralLayout->addWidget(m_zBox, 6, 1);
    centralLayout->addLayout(subLayout, 7, 0);

    QWidget *centralWidget = new QWidget;
    this->setCentralWidget(centralWidget);
    centralWidget->setLayout(centralLayout);
}

