#ifndef SOURCEDATA_H
#define SOURCEDATA_H

#include <iostream>
#include <fstream>
#include <cstring>
#include <vector>
#include <sstream>
#include <string>
#include <cfloat>
#include <map>
#include <list>
#include <deque>
#include <algorithm>
#include <iomanip>
#include <QDebug>
#include <stdlib.h>
#include "formcluster.h"

#ifndef MYFILE
//#define MYFILE "../DATA/test"
#define MYFILE "../DATA/CaseStudy_8"
//#define MYFILE "../DATA/CaseStudy_16"
//#define MYFILE "../DATA/TOTAL"
//#define MYFILE "../DATA/TESTC"
//#define MYFILE "../DATA/CaseStudy_ISEND" //GROUNDTRUTH
//#define MYFILE "../DATA/CaseStudy_SEND"  //GROUNDTRUTH
//#define MYFILE "../DATA/CaseStudy_JOIN"  //GROUNDTRUTH
//#define MYFILE "../DATA/CHOMBO"
//#define MYFILE "../DATA/CHOMBO_EXPLOSION"
//#define MYFILE "../DATA/CHOMBO_1024"
//#define MYFILE "../DATA/CaseStudy_Chombo_Poly"
//#define MYFILE "../DATA/CaseStudy_CHOMBO_BALL"
//#define MYFILE "../DATA/GROUNDTRUTH"
//#define MYFILE "../DATA/RENDER_SYN"
//#define MYFILE "../DATA/RENDER_ASYN"
//#define MYFILE "../DATA/CHOMBO"

#endif

#ifndef MAPFILE
#define MAPFILE "../DATA/MPI/MPI_MAP"
#endif

#ifndef INTERVAL
#define INTERVAL 1
#endif

#ifndef DELTA
#define DELTA 0.5
#endif

#ifndef FACTOR
#define FACTOR 0.5
#endif

using namespace std;

typedef struct {
    int sender;
    int recver;
} send_recv_t;

typedef struct {
    double hashTime;
    double realTime;
    int size;
    string opt;
    send_recv_t send_recv;
} edge_t;

typedef struct {
    double Ldistance;
    double Rdistance;
    int Lneighbor;
    int Rneighbor;
} node_t;

class SData
{
public:

    SData();

    SData(int);

    void Begin(int);

    void Operation(int);

    void OutFile(multimap<double, edge_t> &);

    void merge_trees (vector<CClusterTree *> &trees, node_t *node,
                      d_sorted_t &sorted, CDmatrix &matrix,
                      int &clusterNum, int &maxlevel);

    void balance_tree(vector<CClusterTree *> &trees, CClusterTree *&root,
                      vector<double> &time, float delta, float factor);

    void split_tree(vector<CClusterTree *> &trees, CClusterTree *& root,
                    CClusterTree *&subroot, vector<double> &time,
                    int partition_num, float delta, float factor);

    void rotate_tree(vector<CClusterTree *> &oritrees, CClusterTree *&root,
                     CClusterTree *&node_a, CClusterTree *node_b,
                     vector<double> &time);

    //void splitInterval(string);

    //void combineInterval(string, string);

    inline vector<edge_t> &getSortTime()
    {
        return m_vSortTimeEdge;
    }

    inline int getCount()
    {
        return m_nCount;
    }

    inline double getLDistance(int x, node_t *node) {
        return node[x].Ldistance;
    }

    inline double getRDistance(int x, node_t *node) {
        return node[x].Rdistance;
    }

    inline void setLDistance(int x, node_t *node, double modularity) {
        node[x].Ldistance = modularity;
    }

    inline void setRDistance(int x, node_t *node, double modularity) {
        node[x].Rdistance = modularity;
    }

    inline void initNode(int nodeNum, node_t *node, vector<double> &time) {
        for (int i = 0; i < nodeNum; i++) {
            if (i != 0 && i != nodeNum - 1) {
                node[i].Ldistance = time[i] - time[i - 1];
                node[i].Rdistance = time[i + 1] - time[i];
                node[i].Lneighbor = i - 1;
                node[i].Rneighbor = i + 1;
            } else if (i != 0 && i == nodeNum - 1) {
                node[i].Ldistance = time[i] - time[i - 1];
                node[i].Rdistance = DBL_MAX;
                node[i].Lneighbor = i - 1;
                node[i].Rneighbor = -1;
            } else if (i == 0 && i != nodeNum - 1) {
                node[i].Ldistance = DBL_MAX;
                node[i].Rdistance = time[i + 1] - time[i];
                node[i].Lneighbor = -1;
                node[i].Rneighbor = i + 1;
            } else {
                cout << "It has only one node" << endl;
                exit(0);
            }
        }

        for (int i = nodeNum; i < 2 * nodeNum; i++) {
            node[i].Ldistance = 0;
            node[i].Rdistance = 0;
            node[i].Lneighbor = 0;
            node[i].Rneighbor = 0;
        }

    }

    inline void initTreeTime(vector<double> &time, CClusterTree *tree) {
        double d_sum = 0.0d;
        double d_result = 0.0d;
        set<int>::iterator sit;
        for (sit = tree->LeafIDs().begin(); sit != tree->LeafIDs().end(); sit++)
        {
            d_sum += time[*sit];
        }
        d_result = d_sum / (1.0 * tree->LeafNum());
        tree->setTime(d_result);
    }


    /**
     *initialize the cluster
     */
    inline void initCluster(int nodeNum, cluster_t &clusters) {
        for (int i = 0; i < nodeNum; i++) {
            clusters[i].push_back(i);
        }
    }

    /**
     * Build a maximum heap for the whole matrix.
     * modMatrix: the matrix of modularity
     */
    inline void init_load_matrix(CDmatrix &matrix,
                                 node_t *node,
                                 d_sorted_t &sorted,
                                 int row, int col,
                                 int nodeNum) {
        matrix.setSize(row, 2 * col);

        CDpair* pPair = NULL;
        string s_id;
        string s_dot = ".";
        for (int i = 0; i < nodeNum; i++) {
            if (node[i].Rneighbor != -1) {
                pPair = new CDpair;

                pPair->setA(i);
                pPair->setB(i + 1);
                pPair->Iter(sorted.insert(d_sorted_t::value_type(
                                              node[i].Rdistance, pPair)));
                s_id = to_string(i) + s_dot + to_string(i + 1);
                matrix.setPair(s_id, pPair);
            }
            else {
                pPair = new CDpair;

                pPair->setA(i);
                pPair->setB(-1);
                s_id = to_string(i) + s_dot + to_string(-1);
                pPair->Iter(sorted.insert(d_sorted_t::value_type(
                                              node[i].Rdistance, pPair)));
                matrix.setPair(s_id, pPair);
            }
        }
    }

    inline void getClusteringRes(cluster_t clusters)
    {
        for (cluster_t::iterator iter = clusters.begin();
             iter != clusters.end(); iter++) {
            if ((*iter).second.size() != 0) {
                cout << "cluster " << (*iter).first << " : ";
                for (vector<int>::iterator iter_vec = (*iter).second.begin();
                     iter_vec != (*iter).second.end(); iter_vec++) {
                    cout<<*iter_vec<<" ";
                }
                cout << endl;
            }
        }
    }

    inline void init_trees(trees_t &trees, int line_num)
    {
        trees.clear();
        for (int i = 0; i < line_num; i++) {
            CClusterTree *tree = new CClusterTree;
            assert(tree);

            tree->Child_L(NULL);
            tree->Child_R(NULL);
            tree->ID(trees.size());
            tree->Level(0);
            tree->LeafIDs().insert(trees.size());

            assert(i == (int)(trees.size()));

            trees.push_back(tree);
        }

        if (trees.size() != (unsigned int)line_num) {
            cerr << "the tree size is not equal to line number!" << endl;
            exit(0);
        }
    }

    inline void save_tree(CClusterTree *tree, ofstream &outf)
    {
        int id = -1;
        int level = -1;
        int size = 0;
        set<int>::iterator sit;
        if (tree == NULL) {
            outf.write(reinterpret_cast<char *>(&level), sizeof(int));
            return;
        }

        /* tree level */
        level = tree->Level();
        outf.write(reinterpret_cast<char *>(&level), sizeof(int));

        /* tree id */
        id = tree->ID();
        outf.write(reinterpret_cast<char *>(&id), sizeof(int));

        /* leaf ids */
        size = tree->LeafIDs().size();
        outf.write(reinterpret_cast<char *>(&size), sizeof(int));
        for (sit = tree->LeafIDs().begin();
             sit != tree->LeafIDs().end();
             sit++)
        {
            id = *sit;
            outf.write(reinterpret_cast<char *>(&id), sizeof(int));
        }

        save_tree(tree->Child_L(), outf);
        save_tree(tree->Child_R(), outf);
    }

    inline void read_tree(CClusterTree * &tree,
                          ifstream &inf,
                          CClusterTree *parent = NULL)
    {
        int id = -1;
        int level = -1;
        int size = 0;

        /* tree level */
        inf.read(reinterpret_cast<char *>(&level), sizeof(int));

        if (level == -1) {
            tree = NULL;
            return;
        }

        tree = new CClusterTree;
        assert(tree);

        tree->Level(level);

        /* parent */
        tree->Parent(parent);

        /* tree id */
        inf.read(reinterpret_cast<char *>(&id), sizeof(int));
        tree->ID(id);

        /* leaf ids */
        inf.read(reinterpret_cast<char *>(&size), sizeof(int));
        for (int i = 0; i < size; i++) {
            inf.read(reinterpret_cast<char *>(&id), sizeof(int));
            tree->LeafIDs().insert(id);
        }

        read_tree(tree->Child_L(), inf, tree);
        read_tree(tree->Child_R(), inf, tree);
    }

    /**
     * DFS traverse the tree
     */
    inline void CollectClusterTree(CClusterTree *tree,
                                   int parent,
                                   int threshold,
                                   vector<int> &Clusters,
                                   vector<CClusterTree*> &ClusterTree)
    {
        if (tree == NULL || parent < threshold) {
            return;
        }

        if (tree->Level() <= threshold && parent > threshold)
        {
            Clusters.push_back(tree->ID());
            ClusterTree.push_back(tree);
        } else {
            CollectClusterTree(tree->Child_L(), tree->Level(),
                               threshold, Clusters, ClusterTree);
            CollectClusterTree(tree->Child_R(), tree->Level(),
                               threshold, Clusters, ClusterTree);
        }
    }

    /**
     *merge cluster1 into cluster2 for the balance tree
     */
    inline void updateDistance(node_t *node, int A, int B, int ID) {
        int n_Left = node[A].Lneighbor;
        int n_Right = node[B] .Rneighbor;
        double modularity;
        /* update the left neighbor */
        if (node[A].Lneighbor != -1) {
            modularity = getRDistance(A, node) / 2
                                       + getRDistance(n_Left, node);
            setRDistance(n_Left, node, modularity);
            setLDistance(ID, node, modularity);
        } else {
            modularity = DBL_MAX;
            setLDistance(ID, node, modularity);
            node[ID].Lneighbor = -1;
        }
         /* update the right neighbor */
        if (node[B].Rneighbor != -1) {
            modularity = getLDistance(B, node) / 2
                                       + getLDistance(n_Right, node);
            setLDistance(n_Right, node, modularity);
            setRDistance(ID, node, modularity);
        } else {
            modularity = DBL_MAX;
            setRDistance(ID, node, modularity);
            node[ID].Rneighbor = -1;
        }
    }

    inline CClusterTree *do_clustering(vector<CClusterTree *> &trees,
                                       node_t *node,
                                       d_sorted_t &sorted,
                                       CDmatrix& matrix,
                                       vector<double> &time,
                                       int& clusterNum)
    {
        //int totalsize = trees.size();
        int maxlevel = 0;
        float delta = 0.0f;
        float factor = 0.0f;

        while(clusterNum > INTERVAL && sorted.size() > 0) {
            merge_trees(trees, node, sorted, matrix,
                        clusterNum, maxlevel);
        }

        CClusterTree *root = *(trees.rbegin());
        delta = DELTA;
        factor = FACTOR;
        if (delta > 0.0f) {
            balance_tree(trees, root, time, delta, factor);
        } else {
            cout << "Time interval skip balancing" << endl;
        }
        return root;
    }

    inline void traverse_tree(vector<CClusterTree *> &trees,
                              CClusterTree *&tree)
    {
        assert(tree != NULL);
        trees.push_back(tree);
        if (tree->Child_R() != NULL) {
            traverse_tree(trees, tree->Child_R());
        }

        if (tree->Child_L() != NULL) {
            traverse_tree(trees, tree->Child_L());
        }
    }

    inline void delete_tree(vector<CClusterTree *> &trees)
    {
        for (size_t i = 0; i < trees.size(); i++) {
            if (trees[i] != NULL) {
                delete trees[i];
                trees[i] = NULL;
            }

        }
    }

    inline void zoomInitialize(int cluster)
    {
        int                             n_clusters;
        CClusterTree                    *root;
        CClusterTree                    *parent;

        string strTREE = "../DATA/TIME/TIME";
        ifstream inf(strTREE.c_str());
        read_tree(root, inf, parent);
        inf.close();

        assert(root != NULL);

        m_vClusters.clear();
        m_vClusterTree.clear();

        if (cluster < m_nNodeNum) {
            n_clusters = m_nNodeNum - cluster;
        } else {
            n_clusters = m_nNodeNum - m_nNodeNum;
        }
        CollectClusterTree(root, root->Level() + 1, n_clusters,
                           m_vClusters, m_vClusterTree);
        m_pRoot = root;
    }

    inline void zoomFlush()
    {
        vector<CClusterTree*> trees;
        traverse_tree(trees, m_pRoot);
        delete_tree(trees);
    }

private:

    vector<int>                     m_vEntities;
    vector<double>                  m_vSortRealTime;
//    vector<time_point>              m_vSortTimeEdge;
    vector<edge_t>                  m_vSortTimeEdge;
    vector<int>                     m_vClusters;
    vector<CClusterTree*>           m_vClusterTree;
    map<string, int>                m_mTreeMap;

    vector<edge_t>                  *e_tmpVct;
    /* GML graph */
    list<edge_t>                    *e_outList;
    /* GML graph */
    list<edge_t>                    *e_outTotal;

    CClusterTree                    *m_pRoot;

    int                             m_nCount;
    int                             m_nNodeIDs;
    int                             m_nNodeNum;

    string to_string(int input) {
        string result;
        ostringstream convert;
        convert << input;
        result = convert.str();
        return result;
    }

    string to_string(double input) {
        string result;
        ostringstream convert;
        convert << setprecision(12) << input;
        result = convert.str();
        return result;
    }
};

#endif // SOURCEDATA_H
