#include "sourcedata.h"

SData::SData()
{

}

void SData::Begin(int cluster)
{
    cout << "================time hierarchy begins===============" << endl;
    system("exec rm -r ../DATA/TIME/TIME");

    string sender, recver, size, opt;
    double time;
    int n_numOfLines = 0;
    ifstream inTmp(MYFILE);
    if (inTmp.is_open()) {
        while (!inTmp.eof()) {
            inTmp >> sender >> recver >> size >> time >> opt;
            if (inTmp.fail()) {
                break;
            }
            n_numOfLines++;
        }
    } else {
        cout << "Cannot open the file " << MYFILE << "!" << endl;
    }
    inTmp.close();

    int num = 0;
    m_vEntities.clear();

    edge_t *p_edge = new edge_t[n_numOfLines];
    multimap<double, edge_t>    mm_sortMap;

    ifstream inFile(MYFILE);
    if (inFile.is_open()) {
        while (!inFile.eof()) {
            inFile >> sender >> recver >> size >> time >> opt;
            if (inFile.fail()) {
                break;
            }
            double d_tmp_time = time;
            p_edge[num].send_recv.sender = atoi(sender.c_str());
            p_edge[num].send_recv.recver = atoi(recver.c_str());
            p_edge[num].size             = atoi(size.c_str());
            p_edge[num].realTime         = d_tmp_time;
            p_edge[num].hashTime         = 0;
            p_edge[num].opt              = opt;
            m_vEntities.push_back(atoi(sender.c_str()));
            m_vEntities.push_back(atoi(recver.c_str()));
            mm_sortMap.insert(pair<double, edge_t>(d_tmp_time, p_edge[num]));
            num++;
        }
    } else {
        cout << "Cannot open the file!" << endl;
    }
    inFile.close();

    m_nNodeNum      = n_numOfLines;
    m_nNodeIDs      = n_numOfLines;
    int clusterNum  = n_numOfLines;

    node_t *node = new node_t[m_nNodeNum * 2];

    multimap<double, edge_t>::iterator ita;
    for (ita = mm_sortMap.begin(); ita != mm_sortMap.end(); ita++) {
        m_vSortRealTime.push_back((*ita).first);
        m_vSortTimeEdge.push_back((*ita).second);
    }

    int n_Row = 1;
    int n_Col = m_nNodeNum;

    CDmatrix              cmatrix;
    d_sorted_t            sorted;
    CClusterTree          *root;
    vector<CClusterTree*> trees;

    initNode(m_nNodeNum, node, m_vSortRealTime);
    init_trees(trees, n_numOfLines);
    init_load_matrix(cmatrix, node, sorted, n_Row, n_Col, m_nNodeNum);
    root = do_clustering(trees, node, sorted, cmatrix, m_vSortRealTime, clusterNum);

    assert(root != NULL);
    string strTREE = "../DATA/TIME/TIME";
    ofstream out(strTREE.c_str());
    save_tree(root, out);
    out.close();

    assert(clusterNum == INTERVAL);
    assert(m_vSortRealTime.size() == m_vSortTimeEdge.size());

    delete_tree(trees);
    delete[] node;
    node = NULL;

    Operation(cluster);
}

void SData::Operation(int cluster)
{
    system("exec rm -r ../DATA/GML/*");
    system("exec rm -r ../DATA/MPI/MPI");
    system("exec rm -r ../DATA/MPI/MPI_TOTAL");

    int                             n_clusters;
    CClusterTree                    *root;
    CClusterTree                    *parent;
    vector<int>                     v_clusters;
    vector<CClusterTree *>          v_clusterTree;
    vector<CClusterTree *>          trees;
    multimap<double, edge_t>        m_timeEvent;

    if (cluster < m_nNodeNum) {
        n_clusters = m_nNodeNum - cluster;
    } else {
        n_clusters = m_nNodeNum - m_nNodeNum;
    }

    string strTREE = "../DATA/TIME/TIME";
    ifstream inf(strTREE.c_str());
    read_tree(root, inf, parent);
    inf.close();

    assert(root != NULL);

    m_timeEvent.clear();

    CollectClusterTree(root, root->Level() + 1, n_clusters,
                       v_clusters, v_clusterTree);

    double d_hashtime;
    string s_hashtime;
    m_mTreeMap.clear();
    set<int>::iterator sitr;
    for (size_t i = 0; i < v_clusterTree.size(); i++) {
        sitr = v_clusterTree[i]->LeafIDs().begin();
        d_hashtime = m_vSortRealTime[*sitr];
        s_hashtime = to_string(d_hashtime);
        m_mTreeMap[s_hashtime] = v_clusterTree[i]->ID();
        for (sitr = v_clusterTree[i]->LeafIDs().begin();
             sitr != v_clusterTree[i]->LeafIDs().end();
             sitr++) {
            if (*sitr < m_nNodeNum) {
                m_timeEvent.insert(pair<double, edge_t>(d_hashtime,
                                                        m_vSortTimeEdge[*sitr]));
            }
        }
    }

//    multimap<double, edge_t>::iterator itr;
//    for (itr = m_timeEvent.begin(); itr != m_timeEvent.end(); itr++) {
//        cout << setprecision(12) << itr->first << " ";
//        cout << itr->second.send_recv.sender << " ";
//        cout << itr->second.send_recv.recver << " ";
//        cout << itr->second.size << " ";
//        cout << setprecision(20) << itr->second.realTime << " ";
//        cout << itr->second.opt << " ";
//        cout << endl;
//    }

    traverse_tree(trees, root);
    delete_tree(trees);

    OutFile(m_timeEvent);
    cout << "Time clustering finished" << endl;
}

/*
void SData::splitInterval(string str)
{
    CClusterTree                    *tree;
    vector<int>                     v_clusters;
    vector<CClusterTree*>           v_clusterTree;
    multimap<double, edge_t>        m_timeEvent;

    m_timeEvent.clear();

    assert(m_vClusters.size() == m_vClusterTree.size());
    assert(m_vClusters.size() > 0);

    int n_split = -1;
    n_split = m_mTreeMap[str];
    for (int i = 0; i < m_vClusters.size(); i++) {
        if (m_vClusters[i] == n_split) {
            tree = m_vClusterTree[i];
        } else {
            assert(m_vClusterTree[i]->ID() == m_vClusters[i]);
            v_clusterTree.push_back(m_vClusterTree[i]);
            v_clusters.push_back(m_vClusters[i]);
        }
    }
    if (tree->Child_L() != NULL && tree->Child_R() != NULL
            && tree->Child_L()->Parent() == tree->Child_R()->Parent()) {
        v_clusters.push_back(tree->Child_L()->ID());
        v_clusters.push_back(tree->Child_R()->ID());
        v_clusterTree.push_back(tree->Child_L());
        v_clusterTree.push_back(tree->Child_R());
    } else {
        v_clusters.push_back(tree->ID());
        v_clusterTree.push_back(tree);
    }

    m_vClusters.clear();
    m_vClusterTree.clear();
    m_vClusters = v_clusters;
    m_vClusterTree = v_clusterTree;

    double d_hashtime;
    string s_hashtime;
    m_mTreeMap.clear();
    set<int>::iterator sitr;
    for (size_t i = 0; i < v_clusterTree.size(); i++) {
        sitr = v_clusterTree[i]->LeafIDs().begin();
        d_hashtime = m_vSortRealTime[*sitr];
        s_hashtime = to_string(d_hashtime);
        m_mTreeMap[s_hashtime] = v_clusterTree[i]->ID();
        for (sitr = v_clusterTree[i]->LeafIDs().begin();
             sitr != v_clusterTree[i]->LeafIDs().end();
             sitr++) {
            if (*sitr < m_nNodeNum) {
                m_timeEvent.insert(pair<double, edge_t>(d_hashtime,
                                    m_vSortTimeEdge[*sitr]));
            }
        }
    }
    OutFile(m_timeEvent);
}
*/

/*
void SData::combineInterval(string str1, string str2)
{
    system("rm -r ../DATA/GML/*");
    system("exec rm -r ../DATA/MPI/MPI");
    system("exec rm -r ../DATA/MPI/MPI_TOTAL");

    CClusterTree                    *tree1;
    CClusterTree                    *tree2;
    vector<int>                     v_clusters;
    vector<CClusterTree*>           v_clusterTree;
    multimap<double, edge_t>        m_timeEvent;

    int n_split1, n_split2;
    n_split1 = m_mTreeMap[str1];
    n_split2 = m_mTreeMap[str2];
    for (size_t i = 0; i < m_vClusters.size(); i++) {
        if (m_vClusters[i] == n_split1) {
            tree1 = m_vClusterTree[i];
        } else if (m_vClusters[i] == n_split2) {
            tree2 = m_vClusterTree[i];
        } else {
            assert(m_vClusterTree[i]->ID() == m_vClusters[i]);
            v_clusterTree.push_back(m_vClusterTree[i]);
            v_clusters.push_back(m_vClusters[i]);
        }
    }

    assert(tree1 != NULL);
    assert(tree2 != NULL);

    if (tree1 == tree2) {
        v_clusters.push_back(tree1->ID());
        v_clusterTree.push_back(tree1);
    } else {
        if (tree1->Parent() == tree2->Parent()) {
            v_clusters.push_back(tree1->Parent()->ID());
            v_clusterTree.push_back(tree1->Parent());
        } else {
            v_clusters.push_back(tree1->ID());
            v_clusterTree.push_back(tree1);
            v_clusters.push_back(tree2->ID());
            v_clusterTree.push_back(tree2);
        }
    }

    m_vClusters.clear();
    m_vClusterTree.clear();
    m_vClusters = v_clusters;
    m_vClusterTree = v_clusterTree;

    double d_hashtime;
    string s_hashtime;
    m_mTreeMap.clear();
    set<int>::iterator sitr;
    for (size_t i = 0; i < v_clusterTree.size(); i++) {
        sitr = v_clusterTree[i]->LeafIDs().begin();
        d_hashtime = m_vSortRealTime[*sitr];
        s_hashtime = to_string(d_hashtime);
        m_mTreeMap[s_hashtime] = v_clusterTree[i]->ID();
        for (sitr = v_clusterTree[i]->LeafIDs().begin();
             sitr != v_clusterTree[i]->LeafIDs().end();
             sitr++) {
            if (*sitr < m_nNodeNum) {
                m_timeEvent.insert(pair<double, edge_t>(d_hashtime,
                                    m_vSortTimeEdge[*sitr]));
            }
        }
    }

    OutFile(m_timeEvent);
}
*/

void SData::OutFile(multimap<double, edge_t> &m_timeEvent) {
    vector<double>                  v_Interval;
    multimap<double, edge_t>        m_time_edge;
    multimap<double, edge_t>::iterator itr;
    for (itr = m_timeEvent.begin(); itr != m_timeEvent.end(); itr++) {
        (*itr).second.hashTime = (*itr).first;
        m_time_edge.insert(pair<double, edge_t>((*itr).first, (*itr).second));
        v_Interval.push_back((*itr).first);
    }

    std::sort(m_vEntities.begin(), m_vEntities.end());
    m_vEntities.erase(std::unique(m_vEntities.begin(),
        m_vEntities.end()), m_vEntities.end());

    int n_size = m_vEntities.size();
    int max = m_vEntities[n_size - 1];
    m_vEntities.clear();
    for (int i = 0; i <= max; i++) {
        m_vEntities.push_back(i);
    }

    std::sort(v_Interval.begin(), v_Interval.end());
    v_Interval.erase(std::unique(v_Interval.begin(),
           v_Interval.end()), v_Interval.end());

    map<double, int> m_Time;
    for (size_t i = 0; i < v_Interval.size(); i++)
    {
        m_Time[v_Interval[i]] = i;
    }

    //cout << v_Interval.size() << endl;

    edge_t e_tmp;

    /**
     *seperate different time interval
     */

    /**
     *MPI activities
     */
    e_tmpVct = new vector<edge_t>[v_Interval.size()];
    /**
     *GML graph
     */
    e_outList = new list<edge_t>[v_Interval.size()];
    /**
     *GML graph
     */
    e_outTotal = new list<edge_t>[v_Interval.size()];
    for (itr = m_time_edge.begin(); itr != m_time_edge.end(); itr++) {
        e_tmp.send_recv.sender
           = (*itr).second.send_recv.sender;
        e_tmp.send_recv.recver
           = (*itr).second.send_recv.recver;
        e_tmp.size = (*itr).second.size;
        e_tmp.hashTime = (*itr).second.hashTime;
        e_tmp.realTime = (*itr).second.realTime;
        e_tmp.opt = (*itr).second.opt;

        e_tmpVct[m_Time[e_tmp.hashTime]].push_back(e_tmp);
    }

    /*
     *  sum up the amount from one to another
     */
    //vector<edge_t> *tmpList = new vector<edge_t>[v_Interval.size()];
    for (size_t i = 0; i < v_Interval.size(); i++) {
        map<string, int> m_match;
        map<string, int>::iterator it;
        for (size_t j = 0; j < e_tmpVct[i].size(); j++) {
           string s_tmp_2 = to_string(e_tmpVct[i][j].send_recv.sender) + "."
                          + to_string(e_tmpVct[i][j].send_recv.recver);
           it = m_match.find(s_tmp_2);
           if (it != m_match.end()) {
               int n_tmp_size = e_tmpVct[i][j].size;
               m_match[s_tmp_2] += n_tmp_size;
           }
           else {
               int n_tmp_size = e_tmpVct[i][j].size;
               m_match[s_tmp_2] = n_tmp_size;
           }
        }
        for (it = m_match.begin(); it != m_match.end(); it++) {
           string s_tmp_3 = it->first;
           int n_pos = it->first.find(".");
           int n_size = m_match[s_tmp_3];
           double d_time = v_Interval[i];
           string s_tmp_sender = it->first.substr(0, n_pos);
           string s_tmp_recver = it->first.substr(n_pos + 1, it->first.size());

           e_tmp.send_recv.sender = atoi(s_tmp_sender.c_str());
           e_tmp.send_recv.recver = atoi(s_tmp_recver.c_str());
           e_tmp.hashTime 	      = d_time;
           e_tmp.size 	       	  = n_size;
           e_outList[i].push_back(e_tmp);
           e_outTotal[i].push_back(e_tmp);
           //tmpList[i].push_back(e_tmp);
        }
    }

    /*
    string out_s_10 = "../DATA/MPI/TEST_RESULT";
    char *outChar_10 = const_cast<char *>(out_s_10.c_str());
    ofstream outFile_10(outChar_10);
    for (int i = 2; i < 3; i++) {
        for (int j = 0; j < tmpList[i].size(); j++) {
            outFile_10 << tmpList[i][j].send_recv.sender
                       << " "
                       << tmpList[i][j].send_recv.recver
                       << " "
                       << tmpList[i][j].size
                       << " "
                       << setprecision(12) << tmpList[i][j].hashTime
                       << " "
                       << tmpList[i][j].opt
                       << endl;
        }
    }
    outFile_10.close();
    */

    string out_s_0 = "../DATA/MPI/MPI_TOTAL";
    char *outChar_0 = const_cast<char *>(out_s_0.c_str());
    ofstream outFile_0(outChar_0);
    for (size_t i = 0; i < v_Interval.size(); i++) {
        while (!e_outTotal[i].empty()) {
            outFile_0 << "Sender: " << e_outTotal[i].front().send_recv.sender
                      << " Recver: " << e_outTotal[i].front().send_recv.recver
                      << " size: "  << e_outTotal[i].front().size
                      << " hashTime: "
                      << setprecision(12) << e_outTotal[i].front().hashTime
                      << endl;
            e_outTotal[i].pop_front();
        }
    }
    outFile_0.close();

    /*
    string out_s_1 = "../DATA/MPI/MPI";
    char *outChar_1 = const_cast<char *>(out_s_1.c_str());
    ofstream outFile_1(outChar_1);
    for (int i = 0; i < v_Interval.size(); i++) {
        for (int j = 0; j < e_tmpVct[i].size(); j++) {
            if (i == (v_Interval.size() - 1) &&
               (j == (e_tmpVct[i].size() - 1))) {
                outFile_1 	<< "Sender: " << e_tmpVct[i][j].send_recv.sender
                            << " Recver: " << e_tmpVct[i][j].send_recv.recver
                            << " size: " << e_tmpVct[i][j].size
                            << " hashTime: "
                            << setprecision(12) << e_tmpVct[i][j].hashTime
                            << " realTime: "
                            << setprecision(12) << e_tmpVct[i][j].realTime
                            << " opt: " << e_tmpVct[i][j].opt;
            } else {
                outFile_1 	<< "Sender: " << e_tmpVct[i][j].send_recv.sender
                            << " Recver: " << e_tmpVct[i][j].send_recv.recver
                            << " size: " << e_tmpVct[i][j].size
                            << " hashTime: "
                            << setprecision(12) << e_tmpVct[i][j].hashTime
                            << " realTime: "
                            << setprecision(12) << e_tmpVct[i][j].realTime
                            << " opt: " << e_tmpVct[i][j].opt
                            << endl;
            }
        }
    }
    outFile_1.close();
    */

    for (size_t i = 0; i < v_Interval.size(); i++) {
        //int n_id = 1;
        stringstream out;
        string s_sum = "";
        out << i;
        if (i <= 9) {
            s_sum = "0";
        }
        string out_s_1 = "../DATA/GML/KARATE_"
                            + s_sum + out.str() + ".gml";
        char *outChar_1 = const_cast<char *>(out_s_1.c_str());
        ofstream outFile_2(outChar_1);
        for (size_t j = 0; j < m_vEntities.size(); j++) {
            outFile_2 	<< "node[ id "
                        //<< m_vEntities[j] + n_id
                        << m_vEntities[j]
                        << " ]"
                        << endl;
        }
        while (!e_outList[i].empty()) {
            if (e_outList[i].size() == 1) {
                outFile_2	<< "edge[ source "
                            //<< e_outList[i].front().send_recv.sender + n_id
                            << e_outList[i].front().send_recv.sender
                            << " "
                            << "target "
                            //<< e_outList[i].front().send_recv.recver + n_id
                            << e_outList[i].front().send_recv.recver
                            << " ]";
                e_outList[i].pop_front();
            } else {
                outFile_2	<< "edge[ source "
                            //<< e_outList[i].front().send_recv.sender + n_id
                            << e_outList[i].front().send_recv.sender
                            << " "
                            << "target "
                            //<< e_outList[i].front().send_recv.recver + n_id
                            << e_outList[i].front().send_recv.recver
                            << " ]"
                            << endl;
                e_outList[i].pop_front();

            }
        }
        outFile_2.close();
    }
    m_nCount = v_Interval.size();

    delete[] e_tmpVct;
    e_tmpVct = NULL;
    delete[] e_outList;
    e_outList = NULL;
    delete[] e_outTotal;
    e_outTotal = NULL;
}

/**
 * We follow the guideline that when we merge two cluster A and B,
 * we mean join A to B.
 */
void SData::merge_trees (vector<CClusterTree *> &trees,
                         node_t *node,
                         d_sorted_t &sorted,
                         CDmatrix &matrix,
                         int &clusterNum,
                         int &maxlevel) {
    int n_Left;
    int n_Right;
    if (sorted.size() == 0) {
        //cerr<< "No pair available." <<endl;
        return;
    }

    CDpair* pPair = sorted.begin()->second;
    int A = pPair->getA();
    int B = pPair->getB();
    //cout << "A: " << A << ", B: " << B <<endl;

    updateDistance(node, A, B, m_nNodeIDs);
    clusterNum--;

    n_Left = node[A].Lneighbor;
    n_Right = node[B].Rneighbor;

    node[m_nNodeIDs].Lneighbor = n_Left;
    node[m_nNodeIDs].Rneighbor = n_Right;

    string s_id;
    string s_dot = ".";

    s_id = to_string(A) + s_dot + to_string(B);
    pPair = matrix.getPair(s_id);
    if (pPair != NULL) {
        sorted.erase(pPair->Iter());
        delete pPair;
        matrix.erasePair(s_id);
    }

    s_id = to_string(n_Left) + s_dot + to_string(A);
    pPair = matrix.getPair(s_id);
    if (pPair != NULL) {
        sorted.erase(pPair->Iter());
        delete pPair;
        matrix.erasePair(s_id);
    }

    s_id = to_string(B) + s_dot + to_string(n_Right);
    pPair = matrix.getPair(s_id);
    if (pPair != NULL) {
        sorted.erase(pPair->Iter());
        delete pPair;
        matrix.erasePair(s_id);
    }

    CDpair* tmpLPair = NULL;
    if (node[m_nNodeIDs].Lneighbor != -1) {
        tmpLPair = new CDpair;
        tmpLPair->setA(n_Left);
        tmpLPair->setB(m_nNodeIDs);
        tmpLPair->Iter(sorted.insert(d_sorted_t::value_type(
                                        node[n_Left].Rdistance,
                                        tmpLPair)));
        s_id = to_string(n_Left) + s_dot + to_string(m_nNodeIDs);
        matrix.setPair(s_id, tmpLPair);
        node[n_Left].Rneighbor = m_nNodeIDs;
    }

    CDpair* tmpRPair = NULL;
    if (node[m_nNodeIDs].Rneighbor != -1) {
        tmpRPair = new CDpair;
        tmpRPair->setA(m_nNodeIDs);
        tmpRPair->setB(n_Right);
        tmpRPair->Iter(sorted.insert(d_sorted_t::value_type(
                                        node[m_nNodeIDs].Rdistance,
                                        tmpRPair)));
        s_id = to_string(m_nNodeIDs) + s_dot + to_string(n_Right);
        matrix.setPair(s_id, tmpRPair);
        node[n_Right].Lneighbor = m_nNodeIDs;
    }
    node[A].Rneighbor = -1;
    node[A].Lneighbor = -1;
    node[B].Rneighbor = -1;
    node[B].Lneighbor = -1;

    CClusterTree *new_tree = new CClusterTree;
    assert(new_tree);

    new_tree->LeafIDs().insert(trees[A]->LeafIDs().begin(),
                               trees[A]->LeafIDs().end());
    new_tree->LeafIDs().insert(trees[B]->LeafIDs().begin(),
                               trees[B]->LeafIDs().end());

    new_tree->Child_L(trees[A]);
    new_tree->Child_R(trees[B]);
    maxlevel++;
    new_tree->Level(maxlevel);
    new_tree->ID(m_nNodeIDs);
    trees[A]->Parent(new_tree);
    trees[B]->Parent(new_tree);
    trees.push_back(new_tree);

    assert(m_nNodeIDs == (int)trees.size() - 1);
    m_nNodeIDs++;
}

void SData::balance_tree(vector<CClusterTree *> &trees,
                         CClusterTree *&root,
                         vector<double> &time,
                         float delta,
                         float factor)
{
    multimap<int, CClusterTree**, greater<int> > partitions;

    partitions.insert(pair<int, CClusterTree**>(root->LeafNum(), &root));

    unsigned int maxpartition = root->Level();

    //int new_level = root->Level() * 2;
    //root->Level(new_level--);

    //int total_id = root->ID() + 1;

    while(partitions.size() <= maxpartition) {
        //cerr << "processing " << partitions.size() << '\r';

        CClusterTree** cand = partitions.begin()->second;
        /*
        cerr << "================" << endl;
        cerr << "cand " << (*cand)->LeafNum() << endl;
        cerr << "L    " << (*cand)->Child_L()->LeafNum() << endl;
        cerr << "R    " << (*cand)->Child_R()->LeafNum() << endl;
        */
        split_tree(trees, root, (*cand), time,
                   partitions.size() + 1, delta, factor);

        partitions.erase(partitions.begin());

        if ((*cand)->Child_L() != NULL) {
            partitions.insert(pair<int,
                    CClusterTree**>((*cand)->Child_L()->LeafNum(),
                        &((*cand)->Child_L())));
        }

        if ((*cand)->Child_R() != NULL) {
            partitions.insert(pair<int,
                    CClusterTree**>((*cand)->Child_R()->LeafNum(),
                        &((*cand)->Child_R())));
        }
    }

    /**
     *update level
     */
    partitions.clear();
    partitions.insert(pair<int, CClusterTree**>(root->LeafNum(), &root));
    int curt_level = maxpartition;

    while(partitions.size() <= maxpartition) {
        CClusterTree** cand = partitions.begin()->second;

        (*cand)->Level(curt_level);
        curt_level--;

        partitions.erase(partitions.begin());

        if ((*cand)->Child_L() != NULL) {
            partitions.insert(pair<int, CClusterTree**>
                          ((*cand)->Child_L()->LeafNum(),
                           &((*cand)->Child_L())));
        }

        if ((*cand)->Child_R() != NULL) {
            partitions.insert(pair<int, CClusterTree**>
                          ((*cand)->Child_R()->LeafNum(),
                           &((*cand)->Child_R())));
        }
    }
}

void SData::split_tree(vector<CClusterTree *> &trees,
                       CClusterTree *& root,
                       CClusterTree *&subroot,
                       vector<double> &time,
                       int partition_num,
                       float delta,
                       float factor)
{
    //float delta = 0.5;
    //float delta = 0.1;

    int avg_leafnum = (int)(root->LeafNum() * delta / partition_num);

    assert(!subroot->IsLeaf());

    /**
     *check if rotation is needed
     */
    if (subroot->Child_L()->LeafNum() > avg_leafnum &&
        subroot->Child_R()->LeafNum() > avg_leafnum)
    {
        return;
    }

    /**
     *go through all the nodes of subroot according to the level number,
     *and stop when the node's leaf number meets the threshold
     */
    multimap<int, CClusterTree *, greater<int> > msorted;

    msorted.insert(pair<int, CClusterTree*>(subroot->Child_L()->LeafNum(),
                                            subroot->Child_L()));

    msorted.insert(pair<int, CClusterTree*>(subroot->Child_R()->LeafNum(),
                                            subroot->Child_R()));

    int sub_size = subroot->LeafNum();

    CClusterTree *found = NULL;
    int my_partition_num = partition_num + 1;

    while(msorted.size() > 0) {
        CClusterTree *test = msorted.begin()->second;

        int my_num = test->LeafNum();
        int sibling_num = test->Sibling()->LeafNum();
        int other_num = sub_size - my_num;

        /**
         *float fact = 0.5f;
         */
        int my_avg_leafnum = (int)(root->LeafNum() * delta
                                   / my_partition_num);

        if (my_num >= my_avg_leafnum &&
            other_num >= my_avg_leafnum &&
            sibling_num >= my_num * factor) {
            found = test;
            break;
        }

        if (test->LeafNum() == 1) {
            found = test;
            break;
        }

        msorted.erase(msorted.begin());

        if (test->Child_L()) {
            msorted.insert(pair<int, CClusterTree*>(test->Child_L()->LeafNum(),
                                                    test->Child_L()));
        }
        if (test->Child_R()) {
            msorted.insert(pair<int, CClusterTree*>(test->Child_R()->LeafNum(),
                                                    test->Child_R()));
        }

        my_partition_num++;
    }

    if (found == NULL) {
        cerr << "Can not find the desired tree node" << endl;
        cerr << "avg number " << avg_leafnum << " sub_size " << sub_size
             << endl;
        exit(0);
    }

    rotate_tree(trees, root, subroot, found->Parent(), time);
}

void SData::rotate_tree(vector<CClusterTree *> &oritrees,
                        CClusterTree *&root,
                        CClusterTree *&node_a,
                        CClusterTree *node_b,
                        vector<double> &time)
{
    if (node_a == NULL || node_b == NULL) {
        cerr << "Impossible case : target_node is null" << endl;
        exit(1);
    }

    if (node_b->IsLeaf()) {
        cerr << "Impossible case : node_b can not be leaf." << endl;
        exit(1);
    }

    if (node_b == node_a) {
        //cerr << "Don't need to be adjusted because node_b is node_a"
        //     << endl;
        return;
    }

    /**
     *gather trees
     */
    vector<CClusterTree *> trees;

    node_b->Child_L()->Flag(1);
    node_b->Child_R()->Flag(1);

    trees.push_back(node_b->Child_L());
    trees.push_back(node_b->Child_R());

    CClusterTree *prev = node_b;
    CClusterTree *curt = node_b->Parent();
    while(prev != node_a) {
        CClusterTree *temp = curt->OtherChild(prev);
        trees.push_back(temp);
        prev = curt;
        curt = curt->Parent();
    }

    /**
     *initial matrix and sorted list
     */
    int total = trees.size();
    node_t *node = new node_t[total * 2];

    CDmatrix matrix;
    matrix.setSize(1, total * 2);

    for (int i = 0; i < total; i++) {
        initTreeTime(time, trees[i]);
    }

    multimap<double, CClusterTree*> mm_sortTime;
    for (int i = 0; i < total; i++) {
        mm_sortTime.insert(pair<double, CClusterTree*>(trees[i]->getTime(),
                    trees[i]));
    }
    trees.clear();
    vector<double> v_tmpTime;
    multimap<double, CClusterTree*>::iterator mmit;
    for (mmit = mm_sortTime.begin(); mmit != mm_sortTime.end(); mmit++) {
        v_tmpTime.push_back(mmit->first);
        trees.push_back(mmit->second);
    }

    initNode(total, node, v_tmpTime);
    d_sorted_t sorted;

    CDpair* pPair = NULL;
    string s_id;
    string s_dot = ".";
    double distance;
    //bool b;
    for (int i = 0; i < total; i++) {
        if (node[i].Rneighbor != -1) {
            CClusterTree *tx = trees[i];
            CClusterTree *ty = trees[i + 1];
            if (tx->Flag() == 1 && ty->Flag() == 1) {
                distance = DBL_MAX;
            } else {
                distance = node[i].Rdistance;
            }
            pPair = new CDpair;

            pPair->setA(i);
            pPair->setB(i + 1);
            pPair->Iter(sorted.insert(d_sorted_t::value_type(distance,
                            pPair)));
            s_id = to_string(i) + s_dot + to_string(i + 1);
            matrix.setPair(s_id, pPair);
        }
    }

    int n_Left;
    int n_Right;
    int n_tmpID = trees.size();
    while (sorted.size() > 0) {
        CDpair* pPair = sorted.begin()->second;
        int A = pPair->getA();
        int B = pPair->getB();
        assert(A != -1 && B != -1);
        //cout << "A: " << A << ", B: " << B <<endl;

        updateDistance(node, A, B, n_tmpID);

        n_Left = node[A].Lneighbor;
        n_Right = node[B].Rneighbor;

        node[n_tmpID].Lneighbor = n_Left;
        node[n_tmpID].Rneighbor = n_Right;

        string s_id;
        string s_dot = ".";

        s_id = to_string(A) + s_dot + to_string(B);
        pPair = matrix.getPair(s_id);
        if (pPair != NULL) {
            sorted.erase(pPair->Iter());
            delete pPair;
            matrix.erasePair(s_id);
        }

        s_id = to_string(n_Left) + s_dot + to_string(A);
        pPair = matrix.getPair(s_id);
        if (pPair != NULL) {
            sorted.erase(pPair->Iter());
            delete pPair;
            matrix.erasePair(s_id);
        }

        s_id = to_string(B) + s_dot + to_string(n_Right);
        pPair = matrix.getPair(s_id);
        if (pPair != NULL) {
            sorted.erase(pPair->Iter());
            delete pPair;
            matrix.erasePair(s_id);
        }

        CClusterTree *new_tree = new CClusterTree;
        assert(new_tree);
        new_tree->Child_L(trees[A]);
        new_tree->Child_R(trees[B]);
        new_tree->ID(m_nNodeIDs);
        trees[A]->Parent(new_tree);
        trees[B]->Parent(new_tree);
        trees.push_back(new_tree);
        oritrees.push_back(new_tree);

        new_tree->LeafIDs().insert(trees[A]->LeafIDs().begin(),
                                   trees[A]->LeafIDs().end());
        new_tree->LeafIDs().insert(trees[B]->LeafIDs().begin(),
                                   trees[B]->LeafIDs().end());

        if (trees[A]->Flag() == 1 || trees[B]->Flag() == 1) {
            new_tree->Flag(1);
        }

        CDpair* tmpLPair = NULL;
        if (node[n_tmpID].Lneighbor != -1) {
            if (trees[n_Left]->Flag() == 1 && new_tree->Flag() == 1)
            {
                distance = DBL_MAX;
            } else {
                distance = node[n_Left].Rdistance;
            }
            tmpLPair = new CDpair;
            tmpLPair->setA(n_Left);
            tmpLPair->setB(n_tmpID);
            tmpLPair->Iter(sorted.insert(d_sorted_t::value_type(
                                            distance, tmpLPair)));
            s_id = to_string(n_Left) + s_dot + to_string(n_tmpID);
            matrix.setPair(s_id, tmpLPair);
            node[n_Left].Rneighbor = n_tmpID;
        }

        CDpair* tmpRPair = NULL;
        if (node[n_tmpID].Rneighbor != -1) {
            if (new_tree->Flag() == 1 && trees[n_Right]->Flag() == 1)
            {
                distance = DBL_MAX;
            } else {
                distance = node[n_tmpID].Rdistance;
            }
            tmpRPair = new CDpair;
            tmpRPair->setA(n_tmpID);
            tmpRPair->setB(n_Right);
            tmpRPair->Iter(sorted.insert(d_sorted_t::value_type(
                                            distance, tmpRPair)));
            s_id = to_string(n_tmpID) + s_dot + to_string(n_Right);
            matrix.setPair(s_id, tmpRPair);
            node[n_Right].Lneighbor = n_tmpID;
        }
        node[A].Rneighbor = -1;
        node[A].Lneighbor = -1;
        node[B].Rneighbor = -1;
        node[B].Lneighbor = -1;

        n_tmpID++;
        m_nNodeIDs++;
    }

    if (root == node_a) {
        root = *(trees.rbegin());
    }
    node_a = *(trees.rbegin());

    delete[] node;
    node = NULL;
}
