#ifndef MAXWEIGHT_H
#define MAXWEIGHT_H


#include <iostream>
#include <string.h>
#include <map>
#include <set>
#include "graph.h"


using namespace std;


class MaxWeight
{
public:
    MaxWeight();

    int max(int, int);

    int min(int, int);

    void fillMatrix(int** matrix, int row_num, int col_num, int max);

    void init_labels(int* lx, int* ly, int num, int** cost);

    void update_labels(int* lx, int* ly, int num, bool* S, bool* T, int* slack);

    void add_to_tree(int* lx, int* ly, int num, int* prev, int current_x,
                     int prevx, int** cost, int* slack, int* slackx, bool* S);

    void augment(int max_match, int num, int* q, bool* S, bool* T, int* prev,
                 int* xy, int* yx, int* lx, int* ly, int* slack, int* slackx, int** cost);

    int hungarian(int* lx, int* ly, int num, int* q, bool* S, bool* T,
                  int* prev, int* xy, int* yx, int** cost, int* slack,
                  int* slackx, int row_num, int col_num);

    map< int, set<int> > pickLabelMap(GRAPH* g, int nodeNum, map<int, int> map);

    void findIntersectionNum(map< int, set<int> > partition_1,
                             map< int, set<int> > partition_2, int** a,
                             int* clusters_1, int* clusters_2);

    int findOptimal(int** a, int rowNum, int colNum, int* marked);
};

#endif // MAXWEIGHT_H
