#ifndef LINE_H
#define LINE_H

#include <QWidget>
#include <QColor>
#include <QPainter>
#include <QPainterPath>
#include <QPolygon>
#include <QDebug>
#include <QLinearGradient>
#include <QRadialGradient>
#include <qmath.h>

class Line
{

public:

    Line();

    void setAttribute(QPointF posX, QPointF posY, QColor color_1, QColor color_2)
    {
        P1(posX);
        P2(posY);
        Color_1(color_1);
        Color_2(color_2);
    }

    void Width(int n) {
        m_nWidth = n;
    }

    void Height(int n) {
        m_nHeight = n;
    }

    void Pad(int n){
        m_nPad = n;
    }

    void P1(QPointF n) {
        m_pP1.setX(n.x());
        m_pP1.setY(n.y());
    }

    void P2(QPointF n) {
        m_pP2.setX(n.x());
        m_pP2.setY(n.y());
    }

    void P3(QPointF n) {
        m_pP3.setX(n.x());
        m_pP3.setY(n.y());
    }

    void P4(QPointF n) {
        m_pP4.setX(n.x());
        m_pP4.setY(n.y());
    }

    void Color_1(QColor c) {
        m_qColor_1 = c;
    }

    void Color_2(QColor c) {
        m_qColor_2 = c;
    }

    QColor Color_1() {
        return m_qColor_1;
    }

    QColor Color_2() {
        return m_qColor_2;
    }

    void Lines(int n) {
        m_nOrder = n;
    }

    void Value(float f) {
        m_fValue = f;
    }

    void Opacity(QVector<float> opacity) {
        m_vOpacity = opacity;
    }

    void gdtSPoint(QVector<QPointF> gradients) {
        m_vSGdt = gradients;
    }

    void gdtEPoint(QVector<QPointF> gradients) {
        m_vEGdt = gradients;
    }

    void gdtStart(QPointF gStart) {
        m_pGStart = gStart;
    }

    void gdtEnd(QPointF gEnd) {
        m_pGEnd = gEnd;
    }

    QPointF gdtStart() {
        return m_pGStart;
    }

    QPointF gdtEnd() {
        return m_pGEnd;
    }

//------------------------------Control Path------------------------------------

    void setPath(QPainterPath path)
    {
        m_pPath = path;
    }

    QPainterPath getPath()
    {
        return m_pPath;
    }

//-------------------------------QPolygon---------------------------------------

    void Polygon(QPolygonF polygon)
    {
        m_pPolygon = polygon;
    }

    void Polygons(QPolygonF polygons)
    {
        m_pPolygons = polygons;
    }

    QPolygonF getPolygon()
    {
        return m_pPolygon;
    }

    void setShow(bool show) {
        m_bShow = show;
    }

    bool getShow() {
        return m_bShow;
    }
//------------------------------------------------------------------------------

protected:

private:
    bool    m_bShow;

    int     m_nWidth;
    int     m_nHeight;
    int     m_nPad;
    int     m_nWidthNum;
    int     m_nHeightNum;
    int     m_nOrder;

    QPointF m_pP1;
    QPointF m_pP2;
    QPointF m_pP3;
    QPointF m_pP4;
    QPointF m_pGStart;
    QPointF m_pGEnd;
    QColor  m_qColor_1;
    QColor  m_qColor_2;
    QVector<float> m_vOpacity;
    QVector<QPointF> m_vSGdt;
    QVector<QPointF> m_vEGdt;

    float   m_fCtrl;
    float   m_fValue;
    float   P_max;
    float   P_min;

    QPainterPath m_pPath;
    QPolygonF m_pPolygon;
    QPolygonF m_pPolygons;
};

#endif // LINE_H
