#include "hierarchy.h"

Hierarchy::Hierarchy()
{

}

void Hierarchy::Clear()
{
    if (m_pNode != NULL) {
        delete[] m_pNode;
        m_pNode = NULL;
    }
    if (m_tClusters != NULL) {
        delete[] m_tClusters;
        m_tClusters = NULL;
    }
    if (m_label != NULL) {
        delete[] m_label;
        m_label = NULL;
    }
}

void Hierarchy::Begin(int count)
{
    cout << "================process hierarchy begins===============" << endl;
    system("exec rm -r ../DATA/TREE/*");
    vector<string> v_filenames;
    for (int i = 0; i < count; i++) {
//    for (int i = 0; i < 1; i++) {
        stringstream ss_out;
        ss_out << i;
        string s_num = "";
        string strGML = "../DATA/DAT/KARATE_";
        if (i <= 9) {
            s_num = "0";
        }
        strGML = strGML + s_num + ss_out.str() + ".dat";
        v_filenames.push_back(strGML);
    }

    for (int i = 0; i < count; i++) {
//    for (int i = 0; i < 1; i++) {
        stringstream ss_out;
        ss_out << i;
        string s_num = "";
        string strGML = "../DATA/GML/KARATE_";
        if (i <= 9) {
            s_num = "0";
        }
        strGML = strGML + s_num + ss_out.str() + ".gml";
        v_filenames.push_back(strGML);
    }

    int n = v_filenames.size() / 2;
    assert(n == count);

    b = BuildGraph();
    m_pNode = new int[n];
    m_tClusters = new cluster_t[n];
    m_nCount = 0;

    for (int k = 0; k < n; k++) {
        vector<CClusterTree*>   trees;
        /**
         * begin initialize
         */
        string filename = v_filenames[k];
        string filename_1 = v_filenames[k + n];

        /**
         * begin initialize
         */
        ifstream ifs;
        ifs.open(filename.c_str(), ios_base::in | ios_base::out
                 | ios_base::app);
        char *graphName = const_cast<char *> (filename_1.c_str());
        int NUM;

        GRAPH *g;
        g = b.buildGraph(graphName, &NUM, map_1, map_2);
        graph.push_back(g);
        int nodeNum = NUM;
        m_pNode[k] = NUM;

        /**
         * Initialize the degree array of all vertices
         */
        float* a = new float[2 * nodeNum];
        memset(a, 0, sizeof(float) * 2 * nodeNum);

        int* adjacencyMatrix = new int[nodeNum * nodeNum];
        memset(adjacencyMatrix, 0, sizeof(float) * nodeNum * nodeNum);

        float* modMatrix = new float[2 * nodeNum * 2 * nodeNum];
        memset(modMatrix, 0, sizeof(float) * 2 * nodeNum * 2 * nodeNum);

        int* degree = new int[2 * nodeNum];
        memset(degree, 0, 2 * nodeNum * sizeof(int));

        /**
         * read in adjacency matrix information
         */
        for (int i = 0; i < nodeNum; i++) {
            for (int j = 0; j < nodeNum; j++) {
                ifs.read(reinterpret_cast<char*>(adjacencyMatrix),
                    sizeof(int) * nodeNum * nodeNum);
            }
        }
        ifs.close();
        /**
         * end initialize
         */

        cluster_t clusters;
        initCluster(nodeNum, clusters);
        int clusterNum = nodeNum;

        /**
         * initialize matrix
         */
        calculateDeg(adjacencyMatrix, degree, nodeNum);
        int edge_num = calculateEdgeNum(degree, nodeNum);

        initializeA(edge_num, degree, a, nodeNum);
        initModMatrix(adjacencyMatrix, nodeNum, modMatrix, degree, edge_num);

        CMatrix cmatrix;
        sorted_t sorted;

        init_trees(trees, nodeNum, modMatrix, a, 2 * nodeNum);
        init_load_matrix(cmatrix, modMatrix, sorted, 2 * nodeNum);

        m_sTreesID.clear();
        for (size_t i = 0; i < trees.size(); i++) {
            m_sTreesID.insert(i);
        }

        CClusterTree *root;
        root = do_clustering(trees, modMatrix, sorted, a, 2 * nodeNum,
                             cmatrix, clusterNum, ONETREE);
        int index = 1;
        DFS_Index(root, index);

        stringstream ss_out;
        ss_out << k;
        string s_num = "";
        string strTREE = "../DATA/TREE/TREE_";
        if (k <= 9) {
            s_num = "0";
        }
        strTREE = strTREE + s_num + ss_out.str();
        ofstream o(strTREE.c_str());
        save_tree(root, o);

        cout << "the " << m_nCount - 1 << " time finished" << endl;

        /**
         * destructing structures!!
         */
        delete_tree(trees);
        delete[] adjacencyMatrix;
        adjacencyMatrix = NULL;
        delete[] a;
        a = NULL;
        delete[] modMatrix;
        modMatrix = NULL;
        delete[] degree;
        degree = NULL;
        cmatrix.flush();
    }
}

void Hierarchy::Operation(int count, int num)
{
    system("exec rm -r ../DATA/LABEL/*");
    system("exec rm -r ../DATA/DIFF/DIFF");

    int nodeNum;
    GRAPH *g;
    CClusterTree *root;
    CClusterTree *parent;

    v_Diff.clear();
    ori_g = NULL;
    map_ori_1.clear();
    map_ori_2.clear();
    m_label = new map<int, int>[count];
    m_nTime = count;

    for (int k = 0; k < count; k++) {
//    for (int k = 0; k < 1; k++) {
        vector<CClusterTree *> trees;
        g = graph[k];
        nodeNum = m_pNode[k];
        int cluster = num;
        int n_clusters;

        if (cluster < nodeNum) {
            n_clusters = nodeNum - cluster;
        } else {
            n_clusters = nodeNum - nodeNum;
        }

        stringstream ss_out;
        ss_out << k;
        string s_num = "";
        string strTREE = "../DATA/TREE/TREE_";
        if (k <= 9) {
            s_num = "0";
        }
        strTREE = strTREE + s_num + ss_out.str();
        ifstream inf(strTREE.c_str());
        read_tree(root, inf, parent);

        vector<int>             v_Clusters;
        vector<CClusterTree*>   v_ClusterTree;
        multimap<int, int>      mm_LeafOrder;
        v_Clusters.clear();
        v_ClusterTree.clear();
        CollectClusterTree(root, root->Level() + 1, n_clusters,
                           v_Clusters, v_ClusterTree);
        assert(v_Clusters.size() == v_ClusterTree.size());
        set<int>::iterator sit;
        for (size_t i = 0; i < v_ClusterTree.size(); i++) {
            int id = v_ClusterTree[i]->Index();
            mm_LeafOrder.insert(pair<int, int>(id, i));
        }
        m_tClusters[k].clear();
        m_label[k].clear();
        int leafcount = 0;
        multimap<int, int>::iterator mitr;
        for (mitr = mm_LeafOrder.begin(); mitr != mm_LeafOrder.end(); mitr++) {
            for (sit = v_ClusterTree[mitr->second]->LeafIDs().begin();
                 sit != v_ClusterTree[mitr->second]->LeafIDs().end();
                 sit++) {
                m_tClusters[k][leafcount].push_back(*sit);
            }
            /**
             *remember cluster id and the corresponding tree
             */
            m_label[k][leafcount] = v_ClusterTree[mitr->second]->ID();
            leafcount++;
        }
//        cout << "size is: " << m_label[k].size();

        this->getClusteringRes(m_tClusters[k]);
        setLabel(m_tClusters[k], g, map_2);
        b.displayGraphLabel(g, k);
//        for (int i = 0; i < count; i++) {
//            cout << "the " << i << "th clustering result: " << endl;
//            this->getClusteringRes(m_tClusters[0]);
//            setLabel(m_tClusters[0], g, map_2);
//            b.displayGraphLabel(g, i);
//            int n_Diff = 0;
//            v_Diff.push_back(n_Diff);
//        }

        /**
         *calculate the cluster difference
         */
        int* lx;
        int* ly;
        int* q;
        bool* S;
        bool* T;
        int* prev;
        int* xy;
        int* yx;
        int* slack;
        int* slackx;
        int *clusters1;
        int *clusters2;

        /**
         *hungarian algorithm
         */
        MaxWeight maxweight = MaxWeight();
        if (ori_g != NULL) {
            map<int, set<int> > tt = maxweight.pickLabelMap(g, g->nvertices,
                                                            map_2);
            int col = tt.size();
            //cout<<col<<endl;
            map<int, set<int> > ori_tt = maxweight.pickLabelMap(ori_g,
                                                               ori_g->nvertices,
                                                                map_ori_2 );
            int row = ori_tt.size();
            //cout<<row<<endl;
            //return 0;
            int max_num = max(row, col);
            lx = new int[max_num];
            ly = new int[max_num];
            q = new int[max_num];
            S = new bool[max_num];
            T = new bool[max_num];
            prev = new int[max_num];
            xy = new int[max_num];
            yx = new int[max_num];
            slack = new int[max_num];
            slackx = new int[max_num];
            clusters1 = new int[row];
            clusters2 = new int[col];
            int** resultMatrix = new int*[max_num];
            int* marked = new int[max_num];
            for (int i = 0; i < max_num; i++)
                resultMatrix[i] = new int[max_num];
            for (int i = 0; i < row; i++)
                for (int j = 0; j < col; j++)
                    resultMatrix[i][j] = 0;
            for (int i = 0; i < col; i++)
                marked[i] = 0;
            maxweight.findIntersectionNum(ori_tt, tt, resultMatrix, clusters1,
                                          clusters2);
            maxweight.fillMatrix(resultMatrix, row, col, max_num);
            int ret = maxweight.hungarian(lx, ly, max_num, q, S, T, prev, xy,
                                          yx, resultMatrix, slack, slackx,
                                          row, col);
            int n_largerNum = g->nvertices > ori_g->nvertices ?
                        g->nvertices : ori_g->nvertices;

            /**
             *set the standard of the hierarchy result,
             *determin whether the hierarchy result use the first time step
             */
//            ori_g = g;
//            map_ori_1.clear();
//            map_ori_2.clear();
//            map_ori_1 = map_1;
//            map_ori_2 = map_2;

            int n_Diff = n_largerNum - ret;
            //cout << n_Diff << endl;
            v_Diff.push_back(n_Diff);

            delete[] slackx;
            delete[] slack;
            delete[] yx;
            delete[] xy;
            delete[] prev;
            delete[] T;
            delete[] S;
            delete[] q;
            delete[] ly;
            delete[] lx;
            for (int i = 0; i < max_num; i++) {
                delete[] resultMatrix[i];
            }
        }
        else {
            v_Diff.push_back(0);
            ori_g = g;
            map_ori_1.clear();
            map_ori_2.clear();
            map_ori_1 = map_1;
            map_ori_2 = map_2;
        }
        traverse_tree(trees, root);
        delete_tree(trees);
    }
//    v_Diff.push_back(v_Diff[v_Diff.size() - 1]);
    ofstream outDiff("../DATA/DIFF/DIFF");
    for (size_t i = 0; i < v_Diff.size(); i++) {
        outDiff << v_Diff[i] << " ";
    }
    /*
    map<int, int>::iterator mitr;
    for (int i = 0; i < count; i++) {
        for (mitr = m_label[i].begin(); mitr != m_label[i].end(); mitr++) {
            cout << mitr->second << " ";
        }
        cout << endl;
    }
    */
}

/**
 * We follow the guideline that when we merge two cluster A and B,
 * we mean join A to B.
 */
void Hierarchy::merge_trees (vector<CClusterTree *> &trees,
                  float *modMatrix,
                  sorted_t &sorted,
                  float *a,
                  int nodeNum,
                  CMatrix &matrix,
                  int &clusterNum,
                  int &maxlevel)
{
    if (sorted.size() == 0) {
    //cerr<< "No pair available." <<endl;
        return;
    }
    CPair* pPair = sorted.begin()->second;
    int A = pPair->getA();
    int B = pPair->getB();

    //cout << "A: " << A << ", B: " << B << endl;

    updateModMatrix(modMatrix, a, A, B, m_nNewID, nodeNum);
    clusterNum--;

    for (int i = 0; i < A; i++) {
        pPair = matrix(i, A);
        if (pPair != NULL) {
            sorted.erase(pPair->Iter());
            delete pPair;
            matrix(i, A) = NULL;
        }
    }
    for (int i = 0; i < B; i++) {
        pPair = matrix(i, B);
        if (pPair != NULL) {
            sorted.erase(pPair->Iter());
            delete pPair;
            matrix(i, B) = NULL;
        }
    }
    for (int i = A + 1; i < nodeNum; i++) {
        pPair = matrix(A, i);
        if (pPair != NULL) {
            sorted.erase(pPair->Iter());
            delete pPair;
            matrix(A, i) = NULL;
        }
    }
    for (int i = B + 1; i < nodeNum; i++) {
        pPair = matrix(B, i);
        if (pPair != NULL) {
            sorted.erase(pPair->Iter());
            delete pPair;
            matrix(B, i) = NULL;
        }
    }

    CPair* tmpPair = NULL;
    for (int i = 0; i < m_nNewID; i++) {
        if (modMatrix[i * nodeNum + m_nNewID] != MIN) {
            tmpPair = new CPair;
            tmpPair->setA(i);
            tmpPair->setB(m_nNewID);
            tmpPair->Iter(
                    sorted.insert(sorted_t::value_type(modMatrix[i *
                                  nodeNum + m_nNewID], tmpPair)));
            matrix(i, m_nNewID) = tmpPair;
        }
    }

    CClusterTree *new_tree = new CClusterTree;
    assert(new_tree);
    assert((int)trees.size() == m_nNewID);

    new_tree->Child_L(trees[A]);
    new_tree->Child_R(trees[B]);
    trees[A]->Parent(new_tree);
    trees[B]->Parent(new_tree);
    maxlevel++;
    new_tree->Level(maxlevel);
    new_tree->ID(trees.size());
    new_tree->setA(a[trees.size()]);
    new_tree->LeafIDs().insert(trees[A]->LeafIDs().begin(),
                               trees[A]->LeafIDs().end());
    new_tree->LeafIDs().insert(trees[B]->LeafIDs().begin(),
                               trees[B]->LeafIDs().end());
    for (int j = 0; j < nodeNum; j++) {
        if (modMatrix[trees.size() * nodeNum + j] != MIN) {
            new_tree->setMod(j, modMatrix[trees.size() * nodeNum + j]);
        }
    }
    new_tree->setA(a[trees.size()]);

    set<int>::iterator itr1, itr2;
    for (itr1 = m_sTreesID.begin(); itr1 != m_sTreesID.end(); itr1++) {
        if (*itr1 == trees[A]->ID()) {
            m_sTreesID.erase(itr1);
            break;
        }
    }

    for (itr2 = m_sTreesID.begin(); itr2 != m_sTreesID.end(); itr2++) {
        if (*itr2 == trees[B]->ID()) {
            m_sTreesID.erase(itr2);
            break;
        }
    }
    m_sTreesID.insert(m_nNewID);
    trees.push_back(new_tree);
    m_nNewID++;
}

void Hierarchy::balance_tree(vector<CClusterTree *> &ttrees,
                             CClusterTree *&root,
                             float delta,
                             float factor)
{
    multimap<int, CClusterTree**, greater<int> > partitions;

    partitions.insert(pair<int, CClusterTree**>(root->LeafNum(),&root));

    unsigned int maxpartition = root->Level();

    //int new_level = root->Level() * 2;
    //root->Level(new_level--);

    //int total_id = root->ID() + 1;

    while(partitions.size() <= maxpartition) {
        //cerr << "processing " << partitions.size() << '\r';

        CClusterTree** cand = partitions.begin()->second;
        /*
        cerr << "================" << endl;
        cerr << "cand " << (*cand)->LeafNum() << endl;
        cerr << "L    " << (*cand)->Child_L()->LeafNum() << endl;
        cerr << "R    " << (*cand)->Child_R()->LeafNum() << endl;
        */
        split_tree(ttrees, root, (*cand), partitions.size() + 1,
                   delta, factor);

        partitions.erase(partitions.begin());

        if ((*cand)->Child_L() != NULL) {
            partitions.insert(pair<int,
                    CClusterTree**>((*cand)->Child_L()->LeafNum(),
                        &((*cand)->Child_L())));
        }
        if ((*cand)->Child_R() != NULL) {
            partitions.insert(pair<int,
                    CClusterTree**>((*cand)->Child_R()->LeafNum(),
                        &((*cand)->Child_R())));
        }
    }

    /**
     *update level
     */
    partitions.clear();
    partitions.insert(pair<int, CClusterTree**>(root->LeafNum(),&root));
    int curt_level = maxpartition;

    while(partitions.size() <= maxpartition) {
        CClusterTree** cand = partitions.begin()->second;

        (*cand)->Level(curt_level);
        curt_level--;

        partitions.erase(partitions.begin());

        if ((*cand)->Child_L() != NULL) {
            partitions.insert(pair<int, CClusterTree**>
                          ((*cand)->Child_L()->LeafNum(),
                           &((*cand)->Child_L())));
        }

        if ((*cand)->Child_R() != NULL) {
            partitions.insert(pair<int, CClusterTree**>
                          ((*cand)->Child_R()->LeafNum(),
                           &((*cand)->Child_R())));
        }
    }
}

void Hierarchy::split_tree(vector<CClusterTree *> &ttrees,
                           CClusterTree *&root,
                           CClusterTree *&subroot,
                           int partition_num,
                           float delta,
                           float factor)
{
    //float delta = 0.5;
    //float delta = 0.1;

    int avg_leafnum = (int)(root->LeafNum() * delta / partition_num);

    assert(!subroot->IsLeaf());

    /*
    if (subroot->IsLeaf()) {
        return;
    }
    */

    /**
     *check if rotation is needed
     */
    if (subroot->Child_L()->LeafNum() > avg_leafnum &&
        subroot->Child_R()->LeafNum() > avg_leafnum)
    {
        return;
    }

    /**
     *go through all the nodes of subroot according to the level number and
     *stop when the node's leaf number meets the threshold
     */
    multimap<int, CClusterTree *, greater<int> > msorted;

    msorted.insert(pair<int, CClusterTree*>
                   (subroot->Child_L()->LeafNum(), subroot->Child_L()));

    msorted.insert(pair<int, CClusterTree*>
                   (subroot->Child_R()->LeafNum(), subroot->Child_R()));

    int sub_size = subroot->LeafNum();

    CClusterTree *found = NULL;
    int my_partition_num = partition_num + 1;

    while(msorted.size() > 0) {
        CClusterTree *test = msorted.begin()->second;

        int my_num = test->LeafNum();
        int sibling_num = test->Sibling()->LeafNum();
        int other_num = sub_size - my_num;

        //float fact = 0.5f;
        int my_avg_leafnum = (int)(root->LeafNum() * delta
                                   / my_partition_num);

        if (my_num >= my_avg_leafnum &&
            other_num >= my_avg_leafnum &&
            sibling_num >= my_num * factor) {
            found = test;
            break;
        }

        if (test->LeafNum() == 1) {
            found = test;
            break;
        }

//                cout << "My partition number: " << my_partition_num << endl;

        msorted.erase(msorted.begin());

        if (test->Child_L()) {
            msorted.insert(pair<int, CClusterTree*>
                           (test->Child_L()->LeafNum(),
                            test->Child_L()));
        }
        if (test->Child_R()) {
            msorted.insert(pair<int, CClusterTree*>
                           (test->Child_R()->LeafNum(),
                            test->Child_R()));
        }
        my_partition_num++;
    }

    if (found == NULL) {
        cerr << "Can not find the desired tree node" << endl;
        cerr << "avg number " << avg_leafnum << " sub_size " << sub_size
             << endl;
        exit(0);
    }

    rotate_tree(ttrees, root, subroot, found->Parent());
}

void Hierarchy::rotate_tree(vector<CClusterTree *> &ttrees,
                            CClusterTree *&root,
                            CClusterTree *&node_a,
                            CClusterTree *node_b)
{
    if (node_a == NULL || node_b == NULL) {
        cerr << "Impossible case : target_node is null" << endl;
        exit(1);
    }

    if (node_b->IsLeaf()) {
        cerr << "Impossible case : node_b can not be leaf." << endl;
        exit(1);
    }

    if (node_b == node_a) {
        //cerr << "Don't need to be adjusted because node_b is node_a"
        //     << endl;
        return;
    }

    /**
     *gather trees
     */
    deque<int> dq_TreeID;
    vector<CClusterTree *> trees;

    node_b->Child_L()->Flag(1);
    node_b->Child_R()->Flag(1);

    trees.push_back(node_b->Child_L());
    trees.push_back(node_b->Child_R());

    CClusterTree *prev = node_b;
    CClusterTree *curt = node_b->Parent();
    while(prev != node_a) {
        CClusterTree *temp = curt->OtherChild(prev);
        trees.push_back(temp);
        prev = curt;
        curt = curt->Parent();
    }

    /**
     *initial matrix and sorted list
     */
    int total = trees.size();
    int n_tmpID = trees.size();
    float mod;

    /**
     *inititalize the temporal modularity matrix and A
     */
    float *tmpMatrix = new float[2 * total * 2 * total];
    memset(tmpMatrix, 0, sizeof(float) * 2 * total * 2 * total);
    float *tmpA = new float[2 * total];
    memset(tmpA, 0, sizeof(float) * 2 * total);

    map<int, float>::iterator mitr;
    for (int i = 0; i < total; i++) {
        CClusterTree *ti = trees[i];
        for (int j = 0; j < total; j++) {
            CClusterTree * tj = trees[j];
            mitr = ti->getMods().find(tj->ID());
            if (mitr != ti->getMods().end()) {
                if (ti->getMod(tj->ID()) != MIN) {
                        tmpMatrix[i * 2 * total + j]
                                = ti->getMod(tj->ID());
                        tmpMatrix[j * 2 * total + i]
                                = ti->getMod(tj->ID());
                }
            }
        }
    }

    for (int i = 0; i < total; i++) {
        CClusterTree *ti = trees[i];
        tmpA[i] = ti->getA();
    }

    /*
    cout << "initialize temporal matrix: " << endl;
    for (int y = 0; y < 2 * total; y++) {
        for (int x = 0; x < 2 * total; x++) {
            cout << setw(12)
                 << tmpMatrix[y * 2 * total + x]
                 << " ";
        }
        cout << endl;
    }

    cout << endl;
    cout << "temporal A:" << endl;
    for (int i = 0; i < total; i++) {
        cout << tmpA[i] << " ";
    }

    cout << "total size: " << total << endl;
    */

    CMatrix matrix;
    matrix.setSize(total * 2, total * 2);
    matrix.Calloc();

    sorted_t sorted;
    CPair* pPair = NULL;
    for (int x = 0; x < total; x++) {
        for (int y = x; y < total; y++) {
            if (trees[x] != NULL && trees[y] != NULL) {
                CClusterTree *tx = trees[x];
                CClusterTree *ty = trees[y];
                if (tx->Flag() == 1 && ty->Flag() == 1) {
                    mod = MIN;
                } else {
                    mod = tmpMatrix[x * total * 2 + y];
                }
                if (mod != MIN) {
                    pPair = new CPair;
                    pPair->setA(x);
                    pPair->setB(y);
                    pPair->Iter(sorted.insert(sorted_t::value_type(
                                mod, pPair)));
                    matrix(x, y) = pPair;
                }
            }
        }
    }

    while (sorted.size() > 0) {
        CPair *pPair = sorted.begin()->second;

        int A = pPair->getA();
        int B = pPair->getB();

        //cout << "A: " << A << ", B: " << B << endl;

        updateModMatrix(tmpMatrix, tmpA, A, B, n_tmpID, 2 * total, true);

        for (int i = 0; i < A; i++) {
            pPair = matrix(i, A);
            if (pPair != NULL) {
                sorted.erase(pPair->Iter());
                delete pPair;
                matrix(i, A) = NULL;
            }
        }
        for (int i = 0; i < B; i++) {
            pPair = matrix(i, B);
            if (pPair != NULL) {
                sorted.erase(pPair->Iter());
                delete pPair;
                matrix(i, B) = NULL;
            }
        }
        for (int i = A + 1; i < total * 2; i++) {
            pPair = matrix(A, i);
            if (pPair != NULL) {
                sorted.erase(pPair->Iter());
                delete pPair;
                matrix(A, i) = NULL;
            }
        }
        for (int i = B + 1; i < total * 2; i++) {
            pPair = matrix(B, i);
            if (pPair != NULL) {
                sorted.erase(pPair->Iter());
                delete pPair;
                matrix(B, i) = NULL;
            }
        }

        CClusterTree *new_tree = new CClusterTree;
        assert(new_tree);
        assert((int)trees.size() == n_tmpID);

        new_tree->Child_L(trees[A]);
        new_tree->Child_R(trees[B]);
        trees[A]->Parent(new_tree);
        trees[B]->Parent(new_tree);
        new_tree->ID(m_nNewID);

        new_tree->LeafIDs().insert(trees[A]->LeafIDs().begin(),
                                   trees[A]->LeafIDs().end());
        new_tree->LeafIDs().insert(trees[B]->LeafIDs().begin(),
                                   trees[B]->LeafIDs().end());

        if (trees[A]->Flag() == 1 || trees[B]->Flag() == 1) {
            new_tree->Flag(1);
        }

        trees.push_back(new_tree);
        ttrees.push_back(new_tree);

        CPair* tmpPair = NULL;
        for (int i = 0; i < n_tmpID; i++) {
            if (trees[i] != NULL) {
                if (trees[i]->Flag() == 1 && new_tree->Flag() == 1) {
                    mod = MIN;
                } else {
                    mod = tmpMatrix[i * total * 2 + n_tmpID];
                }
                if (mod != MIN) {
                    tmpPair = new CPair;
                    tmpPair->setA(i);
                    tmpPair->setB(n_tmpID);
                    tmpPair->Iter(sorted.insert(sorted_t::value_type(
                                  mod, tmpPair)));
                    matrix(i, n_tmpID) = tmpPair;
                }
            }
        }

        m_nNewID++;
        n_tmpID++;
    }

    if (root == node_a) {
        root = *(trees.rbegin());
    }
    node_a = *(trees.rbegin());

    tmpMatrix = NULL;
    delete[] tmpMatrix;
    tmpA = NULL;
    delete[] tmpA;
}

void Hierarchy::merge_discon_tree(vector<CClusterTree *> &trees,
                                  deque<int> &dq,
                                  int &maxlevel,
                                  float mod,
                                  float a)
{
    int m = 0;
    int A = dq[m];
    int B = dq[m + 1];

    CClusterTree *new_tree = new CClusterTree;
    assert(new_tree);
    assert((int)trees.size() == m_nNewID);
    //assert(trees[A]->getMods().size() == 0);
    //assert(trees[B]->getMods().size() == 0);
    new_tree->Child_L(trees[A]);
    new_tree->Child_R(trees[B]);
    trees[A]->Parent(new_tree);
    trees[B]->Parent(new_tree);
    trees[A]->setMod(B, mod);
    trees[B]->setMod(A, mod);
    trees[A]->setA(a);
    trees[B]->setA(a);
    if (maxlevel >= 0) {
        maxlevel++;
        new_tree->Level(maxlevel);
    }
    new_tree->ID(trees.size());

    new_tree->LeafIDs().insert(trees[A]->LeafIDs().begin(),
                               trees[A]->LeafIDs().end());
    new_tree->LeafIDs().insert(trees[B]->LeafIDs().begin(),
                               trees[B]->LeafIDs().end());
    set<int>::iterator itr1, itr2;
    for (itr1 = m_sTreesID.begin(); itr1 != m_sTreesID.end();
         itr1++) {
        if (*itr1 == trees[A]->ID()) {
            m_sTreesID.erase(itr1);
            break;
        }
    }

    for (itr2 = m_sTreesID.begin(); itr2 != m_sTreesID.end();
         itr2++) {
        if (*itr2 == trees[B]->ID()) {
            m_sTreesID.erase(itr2);
            break;
        }
    }
    m_sTreesID.insert(m_nNewID);
    trees.push_back(new_tree);
    dq.pop_front();
    dq.pop_front();
    dq.push_back(m_nNewID);
    m_nNewID++;
}

bool Hierarchy::force_Merge(vector<CClusterTree *> &trees, int num)
{
    deque<int> dq_1;
    deque<int> dq_2;
    deque<int> dq_Cluster;
    deque<CClusterTree *> treeArray;
    set<int>::iterator sit;
    int maxlevel;
    int edgeNum = 1;
    int degree = 1;
    int count = 0;
    int total;
    int A;
    int B;
    float a;
    float mod;
    a = (float)degree / (float)(2 * edgeNum);
    mod = 1.0f / (float)(2 * edgeNum) - (float)(degree * degree)
            / (float)pow(2 * edgeNum, 2);
    m_dqCluster.clear();
    if ((int)m_sTreesID.size() == num) {
        return false;
    } else if ((int)m_sTreesID.size() > num) {
        cout << "force merge begins." << endl;
        for (sit = m_sTreesID.begin(); sit != m_sTreesID.end();
             sit++) {
            dq_Cluster.push_back(*sit);
            treeArray.push_back(trees[*sit]);
            m_dqCluster.push_back(*sit);
        }

        assert(dq_Cluster.size() == treeArray.size());
        tree_heapsort(treeArray, dq_Cluster.size());

        while (!treeArray.empty()) {
            if (count % 2 == 0) {
                dq_1.push_back(treeArray[0]->ID());
            } else {
                dq_2.push_back(treeArray[0]->ID());
            }
            treeArray.pop_front();
            count++;
        }

        count = 0;
        maxlevel = trees.back()->Level();
        total = dq_1.size() + dq_2.size();

        while (total > 2) {
            if (count % 2 == 0) {
                merge_discon_tree(trees, dq_1, maxlevel, mod, a);

            } else {
                merge_discon_tree(trees, dq_2, maxlevel, mod, a);
            }
            total--;
            count++;
        }
        assert(dq_1.size() == 1);
        assert(dq_2.size() == 1);

        A = dq_1.front();
        B = dq_2.front();

        dq_Cluster.clear();
        dq_Cluster.push_back(A);
        dq_Cluster.push_back(B);

        merge_discon_tree(trees, dq_Cluster, maxlevel, mod, a);
    }
    return true;
}

/**
 *merge cluster_num1 and cluster_num2 into new id
 */
void Hierarchy::updateModMatrix(float* modMatrix,
                                float* a,
                                int cluster_num1,
                                int cluster_num2,
                                int new_id,
                                int nodeNum,
                                bool show)
{
    float modularity;
    for (int k = 0; k < nodeNum; k++) {
        if (k != cluster_num1 && k!= cluster_num2) {
            if (getModularity(nodeNum, cluster_num1, k, modMatrix) != MIN
                    && getModularity(nodeNum, cluster_num2, k, modMatrix)
                            != MIN) {
                modularity = getModularity(nodeNum, cluster_num1, k,
                                           modMatrix)
                        + getModularity(nodeNum, cluster_num2, k,
                                        modMatrix);
                setModularity(nodeNum, new_id, k, modMatrix,
                              modularity);
                setModularity(nodeNum, k, new_id, modMatrix,
                              modularity);
            } else if (getModularity(nodeNum, cluster_num1, k, modMatrix)
                       != MIN
                    && getModularity(nodeNum, cluster_num2, k, modMatrix)
                            == MIN) {
                modularity = getModularity(nodeNum, cluster_num1, k,
                                           modMatrix)
                        - 2 * a[cluster_num2] * a[k];
                setModularity(nodeNum, new_id, k, modMatrix,
                              modularity);
                setModularity(nodeNum, k, new_id, modMatrix,
                              modularity);
            } else if (getModularity(nodeNum, cluster_num1, k, modMatrix)
                       == MIN
                    && getModularity(nodeNum, cluster_num2, k, modMatrix)
                            != MIN) {
                modularity = getModularity(nodeNum, cluster_num2, k,
                                           modMatrix)
                        - 2 * a[cluster_num1] * a[k];
                setModularity(nodeNum, new_id, k, modMatrix,
                              modularity);
                setModularity(nodeNum, k, new_id, modMatrix,
                              modularity);
            }
        }
    }

    for (int i = 0; i < nodeNum; i++) {
        setModularity(nodeNum, cluster_num1, i, modMatrix, MIN);
        setModularity(nodeNum, i, cluster_num1, modMatrix, MIN);
    }
    for (int i = 0; i < nodeNum; i++) {
        setModularity(nodeNum, i, cluster_num2, modMatrix, MIN);
        setModularity(nodeNum, cluster_num2, i, modMatrix, MIN);
    }
    updateA(cluster_num1, cluster_num2, new_id, a);

    if (show) {
        cout << "update: " << endl;
        for (int y = 0; y < nodeNum; y++) {
            for (int x = 0; x < nodeNum; x++) {
                cout << setw(12)
                     << modMatrix[y * nodeNum + x]
                     << " ";
            }
            cout << endl;
        }
    }
}

void Hierarchy::Operation(int total,
                          int id,
                          int num,
                          string strTREE,
                          int sender,
                          int recver)
{
    assert(id <= (m_nTime - 1));

    int             nodeNum;
    GRAPH           *g;
    CClusterTree    *root;
    CClusterTree    *parent;
    cluster_t       tCluster;

    g = graph[id];
    nodeNum = m_pNode[id];
//    g = graph[0];
//    nodeNum = m_pNode[0];
    int cluster;
    int n_clusters;

    cluster = total;
    if (cluster < nodeNum) {
        n_clusters = nodeNum - cluster;
    } else {
        n_clusters = nodeNum - nodeNum;
    }

    ifstream inf(strTREE.c_str());
    read_tree(root, inf, parent);

    vector<int>             v_Clusters;
    vector<CClusterTree*>   v_ClusterTree;
    multimap<int, int>      mm_LeafOrder;
    v_Clusters.clear();
    v_ClusterTree.clear();
    CollectClusterTree(root, root->Level() + 1, n_clusters,
                       v_Clusters, v_ClusterTree);

    //map<int, int>::iterator itr;
    //for (itr = m_label[id].begin(); itr != m_label[id].end(); itr++) {
    //for (itr = m_label[0].begin(); itr != m_label[0].end(); itr++) {
        //cout << itr->second << endl;
    //}
    //cout << "size is: " << m_label[id].size() << endl;
    //cout << "size is: " << m_label[0].size() << endl;

    assert(v_Clusters.size() == v_ClusterTree.size());
    assert(vectorContain(v_Clusters, m_label[id][sender]));
    assert(vectorContain(v_Clusters, m_label[id][recver]));
//    assert(vectorContain(v_Clusters, m_label[0][sender]));
//    assert(vectorContain(v_Clusters, m_label[0][recver]));


    int n_subID1        = m_label[id][sender];
    int n_subID2        = m_label[id][recver];
//    int n_subID1        = m_label[0][sender];
//    int n_subID2        = m_label[0][recver];

    vector<CClusterTree*>   v_TreeSet;
    CClusterTree            *subroot1;
    CClusterTree            *subroot2;
    vector<int>             v_Clusters1;
    vector<CClusterTree*>   v_ClusterTree1;
    vector<int>             v_Clusters2;
    vector<CClusterTree*>   v_ClusterTree2;

    traverse_tree(v_TreeSet, root);
    find_tree(v_TreeSet, subroot1, n_subID1);
    find_tree(v_TreeSet, subroot2, n_subID2);

    //cout << "Check!" << endl;

    cluster = num;
    int n_Leaves1       = subroot1->LeafNum();
    int n_Leaves2       = subroot2->LeafNum();

    if (sender != recver) {
        BFS_Reindex(subroot1);
        BFS_Reindex(subroot2);
        int total = n_Leaves1 + n_Leaves2;
        if (cluster > total) {
            cluster = total;
        }

        int n_cluster1      = cluster * n_Leaves1 / (n_Leaves1 + n_Leaves2);
        int n_cluster2      = cluster - n_cluster1;

        assert(n_Leaves1 >= n_cluster1);
        assert(n_Leaves2 >= n_cluster2);

        if (n_cluster1 < n_Leaves1) {
            n_clusters = n_Leaves1 - n_cluster1;
        } else {
            n_clusters = n_Leaves1 - n_Leaves1;
        }
        CollectClusterTree(subroot1, subroot1->Parent()->Level(),
                           n_clusters, v_Clusters1, v_ClusterTree1);
        if (n_cluster2 < n_Leaves2) {
            n_clusters = n_Leaves2 - n_cluster2;
        } else {
            n_clusters = n_Leaves2 - n_Leaves2;
        }
        CollectClusterTree(subroot2, subroot2->Parent()->Level(),
                           n_clusters, v_Clusters2, v_ClusterTree2);

        assert(v_Clusters1.size() == v_ClusterTree1.size());
        assert(v_Clusters2.size() == v_ClusterTree2.size());

        v_Clusters.clear();
        v_ClusterTree.clear();

        for (size_t i = 0; i < v_Clusters1.size(); i++) {
            v_Clusters.push_back(v_Clusters1[i]);
            v_ClusterTree.push_back(v_ClusterTree1[i]);
        }

        for (size_t i = 0; i < v_Clusters2.size(); i++) {
            v_Clusters.push_back(v_Clusters2[i]);
            v_ClusterTree.push_back(v_ClusterTree2[i]);
        }
    } else {
        assert(subroot1 == subroot2);
        BFS_Reindex(subroot1);
        int total = n_Leaves1;
        if (cluster > total) {
            cluster = total;
        }
        if (cluster < total) {
            n_clusters = total - cluster;
        } else {
            n_clusters = total - total;
        }
        //int parent = subroot1->Parent()->Level();
        int parent = v_Clusters.size() == 1 ?
                    subroot1->Level() + 1 : subroot1->Parent()->Level();
        v_Clusters.clear();
        v_ClusterTree.clear();
        //cout << "the minus result is " << n_clusters << endl;
        CollectClusterTree(subroot1, parent, n_clusters,
                           v_Clusters, v_ClusterTree);
    }

    set<int>::iterator sit;
    for (size_t i = 0; i < v_ClusterTree.size(); i++) {
        int id = v_ClusterTree[i]->Index();
        mm_LeafOrder.insert(pair<int, int>(id, i));
    }

    int count = 0;
    multimap<int, int>::iterator mitr;
    for (mitr = mm_LeafOrder.begin(); mitr != mm_LeafOrder.end(); mitr++) {
        for (sit = v_ClusterTree[mitr->second]->LeafIDs().begin();
             sit != v_ClusterTree[mitr->second]->LeafIDs().end();
             sit++) {
            tCluster[count].push_back(*sit);
        }
        count++;
    }

    string output = "../DATA/SUB/LABEL";
    this->getClusteringRes(tCluster);
    cout << "========sub window cluster========" << endl;
    setLabel(tCluster, g, map_2);
    b.displayGraphLabel(g, output);
}

void Hierarchy::Operation(int id, int num, string strTREE)
{
    int          nodeNum;
    GRAPH        *g;
    CClusterTree *root;
    CClusterTree *parent;
    cluster_t    tCluster;

    g = graph[id];
    nodeNum = m_pNode[id];

    int cluster = num;
    int n_clusters;

    if (cluster < nodeNum) {
        n_clusters = nodeNum - cluster;
    } else {
        n_clusters = nodeNum - nodeNum;
    }

    ifstream inf(strTREE.c_str());
    read_tree(root, inf, parent);

    vector<int>             v_Clusters;
    vector<CClusterTree*>   v_ClusterTree;
    multimap<int, int>      mm_LeafOrder;
    v_Clusters.clear();
    v_ClusterTree.clear();
    CollectClusterTree(root, root->ID() + 1, n_clusters,
                       v_Clusters, v_ClusterTree);
    assert(v_Clusters.size() == v_ClusterTree.size());
    set<int>::iterator sit;
    for (size_t i = 0; i < v_ClusterTree.size(); i++) {
        sit = v_ClusterTree[i]->LeafIDs().begin();
        mm_LeafOrder.insert(pair<int, int>(*sit, i));
    }

    int count = 0;
    multimap<int, int>::iterator mitr;
    for (mitr = mm_LeafOrder.begin(); mitr != mm_LeafOrder.end(); mitr++) {
        for (sit = v_ClusterTree[mitr->second]->LeafIDs().begin();
             sit != v_ClusterTree[mitr->second]->LeafIDs().end();
             sit++) {
            tCluster[count].push_back(*sit);
        }
        count++;
    }

    string output = "../DATA/SUB/LABEL";
    setLabel(tCluster, g, map_2);
    b.displayGraphLabel(g, output);
}

