#ifndef GRAPH_H
#define GRAPH_H


#define MAX_VERTEX_NUM 20000
#include <queue>

using namespace std;

/**
    The data structure of graph is adjacency list.
**/

//This is the struct for edge.
typedef struct node {
    int adjvex;//the adjacent vertex id
    struct node* next;//the pointer to the next adjacent node
}EDGENODE;

//This is the struct for vertex.
typedef struct vnode {
    int vertex_id; // the vertex id;
    int vertex_label; // the vertex label;
    EDGENODE* first_edge;// the pointer to the first edge
    int neighbor_count; // the number of the neighbor of current node
}VERTEX;

typedef VERTEX ADJLIST[MAX_VERTEX_NUM];

typedef struct {
    int nvertices;// Number of vertices in the graph
    int nedge;// Number of edges in the graph
    //VERTEX* vertex_list;//the list of all vertices in the graph
    ADJLIST adjList; //the list of all vertices in the graph
    queue<int> active_labels;
}GRAPH;


#endif // GRAPH_H
