#include "cluster.h"
#include <QVector3D>

Cluster::Cluster()
{

}

Cluster::Cluster(QVector<QString> entities)
{
    m_vEntities.clear();
    m_vEntities = entities;
}

void Cluster::getEntities(QVector<QString> entities)
{
    m_vEntities.clear();
    m_vEntities = entities;
}

void Cluster::setPathPos(QString filename)
{
    m_vDiff.clear();
    QFile file(filename);
    QVector<QStringList> vLines;

    if (file.open(QIODevice::ReadOnly)) {
        QTextStream in(&file);
        while (!in.atEnd()) {
            QString str = in.readLine();
            QStringList text = str.split(QRegExp(",| "),
                                         QString::SkipEmptyParts);
            vLines.push_back(text);
        }
    }
    else
    {
        qDebug() << "Cannot open" << filename;
        exit(0);
    }

    //int n_min = INT_MAX;
    if (vLines.empty()) {
        m_vDiff << 0;
    }
    else {
        for (int i = 0; i < vLines[0].size(); i++) {
            m_vDiff << vLines[0].value(i).toInt();
        }
        //for (int i = 0; i < vLines[0].size(); i++) {
        //    n_min = n_min <= vLines[0].value(i).toInt() ?
        //                n_min : vLines[0].value(i).toInt();
        //}
        //for (int i = 0; i < vLines[0].size(); i++) {
        //    m_vDiff << vLines[0].value(i).toInt() - n_min;
        //}
    }
}

void Cluster::setCP(int n)
{
    QString s_entity;
    int     n_group;
    // default value initiated, label numbers can not be larger than n_Line
    int     n_Line = m_vEntities.size() + 1;
    QMap<QString, int> m_table;
    QMap<QString, int> m_tmp;
    QVector<int>       v_label;
    v_label.push_back(n_Line);
    for (int i = 0; i < m_vEntities.size(); i++) {
        s_entity          = m_vEntities[i];
        m_table[s_entity] = n_Line;
        m_tmp[s_entity] = i;
    }

    for (int i = 0; i < m_vEntities.size(); i++) {
        s_entity = m_vEntities[i];
        n_group  = m_tmp[s_entity];
        m_table[s_entity] = n_group;
        v_label.push_back(n_group);
    }
    qSort(v_label.begin(), v_label.end());
    v_label.erase(std::unique(v_label.begin(), v_label.end()), v_label.end());

    //dynamic assign position for all entities
    if (n == 0) {
        this->setPos(m_table, v_label);
    }
    else {
        this->appPos(m_table, v_label);
    }

    //set the color
    this->setColors(m_table, v_label);
}

void Cluster::setPos(QMap<QString, int> table, QVector<int> label)
{
    QVector<QString> *v_pTmp = new QVector<QString>[label.size()];
    QMap<QString, int>::iterator itr = table.begin();

    for (itr = table.begin(); itr != table.end(); itr++) {
        v_pTmp[label.indexOf(itr.value())] << itr.key();
    }

    for (int i = 0; i < label.size(); i++) {
        m_pPosTable << v_pTmp[i];
        m_pTable    << v_pTmp[i];
    }
    delete[] v_pTmp;
    v_pTmp = NULL;
}

void Cluster::appPos(QMap<QString, int> table, QVector<int> label)
{
    // clear such that every asix can be recomputed
    m_pTable.clear();
    QVector<QString> *v_pTmp = new QVector<QString>[label.size()];
    QMap<QString, int>::iterator itr = table.begin();

    // dynamic position for all entities
    for (itr = table.begin(); itr != table.end(); itr++) {
        v_pTmp[label.indexOf(itr.value())] << itr.key();
    }

    m_pPosTable << m_pTable;
    for (int i = 0; i < label.size(); i++) {
        m_pPosTable << v_pTmp[i];
        m_pTable    << v_pTmp[i];
    }
    delete[] v_pTmp;
    v_pTmp = NULL;
}

void Cluster::setColors(QMap<QString, int> m_table, QVector<int> label)
{
    float n_tmp;
    QColor gColor;
    for (int i = 0; i < m_pTable.size(); i++) {
        if (m_table[m_pTable[i]] != (m_vEntities.size() + 1)) {
            int n = m_table[m_pTable[i]];
            n_tmp = label.indexOf(n) * 1.0 / (label.size() - 1) * 1.0;
            float f_interval = 1.0 / 15;
            if (n_tmp == 0)
            {
                gColor = QColor(255 * 0.36, 255 * 0.95, 255 * 0.0);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 0.0 && n_tmp <= 1 * f_interval)
            {
                gColor = QColor(255 * 0.0, 255 * 0.8, 255 * 0.05);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 1 * f_interval && n_tmp <= 2 * f_interval)
            {
                gColor = QColor(255 * 0.0, 255 * 0.64, 255 * 0.5);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 2 * f_interval && n_tmp <= 3 * f_interval)
            {
                gColor = QColor(255 * 0.04, 255 * 0.38, 255 * 0.64);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 3 * f_interval && n_tmp <= 4 * f_interval)
            {
                gColor = QColor(255 * 0.12, 255 * 0.1, 255 * 0.7);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 4 * f_interval && n_tmp <= 5 * f_interval)
            {
                gColor = QColor(255 * 0.28, 255 * 0.07, 255 * 0.68);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 5 * f_interval && n_tmp <= 6 * f_interval)
            {
                gColor = QColor(255 * 0.42, 255 * 0.04, 255 * 0.68);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 6 * f_interval && n_tmp <= 7 * f_interval)
            {
                gColor = QColor(255 * 0.65, 255 * 0.0, 255 * 0.65);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 7 * f_interval && n_tmp <= 8 * f_interval)
            {
                gColor = QColor(255 * 0.8, 255 * 0.0, 255 * 0.47);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 8 * f_interval && n_tmp <= 9 * f_interval)
            {
                gColor = QColor(255 * 0.8, 255 * 0.0, 255 * 0.28);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 9 * f_interval && n_tmp <= 10 * f_interval)
            {
                gColor = QColor(255 * 1.0, 255 * 0.0, 255 * 0.05);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 10 * f_interval && n_tmp <= 11 * f_interval)
            {
                gColor = QColor(255 * 1.0, 255 * 0.3, 255 * 0.0);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 11 * f_interval && n_tmp <= 12 * f_interval)
            {
                gColor = QColor(255 * 1.0, 255 * 0.46, 255 * 0.0);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 12 * f_interval && n_tmp <= 13 * f_interval)
            {
                gColor = QColor(255 * 1.0, 255 * 0.57, 255 * 0.0);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 13 * f_interval && n_tmp <= 14 * f_interval)
            {
                gColor = QColor(255 * 1.0, 255 * 0.76, 255 * 0.0);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 14 * f_interval && n_tmp <= 15 * f_interval)
            {
                gColor = QColor(255 * 1.0, 255 * 0.91, 255 * 0.0);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 14 * f_interval && n_tmp <= 15 * f_interval)
            {
                gColor = QColor(255 * 1.0, 255 * 1.0, 255 * 0.0);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 14 * f_interval && n_tmp <= 15 * f_interval)
            {
                gColor = QColor(255 * 0.81, 255 * 0.96, 255 * 0.0);
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 14 * f_interval && n_tmp <= 15 * f_interval)
            {
                gColor = QColor(255 * 0.62, 255 * 0.93, 255 * 0.0);
                m_vColorTable.push_back(gColor);
            }
        }
        else {
            gColor = Qt::black;
            m_vColorTable.push_back(gColor);
        }
    }
}

QColor Cluster::getColor(float ratio)
{
    /**
     * In situ color
     *
    QVector3D C2(64, 255, 64);
    QVector3D C1(0, 153, 255);
    QVector3D C0(0, 255, 191);
    */

    QVector3D C6(255, 64, 64); //red // 1
    QVector3D C5(255, 125, 125); // light red
    QVector3D C4(255, 128, 191); // purple red
    QVector3D C3(255, 128, 64); // orange // 2
    QVector3D C2(0, 153, 255); // blue
    QVector3D C1(51, 255, 153); // green //3
    QVector3D C0(64, 255, 255); // blue green

    float n_factor = ratio;

    if (n_factor < 0) {
        n_factor = 0;
    }

    if (n_factor > 1) {
        n_factor = 1;
    }
    QVector3D C;

    float rate = 0.1666f;
    if (n_factor <= rate && n_factor >= 0) {
        C = (rate - n_factor) * C0 / rate + (n_factor - rate * 0) * C1 / rate;
    } else if (n_factor <= rate * 2 && n_factor > rate * 1) {
        C = (rate * 2 - n_factor) * C1 / rate + (n_factor - rate * 1) * C2 / rate;
    } else if (n_factor <= rate * 3 && n_factor > rate * 2) {
        C = (rate * 3 - n_factor) * C2 / rate + (n_factor - rate * 2) * C3 / rate;
    } else if (n_factor <= rate * 4 && n_factor > rate * 3) {
        C = (rate * 4 - n_factor) * C3 / rate + (n_factor - rate * 3) * C4 / rate;
    } else if (n_factor <= rate * 5 && n_factor > rate * 4) {
        C = (rate * 5 - n_factor) * C4 / rate + (n_factor - rate * 4) * C5 / rate;
    } else if (n_factor <= 1.0f && n_factor > rate * 5) {
        C = (1.0f - n_factor) * C5 / rate + (n_factor - rate * 5) * C6 / rate;
    }

    /**
     *In situ
     *
    if (n_factor < 0.5) {
        C = (0.5 - n_factor) * C0 / 0.5f + n_factor * C1 / 0.5f;
    } else {
        C = (1.0 - n_factor) * C1 / 0.5f + (n_factor - 0.5f) * C2 / 0.5f;
    }
    */

    QColor gColor = QColor(C.x(), C.y(), C.z());


    return gColor;


}

QColor Cluster::getColor(int result)
{
    QColor qColor;
    if (result == 0) {
        qColor = QColor(255 * 0.7, 255 * 0.7, 255 * 0.7);
    } else if (result ==1) {
        qColor = QColor(255 * 0.5, 255 * 0.5, 255 * 0.5);
    }
    return qColor;
}
