#include "cdata.h"

CRelation::CRelation()
{
}

CData::CData()
{

}

CData::CData(QString filename)
{
    this->ReadRelations(filename);
}

void CData::getFileName(QString filename)
{
    this->ReadRelations(filename);
}

void CData::ReadRelations(QString filename)
{
    /**
     *Read the text from file
     */
    string s_file = filename.toStdString();
    ifstream inFile(s_file.c_str());
    if (inFile.is_open()) {
        while (!inFile.eof()) {
            string sender, recver, time;
            u_int64_t size;
            //int s, r;
            inFile >> sender >> recver >> size >> time;
            if (inFile.fail()) {
                break;
            }
            CRelation relation(QString::fromStdString(sender),
                               QString::fromStdString(recver),
                               size,
                               QString::fromStdString(time));

            m_vRelations.push_back(relation);
            m_vEntities.push_back(atoi(sender.c_str()));
            m_vEntities.push_back(atoi(recver.c_str()));
            //m_vEntities.push_back(relation.Sender());
            //m_vEntities.push_back(relation.Receiver());
            m_vTimes.push_back(QString::fromStdString(time));
        }
    } else {
        cout << "Cannot open the " << s_file  << "file" << endl;
        exit(1);
    }
    inFile.close();

    qSort(m_vEntities.begin(), m_vEntities.end());
    m_vEntities.erase(std::unique(m_vEntities.begin(), m_vEntities.end()),
                      m_vEntities.end());

    qSort(m_vTimes.begin(), m_vTimes.end());
    m_vTimes.erase(std::unique(m_vTimes.begin(), m_vTimes.end()),
                   m_vTimes.end());
    for (int i = 0; i < m_vEntities.size(); i++) {
        m_vSEntities.push_back(QString::number(m_vEntities[i]));
    }

    /**
     *Construct the send and recv amount tables
     */
    m_nTotalEntities = m_vEntities.size();
    m_nTotalTime = m_vTimes.size();

    //qDebug() << "The total number of the entities is " << m_nTotalEntities;
}

void CData::EntityColor(QVector<QColor> colormap) {
    m_vColor = colormap;
    /**
     *initiate the color of the last time axis
     */
    for (int i = 0; i < m_nTotalEntities; i++) {
        m_vColor.push_back(m_vColor[m_nTotalEntities * (m_vTimes.size() - 1)
                + i]);
    }
}


void CData::EntityPos(QVector<QString> label)
{
    m_entity_map = new QMap<QString, int>[m_vTimes.size() + 1];
    m_vAllEntities = label;
    /**
     *initiate the position of the last time asix
     */
    for (int i = 0; i < m_nTotalEntities; i++) {
        m_vAllEntities.push_back(m_vAllEntities[m_nTotalEntities
                                 * (m_vTimes.size() - 1) + i]);
    }


    for (int i = 0; i <= m_vTimes.size(); i++) {
        for (int j = 0; j < m_nTotalEntities; j++) {
            m_entity_map[i][m_vAllEntities[m_nTotalEntities * i + j]]
                                         = m_nTotalEntities * i + j;
        }
    }

    for (int i = 0; i < m_vTimes.size(); i++) {
        m_time_map[m_vTimes[i]] = i;
    }

    /**
     *Update the index numbers in the relationships
     */
    for (int i = 0; i < m_vRelations.size(); i++) {
            m_vRelations[i].TimeIndex(m_time_map[m_vRelations[i].Time()]);
            m_vRelations[i].SenderIndex(m_entity_map[m_vRelations[i]
                    .TimeIndex()][m_vRelations[i].Sender()]);
            m_vRelations[i].ReceiverIndex(m_entity_map[m_vRelations[i]
                    .TimeIndex() + 1][m_vRelations[i].Receiver()]);
    }


    m_pSendAmount = new u_int64_t[m_nTotalEntities * (m_nTotalTime + 1)];
    memset(m_pSendAmount, 0, sizeof(u_int64_t) * m_nTotalEntities
           * (m_nTotalTime + 1));

    m_pRecvAmount = new u_int64_t[m_nTotalEntities * (m_nTotalTime + 1)];
    memset(m_pRecvAmount, 0, sizeof(u_int64_t) * m_nTotalEntities
           * (m_nTotalTime + 1));

    m_nMaxAmount    = 0;
    m_nGlbMaxAmount = 0;
    for (int i = 0; i < m_vRelations.size(); i++) {

        int send_id = m_vRelations[i].SenderIndex();
        int recv_id = m_vRelations[i].ReceiverIndex();
        //int time_id = m_vRelations[i].TimeIndex();

        //m_pSendAmount[send_id + time_id * m_nTotalEntities]
        //              += m_vRelations[i].Amount();

        //m_pRecvAmount[recv_id + (time_id + 1) * m_nTotalEntities]
        //              += m_vRelations[i].Amount();

        m_pSendAmount[send_id] += m_vRelations[i].Amount();

        m_pRecvAmount[recv_id] += m_vRelations[i].Amount();

        if (m_nMaxAmount < m_pRecvAmount[recv_id])
        {
            m_nMaxAmount = m_pRecvAmount[recv_id];
        }
        if (m_nMaxAmount < m_pSendAmount[send_id])
        {
            m_nSMaxAmount = m_pSendAmount[send_id];
        }
        if (m_nGlbMaxAmount < m_vRelations[i].Amount())
        {
            m_nGlbMaxAmount = m_vRelations[i].Amount();
        }
    }


    m_pColMax = new u_int64_t[m_nTotalTime + 1];
    memset(m_pColMax, 0, sizeof(u_int64_t) * (m_nTotalTime + 1));

    m_pAccumulate = new u_int64_t[m_nTotalEntities * (m_nTotalTime + 1)];
    memset(m_pAccumulate, 0, sizeof(u_int64_t)
           * m_nTotalEntities * (m_nTotalTime + 1));

    u_int64_t n_ColMax = 0;
    u_int64_t n_tmp = 0;
    u_int64_t n_SAmount;
    u_int64_t n_RAmount;
    u_int64_t n_SRtmp;
    for (int i = 0; i < m_nTotalTime + 1; i++)
    {
        n_tmp = 0;
        for (int j = 0; j < m_nTotalEntities; j++)
        {
            n_SAmount = m_pSendAmount[m_nTotalEntities * i + j];
            n_RAmount = m_pRecvAmount[m_nTotalEntities * i + j];
            n_SRtmp = n_SAmount > n_RAmount ? n_SAmount : n_RAmount;
            n_ColMax += n_SRtmp;
            m_pAccumulate[m_nTotalEntities * i + j] = n_tmp + n_SRtmp;
            n_tmp = m_pAccumulate[m_nTotalEntities * i + j];
        }
        m_pColMax[i] = n_ColMax;
        n_ColMax = 0;
    }
}

void CData::clean()
{
    if (m_pSendAmount != NULL) {
        delete[] m_pSendAmount;
        m_pSendAmount = NULL;
    }
    if (m_pRecvAmount != NULL) {
        delete[] m_pRecvAmount;
        m_pRecvAmount = NULL;
    }
    if (m_entity_map != NULL) {
        delete[] m_entity_map;
        m_entity_map = NULL;
    }
    if (m_pColMax != NULL) {
        delete[] m_pColMax;
        m_pColMax = NULL;
    }
    if (m_pAccumulate != NULL) {
        delete[] m_pAccumulate;
        m_pAccumulate = NULL;
    }
}
