#ifndef BUILDGRAPH_H
#define BUILDGRAPH_H


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>
#include <sstream>
#include <map>
#include <iostream>
#include "graph.h"

#define LINELENGTH 1000

using namespace std;


class BuildGraph
{
public:
    BuildGraph();

    int read_line(FILE* stream, char line[]);

    int fill_buffer(FILE* stream);
    void free_buffer();

    void reset_buffer();

    int read_nextLine(char line[]);

    int count_vertices();

    int getFirstVertex();

    void createGraph(GRAPH* G, map<int, int>& Map_1, map<int, int> &Map_2);

    void createGraph(GRAPH* G);

    void displayGraph(GRAPH* G);

    void displayGraphLabel(GRAPH* G, int n);

    void displayGraphLabel(GRAPH* G, string ouput);

    void displayGraphLabelFinal(GRAPH* G);

    void splitGraphLabel(GRAPH*, int);

    GRAPH* buildGraph(const char*, int *n);

    GRAPH* buildGraph(const char*, int *n,
                      map<int, int>& Map_1, map<int, int> &Map_2);

private:

    typedef struct line {
        char* str;
        struct line* ptr;
    }LINE;

    LINE* first;
    LINE* current;

    int first_id;
};

#endif // BUILDGRAPH_H
