#include "buildgraph.h"

BuildGraph::BuildGraph()
{
}

int BuildGraph::read_line(FILE* stream, char line[LINELENGTH]) {
    if (fgets(line, LINELENGTH, stream) == NULL) return 1;
    line[strlen(line)-1] = '\0';
    //printf("%s\n", line);
    return 0;
}

/**
    Function to read in the whole file into a linked-list buffer,
    from GML format efficiently.
**/
int BuildGraph::fill_buffer(FILE* stream) {
    int length;
    char line[LINELENGTH];
    LINE* previous;

    if (read_line(stream, line) != 0) {
        first = NULL;
        return 1;
    }

    length = strlen(line) + 1;
    first = (LINE*)malloc(sizeof(LINE));
    first->str = (char*)malloc(length*sizeof(char));
    strcpy(first->str, line);

    previous = first;
    while (read_line(stream, line) == 0) {
        length = strlen(line) + 1;
        previous->ptr = (LINE*)malloc(sizeof(LINE));
        previous = previous->ptr;
        previous->str = (char*)malloc(length*sizeof(char));
        strcpy(previous->str, line);
    }
    previous->ptr = NULL;
    return 0;
}

/**
    Function to free the buffer again
**/
void BuildGraph::free_buffer() {
    LINE* thisptr;
    LINE* nextptr;

    thisptr = first;
    while (thisptr != NULL) {
        nextptr = thisptr->ptr;
        free(thisptr->str);
        free(thisptr);
        thisptr = nextptr;
    }
}

/**
    Function to reset to the start of the buffer again
**/
void BuildGraph::reset_buffer() {
    current = first;
}

/**
    Function to get the next line in the buffer. Returns 0 if there is a line,
    or 1 if we have reached the end of the buffer.
**/

int BuildGraph::read_nextLine(char line[LINELENGTH]) {
    if (current == NULL) return 1;
    strcpy(line, current->str);
    current = current->ptr;
    return 0;
}

/**
    Function to count the vertices in a GML file. Returns number of vertices.
**/
int BuildGraph::count_vertices() {
    int result = 0;
    char* ptr;
    char line[LINELENGTH];

    reset_buffer();

    while (read_nextLine(line) == 0) {
        ptr = strstr(line, "node");
        if (ptr != NULL) result++;
    }
    return result;
}

int BuildGraph::getFirstVertex() {
    int first_v = 0;
    char* ptr;
    char line[LINELENGTH];

    reset_buffer();
    if (read_nextLine(line) == 0) {
        ptr = strstr(line, "node[");
        if (ptr != NULL) {
            sscanf(ptr, "node[ id %d ]", &first_v);
        }
    }
    return first_v;
}
/*
void build_edges() {
    int result = 0;
    char* ptr;
    char line[LINELENGTH];

    reset_buffer();
    int start, end;
    while (read_nextLine(line) == 0) {
        ptr = strstr(line, "edge[");
        if (ptr != NULL) {
            sscanf(ptr, "edge[ source %d target %d]", &start, &end);
            printf("%d--%d\n", start, end);
        }
    }
}*/

/**
    Function to allocate space for a graph structure in a GML file.
**/

void BuildGraph::createGraph(GRAPH* G) {
    int i;
    char* ptr;
    char line[LINELENGTH];

    int start, end;

    G->nvertices = count_vertices();
    G->nedge = 0;
    first_id = getFirstVertex();

    /*
    cout << "******************************************" << endl;
    cout << "The number of vertices is " << G->nvertices << endl;
    cout << "******************************************" << endl;
    */

    //Initial the nodes with id and label
    for (i = first_id; i < G->nvertices; i++) {
        G->adjList[i].vertex_id = i;
        G->adjList[i].vertex_label = i;
        G->adjList[i].first_edge = NULL;
        G->adjList[i].neighbor_count = 0;
    }

    reset_buffer();

    while (read_nextLine(line) == 0) {
        ptr = strstr(line, "edge[");
        if (ptr != NULL) {
            G->nedge += 1;
            sscanf(ptr, "edge[ source %d target %d]", &start, &end);
            //printf("%d--%d\n", start, end);
            EDGENODE* s = (EDGENODE*)malloc(sizeof(EDGENODE));
            s->adjvex = end;
            s->next = G->adjList[start].first_edge;
            G->adjList[start].first_edge = s;
            G->adjList[start].neighbor_count++;
            s = (EDGENODE*)malloc(sizeof(EDGENODE));
            s->adjvex = start;
            s->next = G->adjList[end].first_edge;
            G->adjList[end].first_edge = s;
            G->adjList[end].neighbor_count++;
        }
    }
}


void BuildGraph::createGraph(GRAPH* G, map<int, int>& nodeMap,
                             map<int, int>& NodeDic) {
    //int i;
    char* ptr;
    char line[LINELENGTH];

    int start, end;
    int nodeid;
    G->nvertices = count_vertices();
    G->nedge = 0;
    first_id = getFirstVertex();
    int nodeMapping = 0;
    reset_buffer();
    //int result = 0;

    /*
    cout << "******************************************" << endl;
    cout << "The number of vertices is " << G->nvertices << endl;
    cout << "******************************************" << endl;
    */

    while (read_nextLine(line) == 0) {
        ptr = strstr(line, "node");
        if (ptr != NULL) {
            sscanf(ptr, "node [ id %d ]", &nodeid);
            nodeMap[nodeid] = nodeMapping;
            NodeDic[nodeMapping] = nodeid;
            G->adjList[nodeMapping].vertex_id = nodeMapping;
            G->adjList[nodeMapping].vertex_label = nodeMapping;
            G->adjList[nodeMapping].first_edge = NULL;
            G->adjList[nodeMapping].neighbor_count = 0;
            //cout<<nodeid<<endl;
            nodeMapping++;
        }
    }
    reset_buffer();

    while (read_nextLine(line) == 0) {
        ptr = strstr(line, "edge[");
        if (ptr != NULL) {
            G->nedge += 1;
            sscanf(ptr, "edge[ source %d target %d]", &start, &end);
            //printf("%d--%d\n", start, end);
            EDGENODE* s = (EDGENODE*)malloc(sizeof(EDGENODE));
            start = nodeMap[start];
            end = nodeMap[end];
            s->adjvex = end;
            s->next = G->adjList[start].first_edge;
            G->adjList[start].first_edge = s;
            G->adjList[start].neighbor_count++;
            s = (EDGENODE*)malloc(sizeof(EDGENODE));
            s->adjvex = start;
            s->next = G->adjList[end].first_edge;
            G->adjList[end].first_edge = s;
            G->adjList[end].neighbor_count++;
        }
    }
}

void BuildGraph::displayGraph(GRAPH* G) {
    int i;
    EDGENODE* nextEdge = NULL;
    for (i = first_id; i < G->nvertices; i++) {
        //printf("%d\n", G->adjList[i].vertex_id);
        if (G->adjList[i].first_edge != NULL) {
            //printf("!!!!!!!!!!");
            nextEdge = G->adjList[i].first_edge;
            //printf("%d\n", nextEdge->adjvex);
            while (nextEdge != NULL) {
                //printf("%d--%d\n", G->adjList[i].vertex_id, nextEdge->adjvex);
                nextEdge = nextEdge->next;
            }
        }
    }
}

void BuildGraph::displayGraphLabel(GRAPH* G, int n) {
    int i;
    //EDGENODE* nextEdge = NULL;
    string output = "../DATA/LABEL/LABEL_";
    stringstream out;
    out << n;
    string s_num = "";
    if (n <= 9) {
        s_num = "0";
    }
    output = output + s_num + out.str();
    char *outChar = const_cast<char *> (output.c_str());
    ofstream outFile(outChar);

    for (i = first_id; i < G->nvertices; i++) {
        outFile << "id: "
                << G->adjList[i].vertex_id
                << " "
                << "label: "
                << G->adjList[i].vertex_label
                << endl;
        /*
        cout << "label: "
             << G->adjList[i].vertex_label
             << " "
             << "id: "
             << G->adjList[i].vertex_id
             << endl;
        */
    }
}

void BuildGraph::displayGraphLabel(GRAPH* G, string output) {
    int i;
    char *outChar = const_cast<char *> (output.c_str());
    ofstream outFile(outChar);
    for (i = first_id; i < G->nvertices; i++) {
        outFile << "id: "
                << G->adjList[i].vertex_id
                << " "
                << "label: "
                << G->adjList[i].vertex_label
                << endl;
    }
}

void BuildGraph::splitGraphLabel(GRAPH* G, int n) {
    int i;
    //EDGENODE* nextEdge = NULL;
    string output = "../DATA/SUB/LABEL_";
    stringstream out;
    out << n;
    string s_num = "";
    if (n <= 9) {
            s_num = "0";
    }
    output = output + s_num + out.str();
    char *outChar = const_cast<char *> (output.c_str());
    ofstream outFile(outChar);
    for (i = first_id; i < G->nvertices; i++) {
        outFile << "id: "
            << G->adjList[i].vertex_id
            << " "
            << "label: "
            << G->adjList[i].vertex_label
            << endl;
    }
}

void BuildGraph::displayGraphLabelFinal(GRAPH* G) {
    int i;
    ofstream out("finalLabel.txt");
    //EDGENODE* nextEdge = NULL;
    for (i = first_id; i < G->nvertices; i++) {
        //printf("node[ id %d label %d ]\n", G->adjList[i].vertex_id,
                 //G->adjList[i].vertex_label);
        char str[200] = "node [id ";
        //char* temp1 = itoa(G->adjList[i].vertex_id, NULL, 10);
        char temp1[200];
        sprintf(temp1, "%d", G->adjList[i].vertex_id);
        strcat(str, temp1);
        strcat(str, " label ");
        //strcat(str, itoa(G->adjList[i].vertex_label));
        sprintf(temp1, "%d", G->adjList[i].vertex_label);
        strcat(str, temp1);
        strcat(str, " ]\n");
        out.write(str, strlen(str));
        //printf("    [\n");
        //printf("      id %d\n", G->adjList[i].vertex_id);
        //printf("      label \" %d \"\n", G->adjList[i].vertex_label);
        //printf("    ]\n");
    }
    out.close();
}


GRAPH* BuildGraph::buildGraph(const char* fileName, int *NUM) {
    GRAPH* g = (GRAPH*)malloc(sizeof(GRAPH));
    FILE* file;
    file = fopen(fileName, "r");
    //char line[LINELENGTH];
    fill_buffer(file);
    createGraph(g);
    *NUM = count_vertices();
    return g;
}


GRAPH* BuildGraph::buildGraph(const char* fileName, 
                              int *NUM,
                              map<int, int> &map_1,
                              map<int, int> &map_2)
{
    GRAPH* g = (GRAPH*)malloc(sizeof(GRAPH));
    FILE* file;
    file = fopen(fileName, "r");
    //char line[LINELENGTH];
    fill_buffer(file);
    createGraph(g, map_1, map_2);
    *NUM = count_vertices();
    return g;
}
