#include "writegraph.h"

WriteGraph::WriteGraph()
{

}

void WriteGraph::write(int count)
{
    system("exec rm -r ../DATA/DAT/*");
    vector<string> v_filenames;

    for (int i = 0; i < count; i++) {
       stringstream ss_out;
       ss_out << i;
       string s_num = "";
       string strGML = "../DATA/GML/KARATE_";
       if (i <= 9) {
           s_num = "0";
       }
       strGML = strGML + s_num + ss_out.str() + ".gml";
       v_filenames.push_back(strGML);
    }

    for (size_t k = 0; k < v_filenames.size(); k++) {
       string filename = v_filenames[k];
       //cout << filename << endl;

       int row = 0;
       int col = 0;
       int* graph;
       //cout<<"success"<<endl;
       char* gmlFile = const_cast<char *> (filename.c_str());

       FILE* file;
       file = fopen(gmlFile, "r");
       //cout << "test" << endl;
       fill_buffer(file);
       int nodeNum = count_vertices();
       //cout << nodeNum << endl;
       row = col = nodeNum;
       graph = new int[row*col];
       memset(graph, 0, sizeof(int) * row * col);
       createGraph(graph, row, col);

       stringstream out;
       out << k;
       string s_num = "";
       if (k <= 9) {
               s_num = "0";
       }
       string str = "../DATA/DAT/KARATE_";
       str = str + s_num + out.str() + ".dat";
       char *outFile = const_cast<char *> (str.c_str());
       ofstream outf(outFile, ios_base::in | ios_base::out | ios_base::app);

       for (int i = 0; i < row; i++) {
           for (int j = 0; j < col; j++) {
               outf.write(reinterpret_cast<const char*>(&graph[i*col+j]),
                          sizeof(int));
           }
       }
       outf.close();
       //cout<<"success!"<<endl;
       delete[] graph;
       graph=NULL;
    }
}


int WriteGraph::read_line(FILE* stream, char line[LENGTH])
{
   if (fgets(line, LENGTH, stream) == NULL) return 1;
   line[strlen(line)-1] = '\0';
   return 0;
}

/**
   Function to read in the whole file into a linked-list buffer,
   from GML format efficiently.
**/
int WriteGraph::fill_buffer(FILE* stream)
{
   int length;
   char line[LENGTH];
   LINE* previous;

   if (read_line(stream, line) != 0) {
       first = NULL;
       return 1;
   }

   length = strlen(line) + 1;
   first = (LINE*)malloc(sizeof(LINE));
   first->str = (char*)malloc(length*sizeof(char));
   strcpy(first->str, line);

   previous = first;
   while (read_line(stream, line) == 0) {
       length = strlen(line) + 1;
       previous->ptr = (LINE*)malloc(sizeof(LINE));
       previous = previous->ptr;
       previous->str = (char*)malloc(length*sizeof(char));
       strcpy(previous->str, line);
   }
   previous->ptr = NULL;
   return 0;
}

/**
   Function to free the buffer again
**/
void WriteGraph::free_buffer() {
   LINE* thisptr;
   LINE* nextptr;

   thisptr = first;
   while (thisptr != NULL) {
       nextptr = thisptr->ptr;
       free(thisptr->str);
       free(thisptr);
       thisptr = nextptr;
   }
}

/**
   Function to reset to the start of the buffer again
**/
void WriteGraph::reset_buffer() {
   current = first;
}

/**
   Function to get the next line in the buffer. Returns 0 if there is a line,
   or 1 if we have reached the end of the buffer.
**/

int WriteGraph::read_nextLine(char line[LENGTH]) {
   if (current == NULL) return 1;
   strcpy(line, current->str);
   current = current->ptr;
   return 0;
}

/**
   Function to count the vertices in a GML file. Returns number of vertices.
**/
int WriteGraph::count_vertices() {
   int result = 0;
   char* ptr;
   char line[LENGTH];

   reset_buffer();

   while (read_nextLine(line) == 0) {
       ptr = strstr(line, "node");
       if (ptr != NULL) result++;
   }
   return result;
}

int WriteGraph::getFirstVertex() {
   int first_v = 0;
   char* ptr;
   char line[LENGTH];

   reset_buffer();
   if (read_nextLine(line) == 0) {
       ptr = strstr(line, "node[");
       if (ptr != NULL) {
           sscanf(ptr, "node[ id %d ]", &first_v);
       }
   }
   return first_v;
}

void WriteGraph::createGraph(int* graph, int row, int col) {
   //int i;
   char* ptr;
   char line[LENGTH];

   int start, end;

   reset_buffer();

   while (read_nextLine(line) == 0) {
       ptr = strstr(line, "edge[");
       if (ptr != NULL) {
           sscanf(ptr, "edge[ source %d target %d ]", &start, &end);
           //graph[(start-1) * col + (end - 1)] = 1;
           //graph[(end-1) * col + (start-1)] = 1;
           graph[start * col + end] = 1;
           graph[end * col + start] = 1;
           //printf("%d--%d\n", start, end);
           //graph[start-1][end-1] = 1;
           //graph[end-1][start-1] = 1;
       }
   }
}

//int main() {
//	cout << "test" << endl;
//	WriteGraph *graph = new WriteGraph(10);
//}

