#ifndef POLYGON_H
#define POLYGON_H

#include <QWidget>
#include <QPolygonF>
#include <QPainter>
#include <QDebug>
#include <QtCore/qmath.h>
#include <vector>

using namespace std;

class CPolygon
{

public:

    CPolygon();

    void Value(float f) {
        m_fValue = f;
    }

    float Value() {
        return m_fValue;
    }

    void setPolygon(QList<QPolygonF> triangles)
    {
        m_lTrigs = triangles;
    }

    void setPlg(QPolygonF polygon)
    {
        m_pPolygon = polygon;
    }

    void setColor_1(QColor color)
    {
        m_qColor_1 = color;
    }

    void setColor_2(QColor color)
    {
        m_qColor_2 = color;
    }

    QColor getColor_1()
    {
        return m_qColor_1;
    }

    QColor getColor_2()
    {
        return m_qColor_2;
    }

    void setTime(int time)
    {
        m_nTime = time;
    }

    QList<QPolygonF>& getPolygon()
    {
        return m_lTrigs;
    }

    QPolygonF getPlg()
    {
        return m_pPolygon;
    }

    int getTime()
    {
        return m_nTime;
    }

    void gdtStart(QPointF gStart) {
        m_pGStart = gStart;
    }

    void gdtEnd(QPointF gEnd) {
        m_pGEnd = gEnd;
    }

    void setWidth(QList<float> width) {
        m_lWidth = width;
    }

    QList<float>& getWidth() {
        return m_lWidth;
    }

    float getWidth(int n) {
        return m_lWidth[n];
    }

    void setShow(bool show) {
        m_bShow = show;
    }

    bool getShow() {
        return m_bShow;
    }

    void setPlgMaxMin();

    float getPlgMax() {
        return m_fMax;
    }

    float getPlgMin() {
        return m_fMin;
    }

    void setPath_1(QPainterPath path)
    {
        m_ppPath_1 = path;
    }

    void setPath_2(QPainterPath path)
    {
        m_ppPath_2 = path;
    }

    QPainterPath& getPath_1()
    {
        return m_ppPath_1;
    }

    QPainterPath& getPath_2()
    {
        return m_ppPath_2;
    }


protected:


private:

    QPainterPath        m_ppPath_1;

    QPainterPath        m_ppPath_2;

    QList<QPolygonF>    m_lTrigs;

    QList<float>        m_lWidth;

    QPolygonF           m_pPolygon;

    QPointF             m_pGStart;

    QPointF             m_pGEnd;

    QColor              m_qColor_1;

    QColor              m_qColor_2;

    QString             m_sTime;

    int                 m_nTime;

    float               m_fValue;

    float               m_fMax;

    float               m_fMin;

    bool                m_bShow;

public:
    vector<QPointF>      m_vCtrlPoints;

};

#endif // POLYGON_H
