#ifndef GROUP_H
#define GROUP_H

#include <QVector>
#include <QString>
#include <QFile>
#include <QStringList>
#include <QTextStream>
#include <QDebug>
#include <QColor>
#include <QGLColormap>


class Group
{
public:
    Group(QVector<QString> entities);

    void setCP(QString file, int n);

    void setPathPos(QString file);

    void appPos(QMap<QString, int>, QVector<int>);

    int getColorNum()
    {
        return m_nColorNum;
    }

    QVector<QString>& getPos()
    {
        return m_pPosTable;
    }

    QVector<QColor>& getColors()
    {
        return m_vColorTable;
    }

    QVector<int>& getDiff()
    {
        return m_vDiff;
    }

protected:

private:

    int m_nColorNum;

    int m_nDiff;

    int m_nNum;

    QString m_sEntities;

    QColor m_pColor;

    QGLColormap m_pColorMap;

    QMap<QString, int> m_pMapTable;// import global member

    QMap<QString, QColor> m_pColorTable;

    QVector<int>        m_vDiff;

    QVector<QString>    m_pPosTable;

    QVector<QColor>     m_vColorTable;

    QVector<QString>    m_pTable;

    QVector<QString>    m_vEntities;

    void setColors(QMap<QString, int>, QVector<int>);

    void setPos(QMap<QString, int>, QVector<int>);
};

#endif // GROUP_H
