#include "group.h"

Group::Group(QVector<QString> entities)
{
    m_vEntities = entities;
}

void Group::setPathPos(QString filename)
{
    QFile file(filename);
    QVector<QStringList> vLines;

    if (file.open(QIODevice::ReadOnly))
    {
        QTextStream in(&file);
        while (!in.atEnd())
        {
            QString str = in.readLine();
            QStringList text = str.split(QRegExp(",| "),
                                         QString::SkipEmptyParts);
            vLines.push_back(text);
        }
    }
    else
    {
        qDebug() << "Cannot open" << filename;
        exit(0);
    }
    for (int i = 0; i < vLines[0].size(); i++) {
        m_vDiff << vLines[0].value(i).toInt();
    }
}

void Group::setCP(QString filename, int n)
{
    QFile file(filename);
    QVector<QStringList> vLines;

    if (file.open(QIODevice::ReadOnly))
    {
        QTextStream in(&file);
        while (!in.atEnd())
        {
            QString str = in.readLine();
            QStringList text = str.split(QRegExp(",| "),
                                         QString::SkipEmptyParts);
            vLines.push_back(text);
        }
    }
    else
    {
        qDebug() << "Cannot open " << filename;
        exit(0);
    }

    QString s_entity;
    int     n_group;
    // default value initiated, label numbers can not be larger than n_Line
    int     n_Line = m_vEntities.size() + 1;
    QMap<QString, int> m_table;
    QVector<int> v_label;
    v_label.push_back(n_Line);
    for (int i = 0; i < m_vEntities.size(); i++) {
        s_entity = m_vEntities[i];
        m_table[s_entity] = n_Line;
    }

    for (int i = 0; i < vLines.size(); i++)
    {
        s_entity = vLines[i].value(0);
        n_group  = vLines[i].value(1).toInt();
        m_table[s_entity] = n_group;
        v_label.push_back(n_group);
    }
    qSort(v_label.begin(), v_label.end());
    v_label.erase(std::unique(v_label.begin(), v_label.end()), v_label.end());

    // dynamic assign the position of the entities
    if (n == 0) {
        this->setPos(m_table, v_label);
    }
    else {
        this->appPos(m_table, v_label);
    }

    // set the color
    this->setColors(m_table, v_label);
}

void Group::setPos(QMap<QString, int> table, QVector<int> label)
{
    QVector<QString> *v_pTmp = new QVector<QString>[label.size()];
    QMap<QString, int>::iterator itr = table.begin();

    for (itr = table.begin(); itr != table.end(); itr++) {
        v_pTmp[label.indexOf(itr.value())] << itr.key();
    }

    for (int i = 0; i < label.size(); i++) {
        m_pPosTable << v_pTmp[i];
        m_pTable    << v_pTmp[i];
    }
}

void Group::appPos(QMap<QString, int> table, QVector<int> label)
{
    // clear such that every asix can be recomputed
//    m_pTable.clear();
    QVector<QString> *v_pTmp = new QVector<QString>[label.size()];
    QMap<QString, int>::iterator itr = table.begin();

    // dynamic position for all entities
    for (itr = table.begin(); itr != table.end(); itr++) {
        v_pTmp[label.indexOf(itr.value())] << itr.key();
    }

    m_pPosTable << m_pTable;
//    for (int i = 0; i < label.size(); i++) {
//        m_pPosTable << v_pTmp[i];
//        m_pTable    << v_pTmp[i];
//    }
}

void Group::setColors(QMap<QString, int> m_table, QVector<int> label)
{
    float n_tmp;
    QColor gColor;
    for (int i = 0; i < m_pTable.size(); i++) {
        if (m_table[m_pTable[i]] != (m_vEntities.size() + 1)) {
            int n = m_table[m_pTable[i]];
            n_tmp = label.indexOf(n) * 1.0 / (label.size() - 1) * 1.0;
            if (n_tmp == 0)
            {
                gColor = Qt::green;
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 0.0 && n_tmp <= 0.1)
            {
                gColor = Qt::darkRed;
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 0.1&& n_tmp <= 0.2)
            {
                gColor = Qt::green;
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 0.2 && n_tmp <= 0.3)
            {
                gColor = Qt::blue;
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 0.3 && n_tmp <= 0.4)
            {
                gColor = Qt::yellow;
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 0.4 && n_tmp <= 0.5)
            {
                gColor = Qt::cyan;
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 0.5 && n_tmp <= 0.6)
            {
                gColor = Qt::magenta;
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 0.6 && n_tmp <= 0.7)
            {
                gColor = Qt::red;
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 0.7 && n_tmp <= 0.8)
            {
                gColor = Qt::darkCyan;
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 0.8 && n_tmp <= 0.9)
            {
                gColor = Qt::darkMagenta;
                m_vColorTable.push_back(gColor);
            }
            else if (n_tmp > 0.9 && n_tmp <= 1.0)
            {
                gColor = Qt::darkGray;
                m_vColorTable.push_back(gColor);
            }
        }
        else {
            gColor = Qt::black;
            m_vColorTable.push_back(gColor);
        }
    }
}

// another color map
/*
    qreal q_colorMin_r = 0.0f;
    qreal q_colorMin_g = 1.0f;
    qreal q_colorMin_b = 1.0f;

    qreal q_color_r;
    qreal q_color_g;
    qreal q_color_b;

    qreal f_Grad = 0.3;
    qreal n_NorMax = 1.0;
    qreal n_NorMin = 0.0;

    qreal d_NGradient = n_NorMin - n_NorMax;
    qreal d_PGradient = n_NorMax - n_NorMin;

            if (n_tmp <= 0) {
                q_color_r = q_colorMin_r;
                q_color_g = q_colorMin_g;
                q_color_b = q_colorMin_b;
                color.setRgbF(q_color_r, q_color_g, q_colorMin_b);
                m_vColorTable.push_back(color);
                continue;
            }

            if (n_tmp <= 1.0) {
                int c = int(n_tmp * 100);
                qreal f = (c * 1.0f) / 100.0;
                q_color_r = q_colorMin_r + f * d_PGradient;
                q_color_g = q_colorMin_g + f * d_NGradient;
                q_color_b = q_colorMin_b + f * d_NGradient;
                color.setRgbF(q_color_r, q_color_g, q_colorMin_b);
                m_vColorTable.push_back(color);
                continue;
            }
            if (n_tmp <= 0.25) {
                int c = int((n_tmp / 0.25) * 100);
                qreal f = (c * 1.0f) / 100.0;
                q_color_r = q_colorMin_r + f * d_NGradient;
                q_color_g = q_colorMin_g;
                q_color_b = q_colorMin_b + f * d_NGradient;
                color.setRgbF(q_color_r, q_color_g, q_colorMin_b);
                m_vColorTable.push_back(color);
                continue;
            }

            if (n_tmp <= 0.5) {
                int c = int(((n_tmp - 0.25) / 0.25) * 100);
                qreal f = (c * 1.0f) / 100.0;
                q_color_r = q_colorMin_r;
                q_color_g = q_colorMin_g+ f * d_PGradient;
                q_color_b = q_colorMin_b;
                color.setRgbF(q_color_r, q_color_g, q_colorMin_b);
                m_vColorTable.push_back(color);
                continue;
            }

            if (n_tmp <= 0.75) {
                int c = int(((n_tmp - 0.5) / 0.25) * 100);
                qreal f = (c * 1.0f) / 100.0;
                q_color_r = q_colorMin_r;
                q_color_g = q_colorMin_g + f * d_PGradient;
                q_color_b = q_colorMin_b + f * d_NGradient;
                color.setRgbF(q_color_r, q_color_g, q_colorMin_b);
                m_vColorTable.push_back(color);
                continue;
            }

            if (n_tmp <= 1.0) {
                int c = int(((n_tmp - 0.75) / 0.25) * 100);
                qreal f = (c * 1.0f) / 100.0;
                q_color_r = q_colorMin_r + f * d_NGradient;
                q_color_g = q_colorMin_g + f * d_PGradient;
                q_color_b = q_colorMin_b;
                color.setRgbF(q_color_r, q_color_g, q_colorMin_b);
                m_vColorTable.push_back(color);
                continue;
            }
*/
