#ifndef GLWIDGET_H
#define GLWIDGET_H

#include <QDebug>
#include <QtGui>
#include <QtOpenGL>
#include <QGLFunctions>
#include <QOpenGLFunctions>
#include <QMouseEvent>
#include <QScrollArea>
#include <QGLWidget>
#include <QRectF>
#include <fstream>
#include <string>
#include "QLabel"
#include "cdata.h"
#include "cbar.h"
#include "label.h"
#include "line.h"
#include "group.h"
#include "ebundle.h"
#include "polygon.h"
#include "cluster.h"
#include "sourcedata.h"
#include "writegraph.h"
#include "hierarchy.h"
#include "cmap.h"
#include "linetext.h"

#ifndef FILE
#define FILE "CaseStudy_16"
#endif

#ifndef VERTICES
#define VERTICES 0
#endif

#ifndef COLORS
#define COLORS 1
#endif

#ifndef BUFFER_SIZE
#define BUFFER_SIZE 2
#endif

#ifndef PARTICLE
#define PARTICLE 10
#endif

#ifndef SUB
#define SUB "../DATA/SUB/MPI_SUB"
#endif

class GLWidget : public QGLWidget, public QGLFunctions
{
    Q_OBJECT

public:

    GLWidget();

    GLWidget(float width, float height, float pad,
             QString infile_1, QString infile_2,
             QWidget *parent = 0, QGLWidget *shareWidget = 0);

    GLWidget(int width, int height, int pad, int cluster,
             int sender, int recver,
             QString infile_1, Hierarchy* &hierarchy, CMap* &map,
             int time, string time1,
             QWidget *parent = 0, QGLWidget *shareWidget = 0);

    GLWidget(int width, int height, int pad, QString infile_1,
             Hierarchy* &hierarchy, CMap* &map, int time, string time1,
             QWidget *parent = 0, QGLWidget *shareWidget = 0);


	int tableSubmit()
	{
		return m_pData->GetTotalEntitiesNum();
	}


protected slots:

    void setXAxis(int gradient);

    void setYAxis(int gradient);

    void setZAxis(int gradient);

    void setKAxis(int gradient);

    void setSAxis(int gradient);

    void setCState(int check);

    void setKState(int check);

    void setLState(int check);

    void setXZoomState(int check);

    void setYZoomState(int check);

    void setFullZoomState(int check);

    void setGraph();

    void setCluster();

    void setInterval();

    void setSubCluster();

    void setSubAxis(int);

signals:

    void xAxisChanged(int gradient);

    void yAxisChanged(int gradient);

    void zAxisChanged(int gradient);

    void kAxisChanged(int gradient);

    void sAxisChanged(int gradient);

    void cAxisChanged(int gradient);

    void lAxisChanged(int gradient);

    void xZoomAxisChanged(int gradient);

    void yZoomAxisChanged(int gradient);

    void fullZoomAxisChanged(int gradient);

    void subAxisChanged(int);

    void shiftWindow(Hierarchy*, CMap*, int, int, int, int, string);

    void shiftWindow_full(Hierarchy*, CMap*, int, string);

protected:

    void Init();

    void InitGraph();

    void initializeGL();

    void resizeGL(int w, int h);

    void paintGL();

    void CutInterval();

    void CutCluster();

    void UpdateBuffer();

    void UpdateBarPos();

    void UpdateLabelPos();

    void UpdateLinePos();

    void UpdateSinglePolygonPos();

    void UpdateTagPos();

    void UpdateMSelection();

    void UpdatePlgBar_L();

    void UpdatePlgBar_R();

    void ClearPolygons();

    void ClearLines();

    void ClearBars();

    void adjSize(int);

    void ShowPolygons();

    void ShowLines();

    void ShowBars();

    void drawAxis();

    void drawBoundary();

    void drawPolygon();

    void drawLine();

    void Recompute();

    void clean();

private:

    void keyPressEvent(QKeyEvent *);

    void mousePressEvent(QMouseEvent *);

    void mouseReleaseEvent(QMouseEvent *);

    void mouseMoveEvent(QMouseEvent *);

    void mouseDoubleClickEvent(QMouseEvent *);

    void drawCurveBackbone();

    void drawCardiograph();

    void tagPolygon();

    void textEntity();

    void combineInterval();

    void splitInterval();

    void combineCluster();

    void splitCluster();

    void shiftOperation();

    void shiftOperation_full();

    void shiftFile();

    void save_buffer(ofstream &);

    void read_buffer(ifstream &);

    string getRelationTime()
    {
        return m_pRelations[m_nTransIndex].Time().toStdString();
    }

    string getRelationTime_1()
    {
        return m_pRelations[m_nTransIndex_1].Time().toStdString();
    }

    string getRelationTime_2()
    {
        return m_pRelations[m_nTransIndex_2].Time().toStdString();
    }


private:

    CRelation           m_cRelation;

    CData               *m_pData;

    CBar                *m_pBars;

    CLabel              *m_pLabels;

    Line                *m_pLines;

    CPolygon            *m_pPolygon;

    SData               *m_pSData;

    WriteGraph          *m_pGraph;

    Hierarchy           *m_pHierarchy;

    CMap                *m_pMap;

    Cluster             *m_pGroups;

    //Group *m_pGroups;

    CVert               *m_pBarVert;

    CVert               *m_pPolyVert;

    CVert               *m_pLineVert;

    CVert               *m_pUBoundVert;

    CVert               *m_pLBoundVert;

    CVColor             *m_pBarVertColor;

    CVColor             *m_pPlgVertColor;

    CVColor             *m_pLineVertColor;

    CVColor             *m_pUBoundVertColor;

    CVColor             *m_pLBoundVertColor;

    GLuint              m_nVBO[BUFFER_SIZE];

    QColor              m_pColor;

    QVector<float>      m_vDiff;

    QVector<qreal>      m_vBackBone;

    QVector<CRelation>  m_pRelations;

    QVector<int>        m_vResult;

    QRect               m_rPanel;

    QPointF             m_pPos;

    QPointF             m_pMovePos;

    QPointF             m_pLDbClickPos;

    QPointF             m_pRDbClickPos;

    QString             m_sText;

    QString             m_sInfile1;

    QString             m_sInfile2;

    QPointF             m_pLastPoint;

    QPointF             m_pReleasePoint;

    qreal               m_qWidthPad;

    qreal               m_qHeightPad;

    qreal               m_qSpan;

    string              m_sTime;

    bool                m_bClick;
    bool                m_bCardioGraph;
    bool                m_bPolyGraph;
    bool                m_bLineGraph;
    bool                m_bXZoom;
    bool                m_bYZoom;
    bool                m_bFullZoom;
    bool                m_bUpdateBuffer;
    bool                m_bMouseClick;
    bool                m_bUserSelect;
    bool                m_bSubGraph;
    bool                m_bSubSet;
    bool                m_bKSet;
    bool                m_bXSet;
    bool                m_bYSet;
    bool                m_bZSet;
    bool                m_bSSet;
    bool                m_bfullSub;


    float               m_fWidth;
    float               m_fHeight;
    float               m_fPad;
    float               m_fFixedSize;
    float               m_fAdjSize;
    float               m_fHalfPanel;
    float               m_fThickness;
    float               m_fGlbMax;

    int                 m_nTime_1;
    int                 m_nTime_2;
    int                 m_nTransIndex_1;
    int                 m_nTransIndex_2;
    int                 m_nCol;
    int                 m_nRow;
    int                 m_nShowedCol;
    int                 m_nMax;
    int                 m_nInterval;
    int                 m_nCluster;
    int                 m_nSubCluster;
    int                 m_nTransTime;
    int                 m_nNorTime;
    int                 m_nTransIndex;
    int                 m_nENum;
    int                 m_nPTNum;


    int                 m_nSender;
    int                 m_nRecver;
    int                 m_nC;


    int                 m_nACol;
    int                 m_nARow;
    int                 m_nABar;
    int                 m_nAPlg;
    int                 m_nASize;
    int                 m_nAPVNum;

};

#endif // GLWIDGET_H
