#ifndef FORMCLUSTER_H
#define FORMCLUSTER_H


#include <map>
#include <vector>
#include <set>
#include <cassert>
#include <fstream>

#define TREENODE_PASS       0x00
#define TREENODE_STOP       0x01
#define TREENODE_DUMM       0x02

using namespace std;

class CPair;

class CDpair;

typedef multimap< float, CDpair*, less<float> > d_sorted_t;
typedef multimap< float, CPair*, greater<float> > sorted_t;
typedef map<int, vector<int> > cluster_t;

class CClusterTree;
typedef vector<CClusterTree*> trees_t;


class CPair
{
public:
    int getA() {return m_nA;}
    int getB() {return m_nB;}
    sorted_t::iterator& Iter() {return m_Iter;}
    void setA(int v) {m_nA = v;}
    void setB(int v) {m_nB = v;}
    void Iter(sorted_t::iterator iter) {m_Iter = iter;}

private:
    int m_nA;
    int m_nB;
    sorted_t::iterator m_Iter;
};

class CDpair
{
public:
    int getA() {return m_nA;}
    int getB() {return m_nB;}
    d_sorted_t::iterator& Iter() {return m_Iter;}
    void setA(int v) {m_nA = v;}
    void setB(int v) {m_nB = v;}
    void Iter(d_sorted_t::iterator iter) {m_Iter = iter;}

private:
    int m_nA;
    int m_nB;
    d_sorted_t::iterator m_Iter;
};

class CMatrix
{
public:
    void setSize(int x, int y) {m_nSizeX = x; m_nSizeY = y; m_nTotal = x * y;}
    void Calloc() {
        m_pMatrix = new CPair* [m_nTotal];
        for (int i = 0; i < m_nTotal; i++) {
            m_pMatrix[i] = NULL;
        }
    }
    void flush() {
        for (int i = 0; i < m_nTotal; i++) {
            delete[] m_pMatrix[i];
        }
        delete[] m_pMatrix;
        m_pMatrix = NULL;
    }

    int getX() {return m_nSizeX;}
    int getY() {return m_nSizeY;}

    CPair *&operator()(int x, int y) {
        assert(x < m_nSizeX && y < m_nSizeY);
        return m_pMatrix[x + y * m_nSizeX];
    }

private:
    int m_nSizeX;
    int m_nSizeY;
    int m_nTotal;
    CPair** m_pMatrix;
};


class CDmatrix
{
public:
    void setSize(int x, int y) {m_nSizeX = x; m_nSizeY = y; m_nTotal = x * y;}
    void Calloc() {
        m_pMatrix = new CDpair* [m_nTotal];
        for (int i = 0; i < m_nTotal; i++) {
            m_pMatrix[i] = NULL;
        }
    }

    void setPair(string id, CDpair *pair) {
        m_mMatrix[id] = pair;
    }

    void erasePair(string id) {
        m_mMatrix.erase(id);
    }

    CDpair *&getPair(string id) {
        return m_mMatrix[id];
    }

    int getX() {return m_nSizeX;}
    int getY() {return m_nSizeY;}

private:
    int m_nSizeX;
    int m_nSizeY;
    int m_nTotal;
    map<string, CDpair*> m_mMatrix;
    CDpair m_cPair;
    CDpair** m_pMatrix;
};

class CClusterTree
{
public:
    CClusterTree() {
        m_nID = -1;
        m_nLevel = -1;
        m_nFlag = 0;
        m_pChildren[0] = m_pChildren[1] = NULL;
        m_pParent = NULL;
        //m_nFlag = TREENODE_PASS;
        //        m_pLine = NULL;
    }

    CClusterTree * &operator[](int id) {
        assert(id < 2);
        return m_pChildren[id];
    }

    void Child_L(CClusterTree *p) {
        m_pChildren[0] = p;
    }

    void Child_R(CClusterTree *p) {
        m_pChildren[1] = p;
    }

    void Parent(CClusterTree *p) {
        m_pParent = p;
    }

    CClusterTree * &Child_L() {
        return m_pChildren[0];
    }

    CClusterTree * &Child_R() {
        return m_pChildren[1];
    }

    CClusterTree * &OtherChild(CClusterTree *child) {
        if (child == m_pChildren[0]) {
            return m_pChildren[1];
        } else if (child == m_pChildren[1]) {
            return m_pChildren[0];
        } else {
            cerr << "can not find this child" << endl;
            assert(0);
        }
    }

    CClusterTree * &Sibling() {
        if (m_pParent != NULL) {
            return m_pParent->OtherChild(this);
        } else{
            cerr << "No sibling for root" << endl;
            assert(0);
        }
    }

    void ReplaceChild(CClusterTree *oldchild, CClusterTree *newchild) {
        if (oldchild == m_pChildren[0]) {
            m_pChildren[0] = newchild;
        } else if (oldchild == m_pChildren[1]) {
            m_pChildren[1] = newchild;
        } else {
            cerr << "can not find this child" << endl;
            assert(0);
        }
    }

    CClusterTree * &Parent() {
        return m_pParent;
    }

    void ID(int id) {
        m_nID = id;
    }

    int ID() {
        return m_nID;
    }

    void Level(int l) {
        m_nLevel = l;
    }

    int Level() {
        return m_nLevel;
    }

    void Index(int index) {
        m_nIndex = index;
    }

    int Index() {
        return m_nIndex;
    }

    int LeafNum() {
        return m_sLeafIDs.size();
    }

    void setTime(double time) {
        m_dTime = time;
    }

    double getTime() {
        return m_dTime;
    }

    void setA(float a) {
        m_fA = a; 
    }

    float getA() {
        return m_fA;
    }

    void setMod(int id, float mod) {
        m_mModularity[id] = mod;
    }

    float getMod(int id) {
        return m_mModularity[id];
    }

    map<int, float> getMods() {
        return m_mModularity;
    }

    set<int> &LeafIDs() {
        return m_sLeafIDs;
    }

    void Flag(unsigned char f) {
        m_nFlag = f;
    }

    unsigned char Flag() {
        return m_nFlag;
    }

    bool IsLeaf() {
        if (LeafNum() == 1) {
            return true;
        }
        return false;
    }

    bool IsRoot() {
        if (m_pParent == NULL) {
            return true;
        }
        return false;
    }

private:
    int                     m_nLevel;
    int                     m_nID;
    int                     m_nIndex;
    unsigned char           m_nFlag;
    float                   m_fDiffSibling;
    float                   m_fA;
    double                  m_dTime;
    CClusterTree            *m_pChildren[2];
    CClusterTree            *m_pParent;
    set<int>                m_sLeafIDs;
    map<int, float>         m_mModularity;
};



#endif // FORMCLUSTER_H
