#ifndef EBUNDLE_H
#define EBUNDLE_H

#include <QWidget>
#include <QPainter>
#include <QMap>
#include <QDebug>
#include <QVector>
#include <QPointF>
#include <QFont>
#include <QPainterPath>
#include <QString>
#include <QRect>

#ifndef PARTICAL
#define PARTICLE 10
#endif

class EBundle : public QWidget
{
    Q_OBJECT

public:

    EBundle();

    QPainterPath ctrl_Path(QPointF, QPointF,
                           QPointF, QPointF,
                           QPointF, QPointF,
                           float);

    QList<QPolygonF> toPolygon(QList<QPainterPath> path);

    void Cmp(QPointF, qreal, qreal);

    QList<float> setWidth();

    void setPath(QPainterPath path1, QPainterPath path2)
    {
        m_ppPath1 = path1;
        m_ppPath2 = path2;
    }

    QPainterPath& getPath_1()
    {
        return m_ppPath1;
    }

    QPainterPath& getPath_2()
    {
        return m_ppPath2;
    }


    QPolygonF getPolygon()
    {
        return m_pPolygon;
    }

    int getNum()
    {
        return m_nTriNum;
    }

protected:

private:

    QPainterPath            m_ppPath1;

    QPainterPath            m_ppPath2;

    QList<QPainterPath>     paths;

    QList<float>            m_nWidth;

    QPolygonF               m_pPolygon;

    float                   m_fMax;

    float                   m_fMin;

    float                   length;

    int                     m_nTriNum;

};


#endif // EBUNDLE_H
