#include "ebundle.h"

EBundle::EBundle()
{
    m_nTriNum = 0;
}


QPainterPath EBundle::ctrl_Path(QPointF a, QPointF b, QPointF d, QPointF m,
                                QPointF X, QPointF Y, float ctrl)
{
    QPointF start(X);
    QPointF end(Y);
    QPointF mid(m);

    QPointF ctrl_a(a);
    QPointF ctrl_b(b);

    QPointF ctrl_c;
    QPointF ctrl_d(d);

    float t = ctrl;

    QPainterPath path;

    path.moveTo(start);
    path.cubicTo(ctrl_a, ctrl_b, mid);

    path.moveTo(mid);
    ctrl_c = (mid - (1.0f-t) * ctrl_b) / t;
    path.cubicTo(ctrl_c, ctrl_d, end);

    return path;
}

QList<QPolygonF> EBundle::toPolygon(QList<QPainterPath> paths)
{
    QPointF P_crt(0.0, 0.0);
    QPointF qp_MAXpoint, qp_MINpoint;
    QList<QPointF> l_MAXpoints, l_MINpoints;
    for (int j = 0; j <= PARTICLE; j++) {
        P_crt = paths.value(0).pointAtPercent((j * 1.0f) / PARTICLE);

        qp_MINpoint.setX(P_crt.x());
        qp_MINpoint.setY(P_crt.y());

        P_crt = paths.value(1).pointAtPercent((j * 1.0f) / PARTICLE);

        qp_MAXpoint.setX(P_crt.x());
        qp_MAXpoint.setY(P_crt.y());

        l_MAXpoints.push_back(qp_MAXpoint);
        l_MINpoints.push_back(qp_MINpoint);

    }

//    for (int j = 0; j <= 100; j++)
//    {
//        m_fMax = m_fMin = paths.value(0).pointAtPercent((j * 1.0f)/100.0f).y();
//        for(int i = 0; i < paths.size(); i++)
//        {
//            length = paths.value(i).length();
//            P_crt = paths.value(i).pointAtPercent((j * 1.0f)/100.0f);
//            this->Cmp(P_crt, m_fMax, m_fMin);
//        }
//        qp_MAXpoint.setX(P_crt.x());
//        qp_MAXpoint.setY(m_fMax);

//        qp_MINpoint.setX(P_crt.x());
//        qp_MINpoint.setY(m_fMin);

//        l_MAXpoints.push_back(qp_MAXpoint);
//        l_MINpoints.push_back(qp_MINpoint);
//    }

    QPolygonF           qp_Polygon;
    QList<QPolygonF>    l_Triags;

    for (int i = 0; i < l_MINpoints.size() - 1; i++) {
        QPolygonF    t_Triag1;
        QPolygonF    t_Triag2;
        t_Triag1 << l_MINpoints[i] << l_MINpoints[i+1] << l_MAXpoints[i+1];
        t_Triag2 << l_MAXpoints[i] << l_MINpoints[i]   << l_MAXpoints[i+1];
        l_Triags.push_back(t_Triag1);
        m_nTriNum++;
        l_Triags.push_back(t_Triag2);
        m_nTriNum++;
    }

    //qDebug() << m_lRects;

    while (!l_MAXpoints.isEmpty())
    {
        qp_Polygon << l_MAXpoints.front();
        l_MAXpoints.pop_front();
    }

    while (!l_MINpoints.isEmpty())
    {
        qp_Polygon << l_MINpoints.back();
        l_MINpoints.pop_back();
    }

    m_pPolygon = qp_Polygon;

    return l_Triags;

}

void EBundle::Cmp(QPointF p, qreal max, qreal min)
{
    m_fMax = (p.y() > max) ? max : p.y();
    m_fMin = (p.y() > min) ? p.y() : min;
}

QList<float> EBundle::setWidth()
{
    float f_tmp = 0.0;
    float f_interval = 0.005;
    float f_Path1, f_Path2, f_d;
    m_nWidth.clear();
    while (f_tmp <= 1.0)
    {
        f_Path1 = m_ppPath1.pointAtPercent(f_tmp).y();
        f_Path2 = m_ppPath2.pointAtPercent(f_tmp).y();
        f_tmp = f_tmp + f_interval;
        f_d = f_Path1 - f_Path2;
        m_nWidth.push_back(f_d);

    }
    return m_nWidth;
}

