#include "cmap.h"

CMap::CMap()
{

}

void CMap::Map(int count)
{
    system("exec rm -r ../DATA/FINAL/FINAL");
    system("exec rm -r ../DATA/FINAL/TOTAL");
    map<int, int> *m_idLabel = new map<int, int>[count]; 
    vector<string> v_filename;
    send_recv_t t_Mpi; 
    vector<send_recv_t> v_Mpitotal;// record the final MPI_TOTAL result  

    string s_MpiFile = "../DATA/MPI/MPI_TOTAL";
    ifstream infile0(s_MpiFile.c_str());
    if (infile0.is_open()) {
        string s_Sender_n; 
        string s_Sender;
        string s_Recver_n;
        string s_Recver;
        string s_Size_n;
        string s_Size;
        string s_Hash_n;
        double d_Hash; 
        while (!infile0.eof()) {
            infile0 >> s_Sender_n >> s_Sender >> s_Recver_n >> s_Recver 
                    >> s_Size_n >> s_Size >> s_Hash_n >> d_Hash;
            if (infile0.fail()) {
                break;
            }
            t_Mpi.sender = atoi(s_Sender.c_str());
            t_Mpi.recver = atoi(s_Recver.c_str());
            t_Mpi.size   = atoi(s_Size.c_str());
            t_Mpi.hash   = d_Hash;
            v_Mpitotal.push_back(t_Mpi);
            m_vInterval.push_back(d_Hash);
        } 
    } else {
        cout << "Cannot open the MPI file!\n" << endl;
        exit(1);
    }
    infile0.close();

    std::sort(m_vInterval.begin(), m_vInterval.end());
    m_vInterval.erase(std::unique(m_vInterval.begin(), 
                m_vInterval.end()), m_vInterval.end()); 

    for (int i = 0; i < count; i++) {
        stringstream ss_out;
        ss_out << i;
        string s_num = "";
        string strGML = "../DATA/LABEL/LABEL_";
        if (i <= 9) {
            s_num = "0";
        }
        strGML = strGML + s_num + ss_out.str();
        v_filename.push_back(strGML);

        /**
         *Determine whether using the first hierarchy result
         */
        string s_filename = v_filename[LABEL];
//        string s_filename = v_filename[0];

        ifstream infile1(s_filename.c_str());
        if (infile1.is_open()) {
            string s_id_n, s_label_n;
            int n_label;
            int n_id;
            int n_minus = 0;
            while (!infile1.eof()) {
                infile1 >> s_id_n >> n_id >> s_label_n >> n_label;
                if (infile1.fail()) {
                    break;
                }
                m_idLabel[i][n_id + n_minus] = n_label;
            }
        } else {
            cout << "Cannot open the LABEL file!\n" << endl;
            exit(1);
        }
        infile1.close();
    }

    //map<int, int>::iterator mitr;
    //for (int i = 0; i < count; i++) {
    //    cout << "**********************************" << endl;
    //    for (mitr = m_idLabel[i].begin(); mitr != m_idLabel[i].end(); mitr++)
    //    {
    //        cout << mitr->first
    //             << " corresponds to "
    //             << mitr->second
    //             << endl;
    //    }
    //    cout << "**********************************" << endl;
    //}

    double d_tmp = v_Mpitotal[0].hash;
    double d_comp;
    int j = 0;
    int num = 0;
    int last = 0;
    //int sender, recver;
    int sender, recver;
    send_recv_t t_out;
    vector<send_recv_t> v_outPut;
    map<string, u_int64_t> m_match;
    map<string, u_int64_t>::iterator it;

    for (size_t i = 0; i < v_Mpitotal.size(); i++) {
        sender = m_idLabel[j][v_Mpitotal[i].sender];
        recver = m_idLabel[j][v_Mpitotal[i].recver];
        string s_tmp = to_string(sender) + "." + 
                       to_string(recver);
        it = m_match.find(s_tmp);
        if (it != m_match.end()) {
            int n_tmp = v_Mpitotal[i].size;
            m_match[s_tmp] += n_tmp;
        }
        else {
            int n_tmp = v_Mpitotal[i].size;
            m_match[s_tmp] = n_tmp;
        }

        if (i == (size_t)(v_Mpitotal.size() - 1)) {
            num = i;
            last = -1;
        } else {
            num = i + 1;
        }
        d_comp = v_Mpitotal[num].hash;
        if (d_comp != d_tmp || last == -1) {
            d_tmp = v_Mpitotal[num].hash;
            j++;
            for (it = m_match.begin(); it != m_match.end(); it++) {
                string s_tmp = it->first;
                int n_pos = it->first.find(".");
                u_int64_t n_size = m_match[s_tmp];
                double d_time = v_Mpitotal[i].hash;
                string s_sender = it->first.substr(0, n_pos);
                string s_recver = it->first.substr(n_pos + 1, it->first.size());
                t_out.sender = atoi(s_sender.c_str());
                t_out.recver = atoi(s_recver.c_str());
                t_out.size   = n_size;
                t_out.hash = d_time;
                v_outPut.push_back(t_out);
            }
            m_match.clear();
        }
    }

    string str_0 = "../DATA/FINAL/TOTAL";
    char * outChar_0 = const_cast<char *> (str_0.c_str());
    ofstream outfile_0(outChar_0); 
    for (size_t i = 0;  i < v_Mpitotal.size(); i++) {
        outfile_0 << v_Mpitotal[i].sender << " " << v_Mpitotal[i].recver << " " 
                  << v_Mpitotal[i].size << " " 
                  << setprecision(12) << v_Mpitotal[i].hash << endl; 
    }
    
    //string s_sender, s_recver;
    string index;
    string str_1 = "../DATA/FINAL/FINAL";
    char * outChar_1 = const_cast<char *> (str_1.c_str());
    ofstream outfile_1(outChar_1); 
    for (size_t i = 0;  i < v_outPut.size(); i++) {
        if (v_outPut[i].hash < 10) {
            index = "000" + to_string(v_outPut[i].hash);
        } else if (v_outPut[i].hash < 100) {
            index = "00" + to_string(v_outPut[i].hash);
        } else if (v_outPut[i].hash < 1000) {
            index = "0" + to_string(v_outPut[i].hash);
        } else {
            index = to_string(v_outPut[i].hash);
        }
        /*
        if (v_outPut[i].sender < 10) {
            s_sender = "000" + to_string(v_outPut[i].sender);
        } else if (v_outPut[i].sender < 100) {
            s_sender = "00" + to_string(v_outPut[i].sender);
        } else if (v_outPut[i].sender < 1000) {
            s_sender = "0" + to_string(v_outPut[i].sender);
        } else {
            s_sender = to_string(v_outPut[i].sender);
        }

        if (v_outPut[i].recver < 10) {
            s_recver = "000" + to_string(v_outPut[i].recver);
        } else if (v_outPut[i].recver < 100) {
            s_recver = "00" + to_string(v_outPut[i].recver);
        } else if (v_outPut[i].recver < 1000) {
            s_recver = "0" + to_string(v_outPut[i].recver);
        } else {
            s_recver = to_string(v_outPut[i].recver);
        }
        */
        outfile_1 << v_outPut[i].sender << " "
                  << v_outPut[i].recver << " "
                  << v_outPut[i].size << " "
                  << index << endl;
                  //<< s_sender << " "
                  //<< s_recver << " "
                  //<< setprecision(12) << v_outPut[i].hash << endl;
    }
}

void CMap::Sub(string s_filename)
{
    system("exec rm -r ../DATA/SUB/MPI_SUB");
    map<int, int> m_idLabel;
    send_recv_t t_Mpi;
    vector<send_recv_t> v_Mpitotal;// record the final MPI_TOTAL result

    string s_MpiFile = "../DATA/SUB/SUB_TOTAL";
    ifstream infile0(s_MpiFile.c_str());
    if (infile0.is_open()) {
        string s_Sender;
        string s_Recver;
        string s_Size;
        double d_Hash;
        while (!infile0.eof()) {
            infile0 >> s_Sender >> s_Recver >> s_Size >> d_Hash;
            if (infile0.fail()) {
                break;
            }
            t_Mpi.sender = atoi(s_Sender.c_str());
            t_Mpi.recver = atoi(s_Recver.c_str());
            t_Mpi.size   = atoi(s_Size.c_str());
            t_Mpi.hash   = d_Hash;
            v_Mpitotal.push_back(t_Mpi);
            m_vInterval.push_back(d_Hash);
        }
    } else {
        cout << "Cannot open the MPI file!\n" << endl;
        exit(1);
    }
    infile0.close();

    std::sort(m_vInterval.begin(), m_vInterval.end());
    m_vInterval.erase(std::unique(m_vInterval.begin(),
                m_vInterval.end()), m_vInterval.end());

    ifstream infile1(s_filename.c_str());
    if (infile1.is_open()) {
        string s_id_n, s_label_n;
        int n_label;
        int n_id;
        int n_minus = -1;
        while (!infile1.eof()) {
            infile1 >> s_id_n >> n_id >> s_label_n >> n_label;
            if (infile1.fail()) {
                break;
            }
            m_idLabel[n_id + n_minus] = n_label;
        }
    } else {
        cout << "Cannot open the LABEL file!\n" << endl;
        exit(1);
    }
    infile1.close();

    map<int, int>::iterator mitr;
//    for (int i = 0; i < count; i++) {
//        cout << "**********************************" << endl;
//        for (mitr = m_idLabel[i].begin(); mitr != m_idLabel[i].end(); mitr++)
//        {
//            cout << mitr->first
//                 << " corresponds to "
//                 << mitr->second
//                 << endl;
//        }
//        cout << "**********************************" << endl;
//    }

    double d_tmp = v_Mpitotal[0].hash;
    double d_comp;
    int j = 0;
    int num = 0;
    int last = 0;
    int sender, recver;
    send_recv_t t_out;
    vector<send_recv_t> v_outPut;
    map<string, int> m_match;
    map<string, int>::iterator it;

    for (size_t i = 0; i < v_Mpitotal.size(); i++) {
        sender = m_idLabel[v_Mpitotal[i].sender];
        recver = m_idLabel[v_Mpitotal[i].recver];
        string s_tmp = to_string(sender) + "." +
                       to_string(recver);
        it = m_match.find(s_tmp);
        if (it != m_match.end()) {
//            if (m_match[s_tmp] >= 2140000000) {
//                m_match[s_tmp] = 2140000000;
//            } else {
            int n_tmp = v_Mpitotal[i].size;
            m_match[s_tmp] += n_tmp;
//            }
        } else {
            int n_tmp = v_Mpitotal[i].size;
            m_match[s_tmp] = n_tmp;
        }

        if (i == v_Mpitotal.size() - 1) {
            num = i;
            last = -1;
        } else {
            num = i + 1;
        }
        d_comp = v_Mpitotal[num].hash;
        if (d_comp != d_tmp || last == -1) {
            d_tmp = v_Mpitotal[num].hash;
            j++;
            for (it = m_match.begin(); it != m_match.end(); it++) {
                string s_tmp = it->first;
                int n_pos = it->first.find(".");
                int n_size = m_match[s_tmp];
                double d_time = v_Mpitotal[i].hash;
                string s_sender = it->first.substr(0, n_pos);
                string s_recver = it->first.substr(n_pos + 1, it->first.size());
                t_out.sender = atoi(s_sender.c_str());
                t_out.recver = atoi(s_recver.c_str());
                t_out.size   = n_size;
                t_out.hash = d_time;
                v_outPut.push_back(t_out);
            }
            m_match.clear();
        }
    }

    string index;
    string str_1 = "../DATA/SUB/MPI_SUB";
    char * outChar_1 = const_cast<char *> (str_1.c_str());
    ofstream outfile_1(outChar_1);
    for (size_t i = 0;  i < v_outPut.size(); i++) {
        if (v_outPut[i].hash < 10) {
            index = "000" + to_string(v_outPut[i].hash);
        } else if (v_outPut[i].hash < 100) {
            index = "00" + to_string(v_outPut[i].hash);
        } else if (v_outPut[i].hash < 1000) {
            index = "0" + to_string(v_outPut[i].hash);
        } else {
            index = to_string(v_outPut[i].hash);
        }
        outfile_1 << v_outPut[i].sender << " " << v_outPut[i].recver << " "
                  << v_outPut[i].size << " "
                  << index << endl;
                  //<< setprecision(12) << v_outPut[i].hash << endl;
    }
}

void CMap::Search(string time, int sender, int recver, int id)
{
    send_recv_t t_Mpi;
    vector<send_recv_t> v_Mpitotal;// record the final MPI_TOTAL result

    string s_MpiFile = "../DATA/MPI/MPI_TOTAL";
    ifstream infile0(s_MpiFile.c_str());
    if (infile0.is_open()) {
        //string index;
        string s_Sender_n;
        string s_Sender;
        string s_Recver_n;
        string s_Recver;
        string s_Size_n;
        string s_Size;
        string s_Hash_n;
        string s_Hash;
        double d_Hash;
        while (!infile0.eof()) {
            infile0 >> s_Sender_n >> s_Sender >> s_Recver_n >> s_Recver
                    >> s_Size_n >> s_Size >> s_Hash_n >> d_Hash;
            if (infile0.fail()) {
                break;
            }
            if (d_Hash < 10) {
                s_Hash = "000" + to_string(d_Hash);
            } else if (d_Hash < 100) {
                s_Hash = "00" + to_string(d_Hash);
            } else if (d_Hash < 1000) {
                s_Hash = "0" + to_string(d_Hash);
            } else {
                s_Hash = to_string(d_Hash);
            }

            if (time == s_Hash) {
                t_Mpi.sender = atoi(s_Sender.c_str());
                t_Mpi.recver = atoi(s_Recver.c_str());
                t_Mpi.size   = atoi(s_Size.c_str());
                t_Mpi.hash   = d_Hash;
                v_Mpitotal.push_back(t_Mpi);
            }
        }
    } else {
        cout << "Cannot open the MPI file!\n" << endl;
        exit(1);
    }
    infile0.close();

    stringstream ss_out;
    ss_out << id;
    string s_num = "";
    string strLABEL = "../DATA/LABEL/LABEL_";
    if (id <= 9) {
        s_num = "0";
    }
    strLABEL = strLABEL + s_num + ss_out.str();

    set<int>      s_Ids, r_Ids;
    map<int, int> m_idLabel;
    ifstream inlabel(strLABEL.c_str());
    if (inlabel.is_open()) {
        string s_id_n, s_label_n;
        int n_label;
        int n_id;
        int n_minus = -1;
        while (!inlabel.eof()) {
            inlabel >> s_id_n >> n_id >> s_label_n >> n_label;
            if (inlabel.fail()) {
                break;
            }
            if (n_label == sender) {
                s_Ids.insert(n_id + n_minus);
            }
            if (n_label == recver) {
                r_Ids.insert(n_id + n_minus);
            }
        }
    }

    vector<send_recv_t> v_MpiOutput;
    for (size_t i = 0; i < v_Mpitotal.size(); i++) {
        if (setContain(s_Ids, v_Mpitotal[i].sender)
                && setContain(r_Ids, v_Mpitotal[i].recver)) {
            v_MpiOutput.push_back(v_Mpitotal[i]);
        }
    }

    string str_1 = "../DATA/SUB/SUB_TOTAL";
    char * outChar_1 = const_cast<char *> (str_1.c_str());
    ofstream outfile_1(outChar_1);
    for (size_t i = 0;  i < v_MpiOutput.size(); i++) {
        outfile_1 << v_MpiOutput[i].sender << " "
                  << v_MpiOutput[i].recver << " "
                  << v_MpiOutput[i].size   << " "
                  << setprecision(12)      << v_MpiOutput[i].hash
                  << endl;
    }
    outfile_1.close();
}

void CMap::Search(string time)
{
    send_recv_t t_Mpi;
    vector<send_recv_t> v_Mpitotal;// record the final MPI_TOTAL result

    string s_MpiFile = "../DATA/MPI/MPI_TOTAL";
    ifstream infile0(s_MpiFile.c_str());
    if (infile0.is_open()) {
        //string index;
        string s_Sender_n;
        string s_Sender;
        string s_Recver_n;
        string s_Recver;
        string s_Size_n;
        string s_Size;
        string s_Hash_n;
        string s_Hash;
        double d_Hash;
        while (!infile0.eof()) {
            infile0 >> s_Sender_n >> s_Sender >> s_Recver_n >> s_Recver
                    >> s_Size_n >> s_Size >> s_Hash_n >> d_Hash;
            if (infile0.fail()) {
                break;
            }
            if (d_Hash < 10) {
                s_Hash = "000" + to_string(d_Hash);
            } else if (d_Hash < 100) {
                s_Hash = "00" + to_string(d_Hash);
            } else if (d_Hash < 1000) {
                s_Hash = "0" + to_string(d_Hash);
            } else {
                s_Hash = to_string(d_Hash);
            }

            if (time == s_Hash) {
                t_Mpi.sender = atoi(s_Sender.c_str());
                t_Mpi.recver = atoi(s_Recver.c_str());
                t_Mpi.size   = atoi(s_Size.c_str());
                t_Mpi.hash   = d_Hash;
                v_Mpitotal.push_back(t_Mpi);
            }
        }
    } else {
        cout << "Cannot open the MPI file!\n" << endl;
        exit(1);
    }
    infile0.close();

    string str_1 = "../DATA/SUB/SUB_TOTAL";
    char * outChar_1 = const_cast<char *> (str_1.c_str());
    ofstream outfile_1(outChar_1);
    for (size_t i = 0;  i < v_Mpitotal.size(); i++) {
        outfile_1 << v_Mpitotal[i].sender << " " << v_Mpitotal[i].recver << " "
                  << v_Mpitotal[i].size << " "
                  << setprecision(12) << v_Mpitotal[i].hash << endl;
    }
}
