#ifndef CDATA_H
#define CDATA_H

#include <iostream>
#include <sstream>
#include <fstream>
#include <math.h>
#include <stdlib.h>
#include <stdint.h>
#include <cstring>
#include <iomanip>
#include <algorithm>
#include <deque>
#include <QtGui>
#include <QVector>
#include <QFile>
#include <QString>
#include <QTextStream>
#include <QDebug>
#include <QMap>
#include <QColor>

using namespace std;

class CRelation
{
public:
    CRelation();

    CRelation(QString s, QString r, u_int64_t f, QString t) {
        Sender(s);
        Receiver(r);
        Amount(f);
        Time(t);
    }

    void Sender(QString n) {
        m_sSender = n;
    }

    void Receiver(QString n) {
        m_sReceiver = n;
    }


    void Amount(u_int64_t n) {
        m_nAmount = n;
    }

    void Time(QString n) {
        m_sTime = n;
    }


    void SenderIndex(int n) {
        m_nSenderIndex = n;
    }

    void ReceiverIndex(int n) {
        m_nReceiverIndex = n;
    }

    void TimeIndex(int n) {
        m_nTimeIndex = n;
    }


    QString Sender() {
        return m_sSender;
    }

    QString Receiver() {
        return m_sReceiver;
    }

    u_int64_t Amount() {
        return m_nAmount;
    }

    QString Time() {
        return m_sTime;
    }


    int SenderIndex() {
        return m_nSenderIndex;
    }

    int ReceiverIndex() {
        return m_nReceiverIndex;
    }

    int TimeIndex() {
        return m_nTimeIndex;
    }

private:
    QString     m_sSender;
    QString     m_sReceiver;
    QString     m_sTime;
    u_int64_t   m_nAmount;
    int         m_nSenderIndex;
    int         m_nReceiverIndex;
    int         m_nTimeIndex;
};

class CData
{
public:
    CData();

    CData(QString filename);

    void getFileName(QString filename);

    void ReadRelations(QString filename);

    QVector<QString>& GetEntities() {
        return m_vSEntities;
    }

    QVector<int>& GetIntEntities() {
        return m_vEntities;
    }

    QVector<QString>& GetTimes() {
        return m_vTimes;
    }

    QVector<CRelation>& GetRelations() {
        return m_vRelations;
    }

    QString GetEntity(int n) {
        return m_vAllEntities[n];
    }

    QString GetTime(int n) {
        return m_vTimes[n];
    }

    int GetTotalEntitiesNum() {
        return m_nTotalEntities;
    }

    int GetTotalTimeNum() {
        return m_nTotalTime;
    }

    u_int64_t SendAmount(int entity, int time) {
        return m_pSendAmount[entity + time * m_nTotalEntities];
    }

    u_int64_t RecvAmount(int entity, int time) {
        return m_pRecvAmount[entity + time * m_nTotalEntities];
    }

    /**
     * the maximum of sending or receiving amount
     */
    u_int64_t MaxAmount() {
        return m_nMaxAmount;
    }

    /**
     * the maximum of the relations
     */
    u_int64_t GlbMaxAmount() {
        return m_nGlbMaxAmount;
    }

    u_int64_t SMaxAmount() {
        return m_nSMaxAmount;
    }

    /**
     *Color
     */
    QColor EntityColor(int n) {
        return m_vColor[n];
    }

    void EntityColor(QVector<QColor> colormap);

    /**
     *Position
     */
    void EntityPos(QVector<QString>);

    /**
     *Row Max
     */
    u_int64_t getColMax(int n)
    {
        return m_pColMax[n];
    }

    /**
     *Accumulate value
     */
    u_int64_t getAccValue(int n)
    {
        return m_pAccumulate[n];
    }

    /**
     *Clean the parameter
     */
    void clean();


private:

    QVector<QString>    m_vAllEntities;
    QVector<QString>    m_vSEntities;
    QVector<int>        m_vEntities;
    QVector<QString>    m_vTimes;
    QVector<QString>    m_vLabel;
    QVector<CRelation>  m_vRelations;
    QVector<QColor>     m_vColor;
    QMap<QString, int>  *m_entity_map;
    QMap<QString, int>  m_time_map;

    int                 m_nTotalEntities;
    int                 m_nTotalTime;
    int                 m_nColorNum;

    u_int64_t           *m_pSendAmount;
    u_int64_t           *m_pRecvAmount;
    u_int64_t           m_nGlbMaxAmount;
    u_int64_t           m_nMaxAmount;
    u_int64_t           m_nSMaxAmount;
    u_int64_t           *m_pColMax;
    u_int64_t           *m_pAccumulate;

    QColor              *m_pGroupColor;
};

#endif // CDATA_H
