#ifndef CBAR_H
#define CBAR_H

#include <QWidget>
#include <QColor>
#include <QFont>
#include <QtOpenGL>

class CVert
{
public:

    GLfloat x;
    GLfloat y;
};

class CVColor
{
public:

    GLfloat red;
    GLfloat green;
    GLfloat blue;
    GLfloat alphaF;
};


class CBar
{

public:

    CBar();

    void setAttribute(qreal posX, qreal posY, QColor color)
    {
        PosX(posX);
        PosY(posY);
        Color(color);
    }

    void Width(int n) {
        m_nWidth = n;
    }

    void Height(int n) {
        m_nHeight = n;
    }

    void Pad(int n){
        m_nPad = n;
    }

    void PosX(int n) {
        m_nPosX = n;
    }

    void PosY(int n) {
        m_nPosY = n;
    }

    void Polygon(QPolygonF polygon) {
        m_qPolygon = polygon;
    }

    QPolygonF Polygon() {
        return m_qPolygon;
    }

    void Color(QColor c) {
        m_qColor = c;
    }

    QColor Color() {
        return m_qColor;
    }

    void Opacity(float n) {
        m_qColor.setAlphaF(n);
    }

    void EntityIndex(int n) {
        m_nEntityIndex = n;
    }

    int EntityIndex() {
        return m_nEntityIndex;
    }

    void TimeIndex(int n) {
        m_nTimeIndex = n;
    }

    int TimeIndex() {
        return m_nTimeIndex;
    }


    void SendValue(float f) {
        m_fSendValue = f;
    }

    void RecvValue(float f) {
        m_fRecvValue = f;
    }

    float getSendValue() {
        return m_fSendValue;
    }

    float getRecvValue() {
        return m_fRecvValue;
    }

    void pushSend(int n) {
        m_vnSend.push_back(n);
    }

    void pushRecv(int n) {
        m_vnRecv.push_back(n);
    }

    QVector<int>& popSend() {
        return m_vnSend;
    }

    QVector<int>& popRecv() {
        return m_vnRecv;
    }

    bool getShow() {
        return m_bShow;
    }

    void setShow(bool show) {
        m_bShow = show;
    }

protected:
//    void paintEvent(QPaintEvent *event);
//    void drawBar(QPainter *qp);

private:
    int m_nWidth;
    int m_nHeight;
    int m_nPad;
    qreal m_nPosX;
    qreal m_nPosY;
    QColor m_qColor;
    QPolygonF m_qPolygon;
    QVector<int>     m_vnSend;
    QVector<int>     m_vnRecv;

    int     m_nEntityIndex;
    int     m_nTimeIndex;
    float   m_fSendValue;
    float   m_fRecvValue;
    bool    m_bShow;
};

#endif // CBAR_H
