#include <cstdio>
#include <cassert>
#include <cstdlib>
#include <fstream>
#include <iostream>
#include <stdlib.h>
#include <assert.h>


using namespace std;


int main(int argc, char **argv){
	if (argc != 2) {
        cout << "Usage: " << argv[0] << " count "  << endl;
        return 0;
    }
	int  count = atoi(argv[1]);
	ofstream outf;
	char outfile [50];
	sprintf (outfile, "round_test_%d.dat", count);
    outf.open(outfile);
    int num = 360/count;  
    float dis = 4.0f;
    float *d = NULL;
    d = new float[num];
    float *theta = NULL;
    theta = new float[num];
    float *phi = NULL;
    phi = new float[num];

    int rand_d  = rand() % 11;
	theta[0]    =  rand() % 180;
	phi[0]      =  rand() % 360;
	d[0] = 1.7f;

	
	for (int i = 1; i < num; ++i)
	{

		float rand_d_f = 0;
		int is_d_minus = 1;
		int theta_f = 0;
		int phi_f   = count;
		int is_theta_minus = 1;
		int is_phi_minus   = 1;
		d[i] = d[i-1] + rand_d_f * is_d_minus;
		if (d[i] >= 2.0f)
		{
			d[i]-= rand_d_f;
		}else if (d[i] < 1.1f)
		{
			d[i]+= rand_d_f;
		}

		theta[i] = theta[i-1] + theta_f * is_theta_minus;
		if (theta[i] >= 180)
		{
			theta[i]-= 180;
		}else if (theta[i] < 0)
		{
			theta[i]+= 180;
		}
		phi[i] = phi[i-1] + phi_f * is_phi_minus;
		if (phi[i] >= 360)
		{
			phi[i]-= 360;
		}else if (phi[i] < 0)
		{
			phi[i]+= 360;
		}

		printf("d = %f, theta = %f, phi = %f\n", d[i], theta[i], phi[i] );
	}
	outf.write(reinterpret_cast<const char *>(d), sizeof(float) * num);
	outf.write(reinterpret_cast<const char *>(theta), sizeof(float) * num);
	outf.write(reinterpret_cast<const char *>(phi), sizeof(float) * num);
	
    outf.close();

	return 0;
	

}