#include <cstdio>
#include <cassert>
#include <cstdlib>
#include <fstream>
#include <iostream>
#include <stdlib.h>
#include <assert.h>


using namespace std;


int main(int argc, char **argv){
	if (argc != 2) {
        cout << "Usage: " << argv[0] << " degree "  << endl;
        return 0;
    }
	int  degree = atoi(argv[1]);
	int count = 400;
	ofstream outf;
	char outfile [50];
	sprintf (outfile, "test_%d.dat", degree);
    outf.open(outfile);
     
    float dis = 2.0f;
    float *d = NULL;
    d = new float[count];
    float *theta = NULL;
    theta = new float[count];
    float *phi = NULL;
    phi = new float[count];

    int rand_d  = rand() % 11;
	theta[0]    =  rand() % 180;
	phi[0]      =  rand() % 360;
	d[0] = 1.7f;


	
	for (int i = 1; i < count; ++i)
	{
		float rand_d_f = (float) rand()/RAND_MAX/3.0f;
		int is_d_minus = rand()%100 >= 50 ? (-1) : 1;
		int theta_f = rand()%5 + degree;
		int phi_f   = rand()%5 + degree;
		int is_theta_minus = rand()%100 >= 50 ? (-1) : 1;
		int is_phi_minus   = rand()%100 >= 50 ? (-1) : 1;
		d[i] = d[i-1] + rand_d_f * is_d_minus;


		if (d[i] >= 2.0f)
		{
			d[i]-= rand_d_f;
		}else if (d[i] < 1.1f)
		{
			d[i]+= rand_d_f;
		}

		theta[i] = theta[i-1] + theta_f * is_theta_minus;
		if (theta[i] >= 180)
		{
			theta[i]-= 180;
		}else if (theta[i] < 0)
		{
			theta[i]+= 180;
		}
		phi[i] = phi[i-1] + phi_f * is_phi_minus;
		if (phi[i] >= 360)
		{
			phi[i]-= 360;
		}else if (phi[i] < 0)
		{
			phi[i]+= 360;
		}

		printf("d = %f, theta = %f, phi = %f\n", d[i], theta[i], phi[i] );
	}
	outf.write(reinterpret_cast<const char *>(d), sizeof(float) * count);
	outf.write(reinterpret_cast<const char *>(theta), sizeof(float) * count);
	outf.write(reinterpret_cast<const char *>(phi), sizeof(float) * count);
	
    outf.close();

	return 0;
	

}