//3-D case --whole direction
//sampling the whole sphere, do a priori algorithm within a small sphere range
//data independent
#include <cstdio>
#include <cassert>
#include <cstdlib>
#include <cstring>
#include <algorithm>
#include <cmath>
#include <time.h>
#include <fstream>
#include <iostream>
#include <sstream>
#include <string>
#include <cstring>
#include <stdlib.h>
#include <assert.h>
#include <vector>
#include <map>
#include <iomanip>


#define PI 3.14159265

using namespace std;

struct myclass {
  bool operator() (int i,int j) { return (i<j);}
} myobject;

int is_vis(float x, float y, float z, float dx, float dy, float dz, float angle){
	float AB = ((x - dx) * (-dx) + (y - dy) * (-dy) + (z - dz) * (-dz));
	float A = sqrt(dx * dx + dy * dy + dz * dz);
	float B = sqrt((x - dx) * (x - dx) + (y - dy) * (y - dy) + (z - dz) * (z - dz));

	assert(A != 0);
	assert(B != 0);

	float result = acos (AB/A/B) * 180.0 / PI;
	if (abs(result) <= angle){
		return 1;
	}else{
		return 0;
	}
}

vector<int> intersection(vector<vector<int> > datavec){
    vector<int> res(2048);
    vector<int>::iterator ip;
    for (vector<vector<int> >::iterator it = datavec.begin(); it != datavec.end(); ++it)
    {
        sort (it->begin(),it->end(), myobject);
        // for (vector<int>::iterator itor = it->begin(); itor!=it->end(); ++itor){
        //     std::cout << ' ' << *itor;
        // }
        // cout<< endl;
    }

    vector<vector<int> >::iterator begin_it = datavec.begin();
    vector<int> v = *begin_it;
    
    for (vector<vector<int> >::iterator it = datavec.begin()+1; it != datavec.end(); ++it)
    {
        ip = set_intersection (v.begin(),v.end(), it->begin(), it->end(), res.begin());
        res.resize(ip-res.begin()); 
        v = res;    
    }

    return v;
}
time_t t0,t1;
int main(int argc, char **argv)
{
	if (argc != 4) {
        cout << "Usage: " << argv[0] << "size_x, size_y, size_z"  << endl;
        return 0;
    }

	int  size_x = atoi(argv[1]);
	int  size_y = atoi(argv[2]);
	int  size_z = atoi(argv[3]);
	int max_size =  max(max(size_x, size_y), size_z);

	int norm_size_x = size_x / max_size;
	int norm_size_y = size_y / max_size;
	int norm_size_z = size_z / max_size;
	//# of points for each block
	int num_x = 50;
	int num_y = 50;
	int num_z = 50;
	int num_per_blk = num_x * num_y * num_z;
	// # of block
	int blk_x = ceil(size_x/num_x);
    int blk_y = ceil(size_y/num_y);
    int blk_z = ceil(size_z/num_z);
	int num_blk =  blk_x * blk_y * blk_z;

	float start_x = -1.0f * norm_size_x;
	float start_y = -1.0f * norm_size_y;
	float start_z = -1.0f * norm_size_z;

	float scale_x = 2.0 * norm_size_x / (float)blk_x;
	float scale_y = 2.0 * norm_size_y / (float)blk_y;
	float scale_z = 2.0 * norm_size_z / (float)blk_z;

	float angle = 20;
	
	float distance = 2.0f;
	float dis;
	// vector<string> items;
	vector<int> item_sets;
	map<std::string, vector<int> > all_map;
	vector<int> d_vec;
	vector<vector<int> > datavec;
	ofstream outf;
	char outfile[50] = "map_all_direction.dat";
	outf.open(outfile);
    float delta_d = 0.1f;
    float delta_theta = 5.0f;
    float delta_phi = 5.0f;
    t0 = time(NULL);
	for (float d = distance; d >= 1.0f ; d-= delta_d)
	{
		for (float theta = 0; theta < 180.0f; theta+=delta_theta)
		{
			for (float phi = 0; phi < 360.0f; phi+=delta_phi)
			{
				char view_pos[50];
				sprintf(view_pos, "%4.2f%5.1f%5.1f", d, theta, phi);

                float small_d = 0.3f;
                for (float ix = -1.0f * small_d; ix < small_d ; ix += small_d)
                {
                    for (float iy = -1.0f * small_d; iy < small_d ; iy += small_d)
                    {
                        for (float iz = -1.0f * small_d; iz < small_d ; iz += small_d)
                        {
            				for (int i = 0; i < num_blk; ++i)
            				{
            					int i_z = i/(blk_x * blk_y);
            					int i_y = (i%(blk_x * blk_y))/blk_x;	
            					int i_x = (i%(blk_x * blk_y))%blk_x;

            					//left bottom coordinates of every block
            					float x = start_x + i_x * scale_x; 
            					float y = start_y + i_y * scale_y;
            					float z = start_z + i_z * scale_z;
            					
            					//top right coordinates of every block
            					float x1 = x + scale_x;
            					float y1 = y + scale_y;
            					float z1 = z + scale_z;

            					float cos_theta = cos ( theta * PI / 180.0 );
            					float sin_theta = sin ( theta * PI / 180.0 );
            					float cos_phi   = cos ( phi   * PI / 180.0 );
            					float sin_phi   = sin ( phi   * PI / 180.0 );

            					float dx = d * sin_theta * cos_phi;
            					float dy = d * sin_theta * sin_phi;
            					float dz = d * cos_theta;

                                float ddx = dx + ix;
                                float ddy = dy + iy;
                                float ddz = dz + iz;

                                int b1 = is_vis(x,  y,  z,  ddx, ddy, ddz, angle/2.0);
                                int b2 = is_vis(x,  y,  z1, ddx, ddy, ddz, angle/2.0);
                                int b3 = is_vis(x,  y1, z,  ddx, ddy, ddz, angle/2.0);
                                int b4 = is_vis(x,  y1, z1, ddx, ddy, ddz, angle/2.0);
                                int b5 = is_vis(x1, y,  z,  ddx, ddy, ddz, angle/2.0);
                                int b6 = is_vis(x1, y,  z1, ddx, ddy, ddz, angle/2.0);
                                int b7 = is_vis(x1, y1, z,  ddx, ddy, ddz, angle/2.0);
                                int b8 = is_vis(x1, y1, z1, ddx, ddy, ddz, angle/2.0);

                                if(b1||b2||b3||b4||b5||b6||b7||b8){
                                    d_vec.push_back(i);
                                }
                            }
                            datavec.push_back(d_vec);
                            d_vec.clear();
                        } 
                    }
				}
				// printf("view_pos = %s\n", view_pos);
                item_sets = intersection(datavec);
                // for (vector<int>::iterator it = item_sets.begin(); it!=item_sets.end(); ++it){
                //     std::cout << ' ' << *it;
                // }
                // cout << endl;
                datavec.clear();
			    all_map.insert(pair<string, vector<int> >(view_pos, item_sets));
			    item_sets.clear();
			}
		}
	}

    int map_size = all_map.size();
    outf.write(reinterpret_cast<const char *>(&map_size), sizeof(int));
    for (map<string, vector<int> >::iterator it = all_map.begin(); it != all_map.end(); ++it)
    {
        char index[50];
        sprintf(index, "%s", it->first.c_str());
        printf("index = %s\n",index );
        outf.write(reinterpret_cast<const char *>(index), sizeof(char)*50);
        int item_size = it->second.size();
        printf("item_size = %d\n", item_size);
        outf.write(reinterpret_cast<const char *>(&item_size), sizeof(int));
        printf("item_set = ");
        for (vector<int>::iterator itor = it->second.begin(); itor < it->second.end(); ++itor)
        {
            int elem = *itor;
            printf("%d ", elem);
            outf.write(reinterpret_cast<const char *>(&elem), sizeof(int));  
        }
        printf("\n");
    }
	outf.close();
    t1=time(NULL);
    printf("using %ld seconds.\n", abs(t1-t0));
	return 0;
}		