//for any position of any size of volume

#include <cstdio>
#include <cassert>
#include <cstdlib>
#include <cstring>
#include <algorithm>
#include <cmath>
#include <time.h>
#include <fstream>
#include <iostream>
#include <sstream>
#include <string>
#include <stdlib.h>
#include <assert.h>
#include <climits>
#include <vector>
#include <map>
#include <unordered_set>

#define PI 3.14159265

using namespace std;

int is_vis(float x, float y, float z, float dx, float dy, float dz, float angle){
	float AB = ((x - dx) * (-dx) + (y - dy) * (-dy) + (z - dz) * (-dz));
	float A = sqrt(dx * dx + dy * dy + dz * dz);
	float B = sqrt((x - dx) * (x - dx) + (y - dy) * (y - dy) + (z - dz) * (z - dz));

	assert(A != 0);
	assert(B != 0);

	float result = acos (AB/A/B) * 180.0 / PI;
	if (abs(result) <= angle){
		return 1;
	}else{
		return 0;
	}
}


int main(int argc, char **argv){
	if (argc != 5) {
        cout << "Usage: " << argv[0] << "size_x, size_y, size_z, test_count"  << endl;
        return 0;
    }

    int  size_x    = atoi(argv[1]);
	int  size_y    = atoi(argv[2]);
	int  size_z    = atoi(argv[3]);
	int  test_count  = atoi(argv[4]);
	int test_num = 360/test_count;
	int max_size =  max(max(size_x, size_y), size_z);

	int norm_size_x = size_x / max_size;
	int norm_size_y = size_y / max_size;
	int norm_size_z = size_z / max_size;
	//# of points for each block
	int num_x = 50;
	int num_y = 100;
	int num_z = 50;
	int num_per_blk = num_x * num_y * num_z;
	// # of block
	int blk_x = ceil(size_x/num_x);
	int blk_y = ceil(size_y/num_y);
	int blk_z = ceil(size_z/num_z);
	int num_blk =  blk_x * blk_y * blk_z;

	float start_x = -1.0f * norm_size_x;
	float start_y = -1.0f * norm_size_y;
	float start_z = -1.0f * norm_size_z;

	float scale_x = 2.0 * norm_size_x / (float)blk_x;
	float scale_y = 2.0 * norm_size_y / (float)blk_y;
	float scale_z = 2.0 * norm_size_z / (float)blk_z;

	float angle = 20;
	
	float distance = 2.0f;


	ifstream infile;
	
	int ssd_size = 512;
	int hdd_size = 1024;
	unordered_set<int> hdd_set;

	map<int, int> ssd_map;	

	for (int i = 0; i < hdd_size; ++i)
	{
		hdd_set.insert(i);
	}


    infile.open("map_all_direction.dat");
    assert(infile);
    cerr << "Open " << "map_all_direction.dat" << endl;
   	int map_size;
    infile.read(reinterpret_cast<char *>(&map_size), sizeof(int));
    printf("map_size = %d\n",map_size );
    map<string, vector<int> > all_map;
    vector<int> items;
    for (int i = 0; i < map_size; ++i)
    {
        char index[50];
        infile.read(reinterpret_cast<char *>(index), sizeof(char)*50);
        
        int item_size;
        infile.read(reinterpret_cast<char *>(&item_size), sizeof(int));
        
        for (int j = 0; j < item_size; ++j)
        {	
        	int elem;
        	infile.read(reinterpret_cast<char *>(&elem), sizeof(int));
        
        	items.push_back(elem);	
        }
    	
        all_map.insert(pair<string, vector<int> >(index, items));
        items.clear();
    }
    infile.close();
   
	char test_file[50];
	sprintf (test_file, "round_test_%d.dat", test_count);
	infile.open(test_file);
	assert(infile);
	cerr << "Open " << test_file << endl;
	float *dis = NULL;
    dis = new float[test_num];
    float *theta = NULL;
    theta = new float[test_num];
    float *phi = NULL; 
    phi = new float[test_num];
	
	infile.read(reinterpret_cast<char *>(dis), sizeof(float)*test_num);
	infile.read(reinterpret_cast<char *>(theta), sizeof(float)*test_num);
	infile.read(reinterpret_cast<char *>(phi), sizeof(float)*test_num);
	infile.close();

	vector<int> d_vec;
	int miss = 0;
	int miss_blk = 0;
	int total= 0;
	int time_stamp = 0;
	char memfile[50];
	float delta_d = 0.1;
    float delta_theta = 5;
    float delta_phi = 5;
	for (int i = 0; i < test_num; ++i)
	{
		char view_pos[50]; 
		float norm_dis, norm_theta, norm_phi;

		float cl_dis = abs(ceil((dis[i]  - 1.6f)/delta_d) * delta_d + 1.6f - dis[i]);
		float fl_dis = abs(floor((dis[i] - 1.6f)/delta_d) * delta_d + 1.6f - dis[i]);
		if (cl_dis < fl_dis)
		{
			norm_dis = ceil((dis[i]  - 1.6f)/delta_d) * delta_d + 1.6f;
		}else{
			norm_dis = floor((dis[i] - 1.6f)/delta_d) * delta_d + 1.6f;
		}
		
		float cl_theta = abs(ceil(theta[i]  / delta_theta) * delta_theta - theta[i]);
		float fl_theta = abs(floor(theta[i] / delta_theta) * delta_theta - theta[i]);
		if (cl_theta < fl_theta)
		{
			norm_theta = ceil(theta[i]  / delta_theta) * delta_theta;
		}else{
			norm_theta = floor(theta[i]  / delta_theta) * delta_theta;
		}
		
		float cl_phi = abs(ceil(phi[i]  / delta_phi) * delta_phi - phi[i]);
		float fl_phi = abs(floor(phi[i] / delta_phi) * delta_phi - phi[i]);
		if (cl_phi < fl_phi)
		{
			norm_phi = ceil(phi[i]  / delta_phi) * delta_phi;
		}else{
			norm_phi = floor(phi[i]  / delta_phi) * delta_phi;
		}
	

		sprintf(view_pos, "%4.2f%5.1f%5.1f", norm_dis, norm_theta, norm_phi);
		// printf("real view = %f, %f, %f; norm view = %f, %f, %f \n",dis[i], theta[i], phi[i], norm_dis, norm_theta, norm_phi );
		for (int j = 0; j < num_blk; ++j)
		{
			int i_z = j/(blk_x * blk_y);
			int i_y = (j%(blk_x * blk_y))/blk_x;	
			int i_x = (j%(blk_x * blk_y))%blk_x;
			// printf("ix = %d, iy = %d, iz = %d\n", i_x, i_y, i_z);
			float x = start_x + i_x * scale_x; 
			float y = start_y + i_y * scale_y;
			float z = start_z + i_z * scale_z;
			
			//top right coordinates of every block
			float x1 = x + scale_x;
			float y1 = y + scale_y;
			float z1 = z + scale_z;

			float cos_theta = cos ( theta[i] * PI / 180.0 );
			float sin_theta = sin ( theta[i] * PI / 180.0 );
			float cos_phi   = cos ( phi[i]   * PI / 180.0 );
			float sin_phi   = sin ( phi[i]   * PI / 180.0 );

			float dx = dis[i] * sin_theta * cos_phi;
			float dy = dis[i] * sin_theta * sin_phi;
			float dz = dis[i] * cos_theta;

			int b1 = is_vis(x,  y,  z,  dx, dy, dz, angle/2.0);
			int b2 = is_vis(x,  y,  z1, dx, dy, dz, angle/2.0);
			int b3 = is_vis(x,  y1, z,  dx, dy, dz, angle/2.0);
			int b4 = is_vis(x,  y1, z1, dx, dy, dz, angle/2.0);
			int b5 = is_vis(x1, y,  z,  dx, dy, dz, angle/2.0);
			int b6 = is_vis(x1, y,  z1, dx, dy, dz, angle/2.0);
			int b7 = is_vis(x1, y1, z,  dx, dy, dz, angle/2.0);
			int b8 = is_vis(x1, y1, z1, dx, dy, dz, angle/2.0);
			if(b1||b2||b3||b4||b5||b6||b7||b8){
				d_vec.push_back(j);
				// printf("i = %d\n", i);
			}
		}
		int prefetch_num = ssd_size/4;
		time_stamp++;
		

		vector<int> tmp;
		for (vector<int>::iterator itor = d_vec.begin() ; itor !=d_vec.end(); ++itor)
		{	
			
			map<int,int>::iterator got_ssd = ssd_map.find(*itor);
			if (got_ssd != ssd_map.end()){
				printf("%d is good!\n", *itor);
				total++;
				got_ssd->second = total;
				tmp.push_back(*itor);
				
			}else{
				printf("%d did not find\n", *itor);
				continue;
			}
		}
	
		for (vector<int>::iterator it = tmp.begin(); it != tmp.end(); ++it)
		{
			vector<int>::iterator iter;

		  	iter = find (d_vec.begin(), d_vec.end(), *it);
		  	if (iter != d_vec.end()){
		  		d_vec.erase(iter);
		    }
		}
		tmp.clear();
		map<string, vector<int> >::iterator got_ssd;
		got_ssd = all_map.find(view_pos);
		
		vector<int>::iterator it_size;
		it_size = (got_ssd->second.size()>prefetch_num )? got_ssd->second.begin()+prefetch_num-1 : got_ssd->second.end();
		if (got_ssd!=all_map.end()) //find in all_direction map
		{
			for (vector<int>::iterator vec_itr = got_ssd->second.begin(); vec_itr != it_size; ++vec_itr)
			{
				map<int, int>::iterator im;
				im = ssd_map.find(*vec_itr);
				if (im != ssd_map.end())
				{
					continue;
				}else{
					
					unordered_set<int>::const_iterator got_hdd = hdd_set.find(*vec_itr);
					if (got_hdd != hdd_set.end()){
						if (ssd_map.size() < ssd_size)
						{
							ssd_map.insert(pair<int, int>(*got_hdd, total));
							hdd_set.erase(*got_hdd);
						}else{
							int min = INT_MAX;
							map<int,int>::iterator pt;
							for (map<int,int>::iterator map_it=ssd_map.begin(); map_it!=ssd_map.end(); ++map_it)
							{
								if (map_it->second < min )
								{
									min = map_it->second;
									pt = map_it;
								}
							}
					
							ssd_map.erase(pt);
							hdd_set.insert(pt->first);
							ssd_map.insert(pair<int, int >(*got_hdd,total));
							hdd_set.erase(*got_hdd);
							
						}
					}else{
						// printf("there is no file %d on hdd\n",*vec_itr );
					}				
				}
			}
		}
		printf("d_vec new size = %d ----------------------\n", d_vec.size() );
		if (d_vec.size() > 0)
		{
			for (vector<int>::iterator itor = d_vec.begin() ; itor !=d_vec.end(); ++itor)
			{	
				
				map<int,int>::iterator got_ssd = ssd_map.find(*itor);
				if (got_ssd != ssd_map.end()){
					printf("%d good!\n", *itor);
					total++;
					got_ssd->second = total;
					
				}else{
					printf("miss\n");
					miss++;
					total++;

					unordered_set<int>::const_iterator got_hdd = hdd_set.find(*itor);

					if (got_hdd != hdd_set.end()){
						if (ssd_map.size() < ssd_size)
						{
							ssd_map.insert(pair<int, int>(*got_hdd, total));
							hdd_set.erase(*got_hdd);

						}else{
							int min = INT_MAX;
							map<int,int>::iterator pt;
							for (map<int,int>::iterator map_it=ssd_map.begin(); map_it!=ssd_map.end(); ++map_it)
							{
								if (map_it->second < min )
								{
									min = map_it->second;
									pt = map_it;
								}
							}

							ssd_map.erase(pt);
							hdd_set.insert(pt->first);
							ssd_map.insert(pair<int, int >(*got_hdd,total));
							hdd_set.erase(*got_hdd);
						}
					}else{
						// printf("no blkfile %d on hdd \n", *itor );
					}
				}	
			}
		}		
		d_vec.clear();	
		
	}
	printf("miss_rate = %d / %d = %f\n", miss, total, (float)miss/total);
	
	return 0;
}