//evaluate importance of each block
#include <cstdio>
#include <cassert>
#include <cstdlib>
#include <cstring>
#include <algorithm>
#include <cmath>
#include <time.h>
#include <fstream>
#include <iostream>
#include <sstream>
#include <string>
#include <stdlib.h>
#include <assert.h>
#include <float.h>
#include <vector>


using namespace std;

int cmp(const void *v1, const void *v2)
{
const int i1 = **(const int **)v1;
const int i2 = **(const int **)v2;

return i1>i2?-1:(i1<i2);
}


int main(int argc, char **argv)
{	
	if (argc != 5) {
        cout << "Usage: " << argv[0] << " filename, size_x, size_y, size_z"  << endl;
        return 0;
    }

	char *input_file = argv[1];
	int  size_x = atoi(argv[2]);
	int  size_y = atoi(argv[3]);
	int  size_z = atoi(argv[4]);

	//# of points for each block
	int num_x = 50;
	int num_y = 50;
	int num_z = 50;
	int num_per_blk = num_x * num_y * num_z;
	// # of block
	int blk_x = ceil(size_x/(float)num_x);
    int blk_y = ceil(size_y/(float)num_y);
    int blk_z = ceil(size_z/(float)num_z);
	int num_blk =  blk_x * blk_y * blk_z;
	
	int st = size_x * size_y * size_z;
	float   *input_vol = NULL;
	
	input_vol = new float[st];
	
	memset(input_vol, 0, sizeof(float)   * st);

	long long ssd_size = 20000000000;//20GB
	long blk_size = num_per_blk * 4;
	//int num_small_file = ssd_size / blk_size;
	int num_small_file = num_blk/2;

	//read the input data file
	ifstream inf(input_file);
	if (!inf)
	{
		cerr << "Cannot open " << input_file << endl;
		return 0;
	}

	cout << "Open " << input_file << endl;
	inf.read(reinterpret_cast<char *>(input_vol), sizeof(float) * st);
	inf.close();
	
	
	//compute min and max value for each block
	float *min = new float[num_blk];
	float *max = new float[num_blk];
	for (int i = 0; i < num_blk; ++i)
	{
		min[i] = FLT_MAX;
		max[i] = FLT_MIN;
		int i_z = i/(blk_x * blk_y);
		int i_y = (i%(blk_x * blk_y))/blk_x;
		int i_x = (i%(blk_x * blk_y))%blk_x;
		
		for (int z = i_z*num_z; z < (i_z+1)*num_z; z++)
		{
			for (int y = i_y*num_y; y < (i_y+1)*num_y; y++)
			{
				for (int x = i_x*num_x; x < (i_x+1)*num_x; x++)
				{	
					if (x>=size_x || y>=size_y || z>=size_z)
					{
						continue;
					}
					int id =  x + y * size_x + z * size_x * size_y;
					if(input_vol[id] < min[i]){
						min[i] = input_vol[id];
					}
					if(input_vol[id] > max[i]){
						max[i] = input_vol[id];
					}
				}
			}
		}
	}
					
					
	//compute entropy for each block find the importance
	int num_bin = 20;
	
	float *entropy = NULL; 
	int *points_per_blk = NULL;
	entropy = new float[num_blk];
	points_per_blk = new int[num_blk];

	
	memset(entropy, 0, sizeof(float)*num_blk);
	memset(points_per_blk, 0, sizeof(int)*num_blk);

	// construct a histogram for each block


	for (int i = 0; i < num_blk; ++i)
	{

		int *bin = NULL;
		float *pos = NULL;
		float *info = NULL;

		bin = new int[num_bin];
		pos = new float[num_bin];
		info = new float[num_bin];

		memset(bin, 0, sizeof(int)*num_bin);
		memset(pos, 0, sizeof(float)*num_bin);
		memset(info, 0, sizeof(float)*num_bin);
		int i_z = i/(blk_x * blk_y);
		int i_y = (i%(blk_x * blk_y))/blk_x;
		int i_x = (i%(blk_x * blk_y))%blk_x;
		
		for (int z = i_z*num_z; z < (i_z+1)*num_z; z++)
		{
			for (int y = i_y*num_y; y < (i_y+1)*num_y; y++)
			{
				for (int x = i_x*num_x; x < (i_x+1)*num_x; x++)
				{	
					if (x>=size_x || y>=size_y || z>=size_z)
					{
						continue;
					}
					int id =  x + y * size_x + z * size_x * size_y;
					int bin_index = (input_vol[id] - min[i])/(float)(max[i] - min[i]) * num_bin;
					bin[bin_index]++;//the number of point in each bin
					points_per_blk[i]++;
				}
			}
		}

		//posibilities and infomation values
		for (int j = 0; j < num_bin; ++j)
		{
			pos[j] = bin[j]/(float)points_per_blk[i];
			info[j] = (-1.0) * pos[j] * log(pos[j])/log(2);
			// printf("info = %f\n", info[i]);
		}

		for (int z = i_z*num_z; z < (i_z+1)*num_z; z++)
		{
			for (int y = i_y*num_y; y < (i_y+1)*num_y; y++)
			{
				for (int x = i_x*num_x; x < (i_x+1)*num_x; x++)
				{	
					if (x>=size_x || y>=size_y || z>=size_z)
					{
						continue;
					}
					int id =  x + y * size_x + z * size_x * size_y;
					int bin_index = (input_vol[id] - min[i])/(max[i] - min[i]) * num_bin;
					entropy[i] += info[bin_index];
				}	
			}
		}
		delete [] bin;
		delete [] pos;
		delete [] info;
	}

	for (int i = 0; i < num_blk; ++i)
	{
		printf("entropy = %f\n", entropy[i]);
	}

	//sorting
	
	float** pk_blk;
	pk_blk = (float**)malloc(sizeof(float*)*num_blk);
	int *blk_rank  = new int[num_blk];
	int *blk_pos   = new int[num_blk];
	for (int i = 0; i < num_blk; ++i)
	{
		pk_blk[i] = &entropy[i];
	}
	qsort(pk_blk, num_blk, sizeof *pk_blk, cmp);
	puts("Sorting the values:");
	for(int i = 0;i < num_blk;i++){
		printf("%f ",entropy[i]);
	}
	puts("\n");
	for(int i = 0;i < num_blk;++i){
		blk_pos[i] = (pk_blk[i]-entropy);
		// printf("blk_pos[%d] : %d\n", i, blk_pos[i]);
		blk_rank[blk_pos[i]] = i;
		printf("value: %-6f, position: %d, rank[%d]: %d\n",*(pk_blk[i]), 
				blk_pos[i], blk_pos[i], blk_rank[blk_pos[i]]);
	}

	vector<int> im_ssd_vec;
	vector<int> im_hdd_vec;
	for (int i = 0; i < num_blk; ++i)
	{
		int i_z = i/(blk_x * blk_y);
		int i_y = (i%(blk_x * blk_y))/blk_x;
		int i_x = (i%(blk_x * blk_y))%blk_x;
		int count = 0;
		float *small_vol = NULL; //volume data per block
		small_vol =new float[num_per_blk];
		memset(small_vol, 0, sizeof(float) * num_per_blk);
		for (int z = i_z*num_z; z < (i_z+1)*num_z; z++)
		{
			for (int y = i_y*num_y; y < (i_y+1)*num_y; y++)
			{
				for (int x = i_x*num_x; x < (i_x+1)*num_x; x++)
				{	
					if (x>=size_x || y>=size_y || z>=size_z)
					{
						continue;
					}
					int id =  x + y * size_x + z * size_x * size_y;
					small_vol[count] = input_vol[id];
					count++;
				}	
			}
		}
		if (blk_rank[i] < num_small_file )
		{
			im_ssd_vec.push_back(blk_pos[blk_rank[i]]);
			// ofstream outf;
			// char outfile [50];
			// sprintf (outfile, "/home/lina/ssd1/B%d.dat", blk_pos[blk_rank[i]]);
		 //    outf.open(outfile);  
		 //    outf.write(reinterpret_cast<const char *>(small_vol), sizeof(float) * count);
		 //    outf.close();
		    delete [] small_vol;
		}else{
			im_hdd_vec.push_back(blk_pos[blk_rank[i]]);
			ofstream outf;
			// char outfile [50];
			// sprintf (outfile, "/home/lina/hdd1/B%d.dat", i);
		 //    outf.open(outfile);  
		 //    outf.write(reinterpret_cast<const char *>(small_vol), sizeof(float) * count);
		 //    outf.close();
		    delete [] small_vol;
		}
	}

	long ssd_data_size = im_ssd_vec.size();
	long hdd_data_size = im_hdd_vec.size();
	int *im_ssd  = new int[ssd_data_size];
	int *im_hdd  = new int[hdd_data_size];

	for (long i = 0; i < ssd_data_size; ++i)
	{
		im_ssd[i] = im_ssd_vec[i];
	}

	for (long i = 0; i < hdd_data_size; ++i)
	{
		im_hdd[i] = im_hdd_vec[i];
	}

	ofstream outf;
	char outfile_1[50] = "im_ssd_vec.dat";
	char outfile_2[50] = "im_hdd_vec.dat";
	outf.open(outfile_1);  
	outf.write(reinterpret_cast<const char *>(&ssd_data_size), sizeof(long));
    outf.write(reinterpret_cast<const char *>(im_ssd), sizeof(int) * im_ssd_vec.size());
    outf.close();
    outf.open(outfile_2);  
    outf.write(reinterpret_cast<const char *>(&hdd_data_size), sizeof(long));
    outf.write(reinterpret_cast<const char *>(im_hdd), sizeof(int) * im_hdd_vec.size());
    outf.close();
	delete [] input_vol;;
	delete [] entropy;
	delete [] blk_rank;
	delete [] blk_pos;
	delete [] im_ssd;
	delete [] im_hdd;

	// for (int i = 0; i < num_blk; ++i)
	// {
	// 	delete [] pk_blk[i];
	// }
	return 0;
}


