import java.util.Scanner;

public class ShoppingCartNegatives {
   public static void main(String[] args) {
      String[] items = getItemsByNumber();
      System.out.println("You have " + items.length + " items in your shopping cart.");
   }

   private static String[] getItemsByNumber() {
      String[] items = null;
      Scanner in = new Scanner(System.in);

      boolean inputValid = false;

      while (!inputValid) {
         System.out.print("Enter the number of items: ");
         String input = in.next();

         try {
            int numItems = Integer.parseInt(input);
            if (numItems > 0) {
               items = new String[numItems];
               inputValid = true;
               //if the code made it here, we have valid input
            }
         } catch (NumberFormatException e) { 
            System.out.println("You didn't enter a valid integer.");
         }
      }

      return items;
   }
}
