#!/usr/bin/env python3
# coding: utf-8

# %%
from common.df import get_df
from common.tables import get_styler, highlight_cols, highlight_rows, save_table
from common.graphs import setup_plots, save_plot
import matplotlib.pyplot as plt

if __name__ == '__main__':
    df = get_df('part1', 'task1', names=['var', 'project', 'commit', 'ts'])
    df = df.drop(columns=['var'])

    # show as a table
    style = highlight_rows(highlight_cols(get_styler(df))).hide(axis='index')
    save_table(style, 'part1.tex', 'task1')

    # plot the data
    setup_plots()

    df2 = df.drop(columns=['project', 'commit'])
    df2.value_counts().sort_index(ascending=True).plot.bar(logy=True)
    plt.xticks(rotation=45, ha='right', rotation_mode='anchor')

    save_plot('task1.png')