# coding: utf-8

from matplotlib import pyplot as plt
import os
from typing import Dict, Any

from .utils import _resolve_dir

__all__ = ["setup_plots", "save_plot"]

def setup_plots(rcParams: Dict[str, Any] = None):
    # avoid Type 3 fonts
    plt.rcParams['pdf.fonttype'] = 42
    plt.rcParams['ps.fonttype'] = 42

    plt.rcParams['figure.figsize'] = [6.0, 5.0]
    plt.rcParams['figure.dpi'] = 600.0
    plt.rcParams['font.size'] = 12
    if rcParams:
        for (k,v) in rcParams.items():
            plt.rcParams[k] = v

    plt.subplots(constrained_layout=True)


def save_plot(filename):
    os.makedirs(_resolve_dir(f'figures'), 0o755, True)

    plt.savefig(_resolve_dir(f'figures/{filename}'), dpi=1200, bbox_inches='tight')
    plt.close()