#!/usr/bin/env python3
#
# Carrick Detweiler, 2022
# 
# Nothing like stackoverflow....
#  https://stackoverflow.com/questions/30988033/sending-live-video-frame-over-network-in-python-opencv
#  https://stackoverflow.com/questions/57577445/list-available-cameras-opencv-python
#

import cv2
import numpy as np
import socket
import sys
import pickle
import struct

def list_ports():
    """
    Test the ports and returns a tuple with the available ports and the ones that are working.
    """
    non_working_ports = []
    dev_port = 0
    working_ports = []
    available_ports = []
    while len(non_working_ports) < 3: # test until a few ports are not found
        camera = cv2.VideoCapture(dev_port)
        if not camera.isOpened():
            non_working_ports.append(dev_port)
            #print("Port %s is not working." %dev_port)
        else:
            is_reading, img = camera.read()
            w = camera.get(3)
            h = camera.get(4)
            if is_reading:
                print("Port %s is working and reads images (%s x %s)" %(dev_port,h,w))
                working_ports.append(dev_port)
            else:
                #print("Port %s for camera ( %s x %s) is present but does not reads." %(dev_port,h,w))
                available_ports.append(dev_port)
        dev_port +=1
    return available_ports,working_ports,non_working_ports


if len(sys.argv[1:]) != 1:
    print("-----Available Ports-------")
    list_ports()
    print("---------------------------")
    print("")
    print("Please enter port when running this program, for instance")
    print(" ",sys.argv[0],0)
    sys.exit()
    


cap=cv2.VideoCapture(int(sys.argv[1]))
#resize the images to make a bit smaller
cap.set(3,640)
cap.set(4,480)
clientsocket=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
clientsocket.connect(('localhost',8089))

while True:
    ret,frame=cap.read()
    # Serialize frame
    # Protocol 1 needs to be used to work with ROS python2
    data = pickle.dumps(frame,protocol=1) 

    # Send message length first
    message_size = struct.pack("L", len(data)) ### CHANGED

    # Then data
    clientsocket.sendall(message_size + data)
