#!/usr/bin/env python2
from __future__ import print_function

#
# Carrick Detweiler, 2022
# 
# Nothing like stackoverflow....
#  https://stackoverflow.com/questions/30988033/sending-live-video-frame-over-network-in-python-opencv

import pickle
import socket
import struct
import cv2

#ROS stuff
import roslib
import rospy
from cv_bridge import CvBridge
from sensor_msgs.msg import Image
from cv_bridge import CvBridge, CvBridgeError

HOST = ''
PORT = 8089

s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
print('Socket created')

s.bind((HOST, PORT))
print('Socket bind complete')
s.listen(10)
print('Socket now listening')

conn, addr = s.accept()

data = b'' ### CHANGED
payload_size = struct.calcsize("L") ### CHANGED

rospy.init_node('camera_receiver', anonymous=True)
# Now do the ROS stuff
image_pub = rospy.Publisher("image",Image,queue_size=1)
bridge = CvBridge()

while True:

    # Retrieve message size
    while len(data) < payload_size:
        data += conn.recv(4096)

    packed_msg_size = data[:payload_size]
    data = data[payload_size:]
    msg_size = struct.unpack("L", packed_msg_size)[0] ### CHANGED

    # Retrieve all data based on message size
    while len(data) < msg_size:
        data += conn.recv(4096)

    frame_data = data[:msg_size]
    data = data[msg_size:]

    # Extract frame
    frame = pickle.loads(frame_data)

    #
    try:
      image_pub.publish(bridge.cv2_to_imgmsg(frame, "bgr8"))
    except CvBridgeError as e:
      print(e)
      
    # Display
    #cv2.imshow('frame', frame)
    #cv2.waitKey(1)
