/* digits.c    inserts digits into pgm image
 * Daniel Scharstein  2/25/99
 *
 * digit defs taken from pbmupc.c
 *
 * $Id: digits.c 3199 2011-10-12 21:39:13Z carrick $
 */

/*#include "misc.h"*/
#include "image.h"
#include "digits.h"


typedef unsigned char bit;

static bit digits[11][DIGIT_HEIGHT][DIGIT_WIDTH] = {

  /* 0 */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,1,1,1,1,0,0,0,0,
  0,0,0,1,1,1,1,1,1,1,1,0,0,0,
  0,0,1,1,1,0,0,0,0,1,1,1,0,0,
  0,0,1,1,0,0,0,0,0,0,1,1,0,0,
  0,1,1,1,0,0,0,0,0,0,1,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,1,0,0,0,0,0,0,1,1,1,0,
  0,0,1,1,0,0,0,0,0,0,1,1,0,0,
  0,0,1,1,1,0,0,0,0,1,1,1,0,0,
  0,0,0,1,1,1,1,1,1,1,1,0,0,0,
  0,0,0,0,1,1,1,1,1,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  
  /* 1 */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,
  0,0,0,0,1,1,1,1,0,0,0,0,0,0,
  0,0,0,1,1,1,1,1,0,0,0,0,0,0,
  0,0,1,1,1,0,1,1,0,0,0,0,0,0,
  0,0,1,1,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  
  /* 2 */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,0,0,0,0,0,
  0,0,0,1,1,1,1,1,1,1,1,0,0,0,
  0,0,1,1,1,1,0,0,1,1,1,1,0,0,
  0,1,1,1,0,0,0,0,0,0,1,1,0,0,
  0,1,1,0,0,0,0,0,0,0,1,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,1,1,0,
  0,0,0,0,0,0,0,0,0,0,1,1,1,0,
  0,0,0,0,0,0,0,0,0,1,1,1,0,0,
  0,0,0,0,0,0,0,0,1,1,1,0,0,0,
  0,0,0,0,0,0,0,1,1,1,0,0,0,0,
  0,0,0,0,0,0,1,1,1,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,
  0,0,0,0,1,1,1,0,0,0,0,0,0,0,
  0,0,0,1,1,1,0,0,0,0,0,0,0,0,
  0,0,1,1,1,0,0,0,0,0,0,0,0,0,
  0,1,1,1,0,0,0,0,0,0,0,0,0,0,
  0,1,1,1,1,1,1,1,1,1,1,1,1,0,
  0,1,1,1,1,1,1,1,1,1,1,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  
  /* 3 */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,1,1,1,1,1,1,1,1,1,1,1,0,
  0,1,1,1,1,1,1,1,1,1,1,1,1,0,
  0,0,0,0,0,0,0,0,0,0,1,1,1,0,
  0,0,0,0,0,0,0,0,0,1,1,1,0,0,
  0,0,0,0,0,0,0,0,1,1,1,0,0,0,
  0,0,0,0,0,0,0,1,1,1,0,0,0,0,
  0,0,0,0,0,0,1,1,1,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,1,1,0,0,0,
  0,0,0,0,0,0,0,0,1,1,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,1,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,0,0,0,0,0,0,0,1,1,1,0,
  0,1,1,1,0,0,0,0,0,0,1,1,0,0,
  0,0,1,1,1,1,0,0,1,1,1,1,0,0,
  0,0,0,1,1,1,1,1,1,1,1,0,0,0,
  0,0,0,0,0,1,1,1,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  
  /* 4 */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,
  0,0,0,0,0,1,1,0,0,0,0,0,0,0,
  0,0,0,0,1,1,1,0,0,0,0,0,0,0,
  0,0,0,0,1,1,0,0,0,0,0,0,0,0,
  0,0,0,1,1,1,0,0,0,0,0,0,0,0,
  0,0,0,1,1,0,0,0,1,1,0,0,0,0,
  0,0,1,1,1,0,0,0,1,1,0,0,0,0,
  0,0,1,1,0,0,0,0,1,1,0,0,0,0,
  0,1,1,1,0,0,0,0,1,1,0,0,0,0,
  0,1,1,1,1,1,1,1,1,1,1,1,1,0,
  0,1,1,1,1,1,1,1,1,1,1,1,1,0,
  0,0,0,0,0,0,0,0,1,1,0,0,0,0,
  0,0,0,0,0,0,0,0,1,1,0,0,0,0,
  0,0,0,0,0,0,0,0,1,1,0,0,0,0,
  0,0,0,0,0,0,0,0,1,1,0,0,0,0,
  0,0,0,0,0,0,0,0,1,1,0,0,0,0,
  0,0,0,0,0,0,0,0,1,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  
  /* 5 */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,1,1,1,1,1,1,1,1,1,1,1,0,
  0,1,1,1,1,1,1,1,1,1,1,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,0,0,0,
  0,1,1,0,0,0,0,0,0,0,0,0,0,0,
  0,1,1,0,0,0,0,0,0,0,0,0,0,0,
  0,1,1,0,0,0,0,0,0,0,0,0,0,0,
  0,1,1,0,0,0,0,0,0,0,0,0,0,0,
  0,1,1,1,1,1,1,1,1,0,0,0,0,0,
  0,1,1,1,1,1,1,1,1,1,1,0,0,0,
  0,0,0,0,0,0,0,0,1,1,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,1,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,0,0,0,0,0,0,0,1,1,1,0,
  0,1,1,1,0,0,0,0,0,0,1,1,0,0,
  0,0,1,1,1,1,0,0,1,1,1,1,0,0,
  0,0,0,1,1,1,1,1,1,1,1,0,0,0,
  0,0,0,0,0,1,1,1,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  
  /* 6 */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,1,0,0,0,0,0,
  0,0,0,0,0,0,1,1,1,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,
  0,0,0,0,1,1,1,0,0,0,0,0,0,0,
  0,0,0,1,1,1,0,0,0,0,0,0,0,0,
  0,0,0,1,1,0,0,0,0,0,0,0,0,0,
  0,0,1,1,1,0,0,0,0,0,0,0,0,0,
  0,0,1,1,0,1,1,1,1,0,0,0,0,0,
  0,0,1,1,1,1,1,1,1,1,1,0,0,0,
  0,1,1,1,1,1,0,0,1,1,1,1,0,0,
  0,1,1,1,0,0,0,0,0,0,1,1,0,0,
  0,1,1,1,0,0,0,0,0,0,1,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,1,0,0,0,0,0,0,1,1,1,0,
  0,0,1,1,0,0,0,0,0,0,1,1,0,0,
  0,0,1,1,1,1,0,0,1,1,1,1,0,0,
  0,0,0,1,1,1,1,1,1,1,1,0,0,0,
  0,0,0,0,0,1,1,1,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  
  /* 7 */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,1,1,1,1,1,1,1,1,1,1,1,0,
  0,1,1,1,1,1,1,1,1,1,1,1,1,0,
  0,0,0,0,0,0,0,0,0,0,1,1,1,0,
  0,0,0,0,0,0,0,0,0,0,1,1,0,0,
  0,0,0,0,0,0,0,0,0,1,1,1,0,0,
  0,0,0,0,0,0,0,0,0,1,1,0,0,0,
  0,0,0,0,0,0,0,0,1,1,1,0,0,0,
  0,0,0,0,0,0,0,0,1,1,0,0,0,0,
  0,0,0,0,0,0,0,1,1,1,0,0,0,0,
  0,0,0,0,0,0,0,1,1,0,0,0,0,0,
  0,0,0,0,0,0,1,1,1,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,
  0,0,0,0,0,1,1,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,0,0,0,0,0,0,0,
  0,0,0,0,1,1,1,0,0,0,0,0,0,0,
  0,0,0,0,1,1,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  
  /* 8 */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,1,1,1,1,1,1,1,0,0,0,
  0,0,1,1,1,1,1,1,1,1,1,1,0,0,
  0,1,1,1,0,0,0,0,0,0,1,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,1,0,0,0,0,0,0,1,1,1,0,
  0,0,1,1,1,0,0,0,0,1,1,1,0,0,
  0,0,0,1,1,1,0,0,1,1,1,0,0,0,
  0,0,0,0,1,1,1,1,1,1,0,0,0,0,
  0,0,0,0,1,1,1,1,1,1,0,0,0,0,
  0,0,0,1,1,1,0,0,1,1,1,0,0,0,
  0,0,1,1,1,0,0,0,0,1,1,1,0,0,
  0,1,1,1,0,0,0,0,0,0,1,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,1,0,0,0,0,0,0,1,1,1,0,
  0,0,1,1,1,1,1,1,1,1,1,1,0,0,
  0,0,0,1,1,1,1,1,1,1,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  
  /* 9 */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,0,0,0,0,0,
  0,0,0,1,1,1,1,1,1,1,1,0,0,0,
  0,0,1,1,1,1,0,0,1,1,1,1,0,0,
  0,0,1,1,0,0,0,0,0,0,1,1,0,0,
  0,1,1,1,0,0,0,0,0,0,1,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,0,0,0,0,0,0,0,0,1,1,0,
  0,1,1,1,0,0,0,0,0,0,1,1,1,0,
  0,0,1,1,0,0,0,0,0,0,1,1,1,0,
  0,0,1,1,1,1,0,0,1,1,1,1,1,0,
  0,0,0,1,1,1,1,1,1,1,1,1,0,0,
  0,0,0,0,0,1,1,1,1,0,1,1,0,0,
  0,0,0,0,0,0,0,0,0,1,1,1,0,0,
  0,0,0,0,0,0,0,0,0,1,1,0,0,0,
  0,0,0,0,0,0,0,0,1,1,1,0,0,0,
  0,0,0,0,0,0,0,1,1,1,0,0,0,0,
  0,0,0,0,0,0,1,1,1,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,
  0,0,0,0,0,1,1,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  
  /* ? */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,1,0,0,0,0,
  0,0,0,1,1,1,1,1,1,1,1,0,0,0,
  0,0,1,1,1,1,1,1,1,1,1,1,0,0,
  0,0,1,1,1,0,0,0,0,1,1,1,1,0,
  0,1,1,1,1,0,0,0,0,0,1,1,1,0,
  0,1,1,1,0,0,0,0,0,0,1,1,1,0,
  0,1,1,1,0,0,0,0,0,0,1,1,1,0,
  0,1,1,1,0,0,0,0,0,0,1,1,1,0,
  0,0,0,0,0,0,0,0,0,1,1,1,1,0,
  0,0,0,0,0,0,0,0,1,1,1,1,0,0,
  0,0,0,0,0,0,0,1,1,1,1,0,0,0,
  0,0,0,0,0,0,1,1,1,1,0,0,0,0,
  0,0,0,0,0,1,1,1,1,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
  
void putdigit(int d, GrayImage im, int x0, int y0, int val)
{
  int x, y;

  assert(x0+DIGIT_WIDTH < imGetWidth(im));
  assert(y0+DIGIT_HEIGHT < imGetHeight(im));
  assert(d >= 0 && d <= 10);

  for (y=0; y < DIGIT_HEIGHT; y++)
    for (x=0; x < DIGIT_WIDTH; x++)
      if (digits[d][y][x])
	imRef(im, x0+x, y0+y) = val;
}

int putnum1(int n, GrayImage im, int x0, int y0, int val)
{
  int x1;
  if (n>0) {
    x1 = putnum1(n/10, im, x0, y0, val);
    putdigit(n%10, im, x1, y0, val);
    return x1+DIGIT_WIDTH;
  } else
    return x0;
}
  
void putnumber(int n, GrayImage im, int x0, int y0, int val)
{
  if (n<0)
    putdigit(10, im, x0, y0, val); /* question mark */
  else if (n==0)
    putdigit(0, im, x0, y0, val);
  else
    putnum1(n, im, x0, y0, val);
}
  
void putdigitRGB(int d, RGBImage im, int x0, int y0, RGB val)
{
  int x, y;

  if (!(x0+DIGIT_WIDTH < imGetWidth(im) &&
      (y0+DIGIT_HEIGHT < imGetHeight(im))))
    return;
  
  assert(x0+DIGIT_WIDTH < imGetWidth(im));
  assert(y0+DIGIT_HEIGHT < imGetHeight(im));
  assert(d >= 0 && d <= 10);

  for (y=0; y < DIGIT_HEIGHT; y++)
    for (x=0; x < DIGIT_WIDTH; x++)
      if (digits[d][y][x])
	imRef(im, x0+x, y0+y) = val;
}

int putnum1RGB(int n, RGBImage im, int x0, int y0, RGB val)
{
  int x1;
  if (n>0) {
    x1 = putnum1RGB(n/10, im, x0, y0, val);
    putdigitRGB(n%10, im, x1, y0, val);
    return x1+DIGIT_WIDTH;
  } else
    return x0;
}
  
void putnumberRGB(int n, RGBImage im, int x0, int y0, RGB val)
{
  if (n<0)
    putdigitRGB(10, im, x0, y0, val); /* question mark */
  else if (n==0)
    putdigitRGB(0, im, x0, y0, val);
  else
    putnum1RGB(n, im, x0, y0, val);
}
