/****************************************************************************
*
*   Copyright (c) 2009 Carrick Detweiler
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*   $Id: types.h 2917 2011-03-29 15:30:17Z carrick $
****************************************************************************/

#if !defined( TYPES_H )
#define TYPES_H

#include <inttypes.h>

/**
 * Different types.  These should be used as opposed to just using int
 * or char as these are more specific and can be changed depending on
 * the architecture of the processor.
 *
 * N.B. This is a default configuration.  Different processors should
 * override this file with the proper config.
 **/
#define eint8 int8_t
#define euint8 uint8_t
#define eint16 int16_t
#define euint16 uint16_t
#define eint32 int32_t
#define euint32 uint32_t
//#define eint64 int64_t
//#define euint64 uint64_t
#define echar char
#define euchar unsigned char

#endif /* TYPES_H */
