/****************************************************************************
*
*   Copyright (c) 2009 Carrick Detweiler
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*   $Id: scheduleConsoleCmds.h 2917 2011-03-29 15:30:17Z carrick $
****************************************************************************/

#if !defined( SCHEDULE_CONSOLE_CMDS_H )
#define SCHEDULE_CONSOLE_CMDS_H 

#include "types.h"

/**
 * <p>Returns 1 if the schedule system is already initialized, else 0.</p>
 **/
eint8 scheduleConsoleCmdsIsInitialized(void);

/**
 * Initializes the scheduler console commands.  Returns 0 on
 * success, else - error.  May be called multiple times.
 **/
eint8 scheduleConsoleCmdsInit(void);

#endif /** SCHEDULE_CONSOLE_CMDS_H **/
