/****************************************************************************
*
*   Copyright (c) 2009 Carrick Detweiler
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*   $Id: scheduleConsoleCmds.c 2917 2011-03-29 15:30:17Z carrick $
****************************************************************************/

#include "types.h"
#include "schedule.h"
#include "console.h"

/**
 * 1 iff the schedule console system has been started, else 0.
 **/
euint8 scheduleConsoleCmdsInitialized = 0;


void handleListEvents(void){
  int i;

  consoleSend("The following events are currently scheduled:\r\n");
  consoleSend("Interval(s)  ID  Priority  Description\r\n");

  for(i=0;i<numScheduledSecEvents;i++){
    consoleSend("%8ld     %2d     %2d    %s\r\n",
                (euint32)scheduledSecEvents[i].interval,
                scheduledSecEvents[i].id,
                scheduledSecEvents[i].priority,
                scheduledSecEvents[i].description);
  }

  consoleSend("Interval(ms)  ID  Priority  Description\r\n");
  for(i=0;i<numScheduledMSEvents;i++){
    consoleSend("%8ld     %2d     %2d    %s\r\n",
                (euint32)scheduledMSEvents[i].interval,
                scheduledMSEvents[i].id,
                scheduledMSEvents[i].priority,
                scheduledMSEvents[i].description);
  }
  consoleSend("Done\r\n");

}

void handleAddEvent(void){
  char *tok;
  int success = 1;
  int add;
  int interval;
  int priority = 10;
  int i;
  int isMS = 0;

  //Get the selection we want to add
  if(!getToken(&tok)){success = 0;}
  else{ sscanf(tok,"%d",&add); }

  //Get the interval in which we want it to run
  if(!getToken(&tok)){success = 0;}
  else{ sscanf(tok,"%d",&interval); }

  //Get whether event has to run
  //if(!getToken(&tok)){success = 0;}
  //else{ sscanf(tok,"%d",&priority); }

  //Make sure it is in bounds
  if(add > numPossibleEvents) success = 0;

  if(!success){
    consoleSend("Please select an event, interval, and optionally ms for millisecond\r\n");
    consoleSend("e.g. run event 4 every 5 secs:  ae 4 5\r\n");
    consoleSend("e.g. run event 3 every 50 ms:   ae 3 50 ms\r\n");
    for(i=0;i<numPossibleEvents;i++){
      consoleSend(" %2d: %s\r\n",
                  i,
                  possibleEvents[i].description);
    }
    return;
  }

  //See if we want it in seconds or ms (hack)
  if(getToken(&tok)){
    if(tok[0] == 'm' && tok[1] == 's'){
      isMS = 1;
    }
  }

  if(isMS){
    scheduleMS(interval,
               possibleEvents[add].handler,
               possibleEvents[add].description,
               priority);
    consoleSend("Scheduled \"%s\" at interval %d ms\r\n",
                possibleEvents[add].description,interval);
  }else{
    scheduleSec(interval,
                possibleEvents[add].handler,
                possibleEvents[add].description,
                priority);
    consoleSend("Scheduled \"%s\" at interval %d sec\r\n",
                possibleEvents[add].description,interval);
  }
}

void handleDeleteEvent(void){
  char *tok;
  int id;

  if(!getToken(&tok)){
    consoleSend("Please select an id from scheduled events\r\n");
    handleListEvents();
    return;
  }
  sscanf(tok,"%d",&id);

  scheduleDeleteID(id);
}

void handleDeleteEventStr(void){
  char *tok;

  if(!getToken(&tok)){
    consoleSend("Please select an string from scheduled events\r\n");
    handleListEvents();
    return;
  }
  consoleSend("Deleting event named \"%s\"\r\n",tok);
  scheduleDeleteString(tok);
}


/**
 * <p>Returns 1 if the schedule system is already initialized, else 0.</p>
 **/
eint8 scheduleConsoleCmdsIsInitialized(void){
  return scheduleConsoleCmdsInitialized;
}


/**
 * Initializes the scheduler console commands.  Returns 0 on
 * success, else - error.  May be called multiple times.
 **/
eint8 scheduleConsoleCmdsInit(void){
  if(scheduleConsoleCmdsInitialized == 1) return 0;
  scheduleConsoleCmdsInitialized = 1;

  scheduleInit();
  consoleInit();

  int idx =
  consoleAddSubCommand(NULL,
                       "schedule",
                       "",
                       "",
                       "Functions for the scheduler.",
                       CONSOLE_MENU,
                       0);
  consoleAddSubCommand(handleListEvents,
                       "liste",
                       "le",
                       "",
                       "Lists any scheduled events",
                       CONSOLE_COMMAND,
                       idx);
  consoleAddSubCommand(handleDeleteEvent,
                       "deletee",
                       "de",
                       "<id>",
                       "delete scheduled event",
                       CONSOLE_COMMAND,
                       idx);
  consoleAddSubCommand(handleDeleteEventStr,
                       "deletees",
                       "des",
                       "<str>",
                       "delete scheduled event by string",
                       CONSOLE_COMMAND,
                       idx);
  consoleAddSubCommand(handleAddEvent,
                       "adde",
                       "ae",
                       "<id int (ms)>",
                       "add event at interval",
                       CONSOLE_COMMAND,
                       idx);

  return 0;
}
