/****************************************************************************
*
*   Copyright (c) 2011 Carrick Detweiler
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
****************************************************************************/


//The pin and register definitions for the atmel
#include <avr/io.h>
//Interrupt control
#include <avr/interrupt.h>
//Watchdog timer
#include <avr/wdt.h>

#include "uart.h"
#include "keycode.h"

/**
 * Reboots the board into the bootloader immediately.
 **/
void reboot(void){
 //The way we reboot is to start the watch dog timer with a very short
 //timeout.  The watchdog will reboot the board if it is not fed
 //within the specified time.  After we start it, we just wait to get
 //rebooted.  We could alternatively just jump to the start of the
 //bootloader in flash, but this will change with different
 //processors.  We disable interrupts so that noone can reset the WDT
 //in an interrupt.
  cli(); //Disable interrupts
  wdt_enable(WDTO_15MS);
  while(1);
}



/**
 * The main funciton is executed when the program starts, just like
 * with a regular C program.
 **/
int main(){


  //STUDENT CODE
  //This is the main loop which runs absolutely everything.  Above
  //this you should put any one-time initilization code, in the loop,
  //you should put the code you want to continuously execute.
  while(1){


  }

}
