/************************************************************************\
*                                                                      *
* Copyright 2003 Stretch, Inc. All rights reserved.                    *
*                                                                      *
* THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF *
* STRETCH, INC. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT *
* THE PRIOR EXPRESS WRITTEN PERMISSION OF STRETCH, INC.                *
*                                                                      *
* THIS SOFTWARE IS CONSIDERED AS "REDISTRIBUTABLES" AND ITS USE IS     *
* SUBJECT TO THE TERMS AND CONDITIONS OUTLINED IN STRETCH'S SOFTWARE   *
* LICENSE AGREEMENT                                                    *
*                                                                      *
\************************************************************************/
#include <stretch.h>

/* Extension instruction converting 5 pixels */
SE_FUNC void rgb2ycc(WR A, WR *B)
{
  se_sint<8> r[5], g[5], b[5];
  se_sint<8> y[5], cb[5], cr[5];
  int i, j;

  /* unpack A to RGB data, does not use any ISEF logic */
  for (i = 0; i < 5; i++) {
    j = i * 3 * 8;
    r[i] = A(j+7, j);
    g[i] = A(j+15, j+8);
    b[i] = A(j+23, j+16);
  }

  /* converting 5 pixels */
  for (i = 0; i < 5; i++) {
    y[i]  = ( 77*r[i] + 150*g[i] +  29*b[i]        ) >> 8;
    cb[i] = (-43*r[i] -  85*g[i] + 128*b[i] + 32768) >> 8;
    cr[i] = (128*r[i] - 107*g[i] -  21*b[i] + 32768) >> 8;
  }

  /* pack YCbCr to B */
  *B = (cr[4],cb[4],y[4],cr[3],cb[3],y[3],cr[2],cb[2],y[2],cr[1],cb[1],y[1],cr[0],cb[0],y[0]);
}
