/************************************************************************\
*                                                                      *
* Copyright 2003 Stretch, Inc. All rights reserved.                    *
*                                                                      *
* THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF *
* STRETCH, INC. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT *
* THE PRIOR EXPRESS WRITTEN PERMISSION OF STRETCH, INC.                *
*                                                                      *
* THIS SOFTWARE IS CONSIDERED AS "REDISTRIBUTABLES" AND ITS USE IS     *
* SUBJECT TO THE TERMS AND CONDITIONS OUTLINED IN STRETCH'S SOFTWARE   *
* LICENSE AGREEMENT                                                    *
*                                                                      *
\************************************************************************/
#include "data.h"
#include "rgb2ycc.h"

#if (!defined(__STRETCH_ISS__)&&!defined(__STRETCH_NATIVE__))
#include "s5000\sx-isef.h"
#endif

void 
rgb2ycc_wrapper(signed char *RGB, signed char *ycc)
{
  WR A0, A1, A2, A3;
  WR B0, B1, B2, B3;
  int i;

  WRGET0INIT(0, RGB);	/* initialize input stream from RGB */
  WRPUTINIT(0, ycc);	/* initialize output stream to ycc */


  /* loop prolog */

  	// load A0
  	// convert A0

  	// load A1
  	// convert A1

  	// load A2
  	// convert A2

  	// load A3
  	// convert A3


  /* loop over RGB data, converting 5 pixels at a time */

  for (i = 0; i < NP/5/4-1; i++) {

    WRPUTI(B0, 15);	// store B0
    WRGET0I(&A0, 15);	// load A0
    rgb2ycc(A0, &B0);	// convert A0

    WRPUTI(B1, 15);	// store B1
    WRGET0I(&A1, 15);	// load A1
    rgb2ycc(A1, &B1);	// convert A1

    WRPUTI(B2, 15);	// store B2
    WRGET0I(&A2, 15);	// load A2
    rgb2ycc(A2, &B2);	// convert A2

    WRPUTI(B3, 15);	// store B3
    WRGET0I(&A3, 15);	// load A3
    rgb2ycc(A3, &B3);	// convert A3

  }

  /* loop epilog */

  	// store B0
  	// store B1
  	// store B2
  	// store B3


  WRPUTFLUSH();  /* flush output stream */
}

int main()
{
  signed char ycc[3 * NP];
  int i, err=0;

#if (!defined(__STRETCH_ISS__)&&!defined(__STRETCH_NATIVE__))
   /* Load the ISEF */
   err = sx_isef_load_by_name(sx_isef_a, "rgb2ycc");
   if (err) {
      while (1); // Spin in an endless loop so we can break here and debug
    }
#endif

  rgb2ycc_wrapper(RGB, ycc);

  for (i = 0; i < 3 * NP; i++) {
    err |= YCC[i] != ycc[i];
  }
  printf("%s\n", err ? "Error" : "Pass");

  return err;
}
