/************************************************************************\
*                                                                      *
* Copyright 2003 Stretch, Inc. All rights reserved.                    *
*                                                                      *
* THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF *
* STRETCH, INC. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT *
* THE PRIOR EXPRESS WRITTEN PERMISSION OF STRETCH, INC.                *
*                                                                      *
* THIS SOFTWARE IS CONSIDERED AS "REDISTRIBUTABLES" AND ITS USE IS     *
* SUBJECT TO THE TERMS AND CONDITIONS OUTLINED IN STRETCH'S SOFTWARE   *
* LICENSE AGREEMENT                                                    *
*                                                                      *
\************************************************************************/
#include "data.h"
#include "rgb2ycc.h"

#if (!defined(__STRETCH_ISS__)&&!defined(__STRETCH_NATIVE__))
#include "s5000\sx-isef.h"
#endif

void 
rgb2ycc_wrapper(signed char *RGB, signed char *ycc)
{
  WR A, B;
  int i;

  WRGET0INIT(0, RGB);	/* initialize input stream from RGB */
  WRPUTINIT(0, ycc);	/* initialize output stream to ycc */

  /* loop over RGB data, converting 5 pixels at a time */
  for (i = 0; i < NP/5; i++) {
    WRGET0I(&A, 15);	/* load 5 RGB pixels to A */
                        /* convert 5 pixels */
    WRPUTI(B, 15);	/* store 5 YCbCr pixels from B */
  }

  WRPUTFLUSH();  /* flush output stream */
}

int main()
{
  signed char ycc[3 * NP];
  int i, err=0;

#if (!defined(__STRETCH_ISS__)&&!defined(__STRETCH_NATIVE__))
   /* Load the ISEF */
   err = sx_isef_load_by_name(sx_isef_a, "rgb2ycc");
   if (err) {
      while (1); // Spin in an endless loop so we can break here and debug
    }
#endif

  rgb2ycc_wrapper(RGB, ycc);

  for (i = 0; i < 3 * NP; i++) {
    err |= YCC[i] != ycc[i];
  }
  printf("%s\n", err ? "Error" : "Pass");

  return err;
}
