/************************************************************************\
*                                                                      *
* Copyright 2003 Stretch, Inc. All rights reserved.                    *
*                                                                      *
* THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF *
* STRETCH, INC. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT *
* THE PRIOR EXPRESS WRITTEN PERMISSION OF STRETCH, INC.                *
*                                                                      *
* THIS SOFTWARE IS CONSIDERED AS "REDISTRIBUTABLES" AND ITS USE IS     *
* SUBJECT TO THE TERMS AND CONDITIONS OUTLINED IN STRETCH'S SOFTWARE   *
* LICENSE AGREEMENT                                                    *
*                                                                      *
\************************************************************************/
#include "data.h"

void
rgb2ycc(
  signed char r, signed char g, signed char b, 
  signed char *y, signed char *cb, signed char *cr)
{
  *y  = ( 77*r + 150*g +  29*b        ) >> 8;
  *cb = (-43*r -  85*g + 128*b + 32768) >> 8;
  *cr = (128*r - 107*g -  21*b + 32768) >> 8;
}

void
rgb2ycc_wrapper(int np, signed char *RGB, signed char *YCC)
{
  int i;

  for (i = 0; i < 3 * np; i += 3) {
    rgb2ycc(RGB[i], RGB[i+1], RGB[i+2], &YCC[i], &YCC[i+1], &YCC[i+2]);
  }
}

int main()
{
    signed char ycc[3 * NP];
    int i, err=0;

    rgb2ycc_wrapper(NP, RGB, ycc);

    for (i = 0; i < 3 * NP; i++) {
      err |= YCC[i] != ycc[i];
    }

    printf("%s\n", err ? "Error" : "Pass");
    return err;
}
