// This is a Sample Driver
#include "stdafx.h"
DWORD DEM_Init(LPCTSTR pContext, LPCVOID lpvBusContext);
BOOL DEM_Deinit( DWORD hDeviceContext );
DWORD DEM_Open( DWORD hDeviceContext, DWORD AccessCode, DWORD ShareMode );
BOOL DEM_Close( DWORD hOpenContext );
BOOL DEM_IOControl( DWORD hOpenContext, DWORD dwCode, PBYTE pBufIn, DWORD dwLenIn, PBYTE pBufOut, DWORD dwLenOut, PDWORD pdwActualOut );
void DEM_PowerUp( DWORD hDeviceContext );
void DEM_PowerDown( DWORD hDeviceContext );
DWORD DEM_Read( DWORD hOpenContext, LPVOID pBuffer, DWORD Count );
DWORD DEM_Write( DWORD hOpenContext, LPCVOID pBuffer, DWORD Count );
DWORD DEM_Seek( DWORD hOpenContext, long Amount, WORD Type );
BOOL CustomFunction(void);
BOOL CustomFunctionEx(LPTSTR lpBuffer);
void DBGOut(DWORD dwValue);

#define IOCTL_DRIVER_REVSTR 0x1000

HANDLE hMem;      // Storage for Inbound Strings
DWORD  dwCount;   // Size of current String
// ----------------------------------------------------

BOOL APIENTRY DllMain( HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved )
{
    switch(ul_reason_for_call) {
        case DLL_PROCESS_ATTACH:
            OutputDebugString(L"StreamDrv - DLL_PROCESS_ATTACH\n");
        break;
        case DLL_PROCESS_DETACH:
            OutputDebugString(L"StreamDrv - DLL_PROCESS_DETACH\n");
        break;
        case DLL_THREAD_ATTACH:
            OutputDebugString(L"StreamDrv - DLL_THREAD_ATTACH\n");
        break;
        case DLL_THREAD_DETACH:
            OutputDebugString(L"StreamDrv - DLL_THREAD_DETACH\n");
        break;
        default:
        break;
    }
return TRUE;
}

// Driver Init...
DWORD DEM_Init( LPCTSTR pContext, LPCVOID lpvBusContext)
{
  OutputDebugString(L"StreamDrv - DEM_Init - Context: ");
  OutputDebugString(pContext);
  OutputDebugString(L"\n");
  hMem=LocalAlloc(LPTR,0x2000);   // 0x1000 Unicode Characters

  OutputDebugString(L"DemoDriver - ~ DEM_Init\n");
  return 0x1234;
}

BOOL DEM_Deinit( DWORD hDeviceContext )
{
OutputDebugString(L"StreamDrv - DEM_Deinit\n");

OutputDebugString(L"StreamDrv - ~ DEM_Deinit\n");
return TRUE;
}

// Driver Open
DWORD DEM_Open( DWORD hDeviceContext, DWORD AccessCode, DWORD ShareMode )
{
  OutputDebugString(L"DemoDriver - DEM_Open\n");
  OutputDebugString(L"hDeviceContext - ");
  DBGOut(hDeviceContext);
  OutputDebugString(L"\n");
  OutputDebugString(L"DemoDriver - ~ DEM_Open\n");
return 0x5678;
}
BOOL DEM_Close( DWORD hOpenContext )
{
  OutputDebugString(L"StreamDrv - DEM_Close\n");
  OutputDebugString(L"hOpenContext - ");
  DBGOut(hOpenContext);
  OutputDebugString(L"\n");
  OutputDebugString(L"StreamDrv - ~ DEM_Close\n");
return TRUE;
}
BOOL DEM_IOControl( DWORD hOpenContext, DWORD dwCode, PBYTE pBufIn, DWORD dwLenIn, PBYTE pBufOut, DWORD dwLenOut, PDWORD pdwActualOut )
{
  OutputDebugString(L"StreamDrv - DEM_IOControl\n");
  OutputDebugString(L"hOpenContext - ");
  DBGOut(hOpenContext);
  OutputDebugString(L"\n");
  switch (dwCode) {
    case IOCTL_DRIVER_REVSTR:
    {
       OutputDebugString(L"DRIVER REVSTR IOCTL...\n");
       // reverse the string...
       HANDLE hTemp=LocalAlloc(LPTR,dwLenIn+sizeof(TCHAR));
       memset(hTemp,0x00,dwLenIn+1);
       TCHAR *tcOut=(TCHAR*)hTemp;
       TCHAR *tcIn=(TCHAR*)pBufIn;
       DWORD dwChars=dwLenIn/2;
       for (DWORD x=0;x < dwChars;x++) {
          tcOut[x]=tcIn[dwChars-x-1];
       }
       memcpy(pBufOut,hTemp,dwLenIn);
       LocalFree(hTemp);
       *pdwActualOut=dwLenIn;
    }
    break;
    default:
       OutputDebugString(L"Unknown IOCTL\n");
    break;
}
OutputDebugString(L"StreamDrv - ~ DEM_IOControl\n");
return TRUE;
}
void DEM_PowerUp( DWORD hDeviceContext )
{
  OutputDebugString(L"StreamDrv - DEM_PowerUp\n");
  OutputDebugString(L"hDeviceContext - ");
  DBGOut(hDeviceContext);
  OutputDebugString(L"\n");

  OutputDebugString(L"StreamDrv - ~ DEM_PowerUp\n");
}

void DEM_PowerDown( DWORD hDeviceContext )
{
  OutputDebugString(L"StreamDrv - DEM_PowerDown\n");
  OutputDebugString(L"hDeviceContext - ");
  DBGOut(hDeviceContext);
  OutputDebugString(L"\n");

  OutputDebugString(L"StreamDrv - ~ DEM_PowerDown\n");
}

DWORD DEM_Read( DWORD hOpenContext, LPVOID pBuffer, DWORD Count )
{
  DWORD dwRetCount=0xffff;      // default to error
  OutputDebugString(L"StreamDrv - DEM_Read\n");
  OutputDebugString(L"hOpenContext - ");
  DBGOut(hOpenContext);
  OutputDebugString(L"\n");
  if (NULL != hMem) {
     dwRetCount=dwCount;
     memcpy(pBuffer,hMem,dwCount);
  }
  OutputDebugString(L"StreamDrv - ~ DEM_Read\n");

return dwRetCount;
}

DWORD DEM_Write( DWORD hOpenContext, LPCVOID pBuffer, DWORD Count )
{
  OutputDebugString(L"StreamDrv - DEM_Write\n");
  OutputDebugString(L"hOpenContext - ");
  DBGOut(hOpenContext);
  OutputDebugString(L"\n");

  if (NULL != hMem) {
     LocalFree(hMem);
  }

  hMem=LocalAlloc(LPTR,Count);
  memcpy(hMem,pBuffer,Count);
  dwCount=Count;

  OutputDebugString(L"StreamDrv - ~ DEM_Write\n");

return Count;
}

DWORD DEM_Seek( DWORD hOpenContext, long Amount, WORD Type )
{
  OutputDebugString(L"StreamDrv - DEM_Seek\n");
  OutputDebugString(L"hOpenContext - ");
  DBGOut(hOpenContext);
  OutputDebugString(L"\n");

  OutputDebugString(L"StreamDrv - ~ DEM_Seek\n");

return 0;
}
BOOL CustomFunction(void)
{
  OutputDebugString(L"StreamDrv - CustomFunction\n");
  OutputDebugString(L"StreamDrv - ~ CustomFunction\n");
return TRUE;
}
BOOL CustomFunctionEx(LPTSTR lpBuffer )
{
  OutputDebugString(L"StreamDrv - CustomFunctionEx\n");
  TCHAR buffer[16];
  _tcscpy(buffer, lpBuffer);
  OutputDebugString(buffer);
  OutputDebugString(_T("\n"));
  OutputDebugString(L"StreamDrv - ~ CustomFunctionEx\n");
return TRUE;
}

void DBGOut(DWORD dwValue)
{
  TCHAR tcTemp[10];
  wsprintf(tcTemp,L"%ld",dwValue);
  OutputDebugString(tcTemp);
}



