library ieee;
use ieee.std_logic_1164.all;
library work;
use work.proj_const.all;
entity mux16 is
	port(
		dat_in: in bus16(0 to rn-1);
		sel: in std_logic_vector(3 downto 0);
		dat_out: out std_logic_vector(n-1 downto 0)
		);
end mux16;
architecture flow of mux16 is
begin
	with sel select
		dat_out <= 
		dat_in(0)   when "0000",
		dat_in(1)	when "0001",
		dat_in(2)	when "0010",
		dat_in(3)	when "0011",
		dat_in(4)	when "0100",
		dat_in(5)	when "0101",
		dat_in(6)	when "0110",
		dat_in(7)	when "0111",
		dat_in(8)   when "1000",
		dat_in(9)	when "1001",
		dat_in(10)	when "1010",
		dat_in(11)	when "1011",
		dat_in(12)	when "1100",
		dat_in(13)	when "1101",
		dat_in(14)	when "1110",
		dat_in(15)	when "1111",
		dat_in(0) 	when others;
end flow;
