LIBRARY IEEE;
USE ieee.std_logic_1164.ALL;
LIBRARY lpm;
USE lpm.lpm_components.ALL;
entity ram is
	port (data_in : in std_logic_vector(15 downto 0);
		  clk : in std_logic;
		  wren : in std_logic;
		  address : in std_logic_vector(7 downto 0);
		  data_out : out std_logic_vector(15 downto 0));
end ram;

architecture flow of ram is
signal dout : std_logic_vector(15 downto 0);
signal ren : std_logic;
begin
data_out <= dout;
my_ram : lpm_ram_dq
	GENERIC MAP (LPM_WIDTHAD => 8,
				 LPM_WIDTH => 16,
				 LPM_ADDRESS_CONTROL => "UNREGISTERED",
				 LPM_OUTDATA => "UNREGISTERED")
	port map (data => data_in,
		      address => address,
			  we => wren,
			  inclock => clk,
			  q => dout);

end flow;
