library work;
use work.proj_const.all;
library ieee;
use ieee.std_logic_1164.all;
entity regfile is
	port(
		clk,wen: in std_logic;
		rd,rs,rt: in std_logic_vector(rn_width downto 0);
		dat_in: in std_logic_vector(n-1 downto 0);
		rs_out : out std_logic_vector(n-1 downto 0);
		rt_out : out std_logic_vector(n-1 downto 0));
end regfile;
architecture store of regfile is
	signal went: std_logic_vector(n-1 downto 0);
	signal out_tmp : bus16(0 to rn-1);
	component 
		mux16  port(dat_in: in bus16(0 to rn-1);
					sel: in std_logic_vector(rn_width downto 0);
					dat_out: out std_logic_vector(n-1 downto 0));
	end component;
begin
	process(clk)
	begin
		if clk'event and clk = '1' then
			for i in 0 to n-1 loop
				if went(i) = '1' then
					out_tmp(i) <= dat_in;
				end if;
			end loop;
		end if;
	end process;
		
		went <= "0000000000000001" when rd = "1111" and wen = '1' else			
				"0000000000000010" when rd = "1110" and wen = '1' else
				"0000000000000100" when rd = "1101" and wen = '1' else
				"0000000000001000" when rd = "1100" and wen = '1' else
				"0000000000010000" when rd = "1011" and wen = '1' else
				"0000000000100000" when rd = "1010" and wen = '1' else
				"0000000001000000" when rd = "1001" and wen = '1' else
				"0000000010000000" when rd = "1000" and wen = '1' else
				"0000000100000000" when rd = "0111" and wen = '1' else			
				"0000001000000000" when rd = "0110" and wen = '1' else
				"0000010000000000" when rd = "0101" and wen = '1' else
				"0000100000000000" when rd = "0100" and wen = '1' else
				"0001000000000000" when rd = "0011" and wen = '1' else
				"0010000000000000" when rd = "0010" and wen = '1' else
				"0100000000000000" when rd = "0001" and wen = '1' else
				"1000000000000000" when rd = "0000" and wen = '1' else
				"0000000000000000";
		C0: mux16 port map(out_tmp, rs, rs_out);
		C1: mux16 port map(out_tmp, rt, rt_out);
end store;
