
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "includes.h"
#include "alt_ucosii_simple_error_check.h"

/* Definition of Task Stacks */
#define   TASK_STACKSIZE       4096
#define   MAX_NODE    12000
#define   WAIT_TIME_MIN   0
#define   WAIT_TIME_SEC   50
OS_STK    initialize_task_stk[TASK_STACKSIZE];
OS_STK    malloc_task1_stk[TASK_STACKSIZE];
OS_STK    malloc_task2_stk[TASK_STACKSIZE];
OS_STK    free_task_stk[TASK_STACKSIZE];


/* Definition of Task Prioities */
#define INITIALIZE_TASK_PRIORITY   6
#define FREE_TASK_PRIORITY      7
#define MALLOC_TASK1_PRIORITY    8
#define MALLOC_TASK2_PRIORITY    9
#define SRAM_ADDR 0x00000000

struct node1
{
   INT16U id;
   INT32U value1;
} node1;

struct node2
{
   INT16U id;
   INT32U value1;
   INT32U value2;
};


/* Definition of Semaphore */
OS_EVENT *shared_resource_sem;

/*globals*/

INT32U number_of_alloc_node1 = 0;
INT32U number_of_alloc_node2 = 0;
INT8U turn = 3;
INT32U sum = 32;
INT32U bound = 32;
struct node1 * address_node1[MAX_NODE];
struct node2 * address_node2[MAX_NODE];
/* Local Function Prototypes */
int initOSDataStructs(void);
int initCreateTasks(void);
//void * malloc(int);
//void free(void *);

void malloc_task1(void* pdata)
{
  INT32U i = 0;

  while (1)
  {
    if (number_of_alloc_node1 < MAX_NODE){
      bound = (bound & 63) + 3;
      for (i = 0; i < bound; i++)
      {
        if (number_of_alloc_node1 < MAX_NODE){
          address_node1[number_of_alloc_node1] = (struct node1 *)malloc(sizeof(struct node1));
          address_node1[number_of_alloc_node1]->id = number_of_alloc_node1;
          address_node1[number_of_alloc_node1]->value1 = 5;
          number_of_alloc_node1++;
        }
      }
//      printf("node1 = %d (%d)\n", number_of_alloc_node1, bound);
    }
    OSTimeDlyHMSM(0, 0, 0, 80);
  }
}

void malloc_task2(void* pdata)
{
  INT32U i = 0;
  while (1)
  {
    if (number_of_alloc_node2 < MAX_NODE)
    {
      bound = (bound & 63) + 2;
      for (i = 0; i < bound; i++)
      {
        if (number_of_alloc_node2 < MAX_NODE){
          address_node2[number_of_alloc_node2] = (struct node2 *)malloc(sizeof(struct node2));
          address_node2[number_of_alloc_node2]->id = number_of_alloc_node2;
          address_node2[number_of_alloc_node2]->value1 = 3;
          address_node2[number_of_alloc_node2]->value2 = 7;
          number_of_alloc_node2++;
        }
      }
//      printf("node2 = %d (%d)\n", number_of_alloc_node2, bound);
    }
  }
}
 
void free_task(void* pdata)
{
  INT8U return_code = OS_NO_ERR; 
  INT16U i = 0;
  INT16U wait_time_min = WAIT_TIME_MIN;
  INT16U wait_time_sec = WAIT_TIME_SEC;

  while (1)
  {
    if (turn == 3)
      turn = 0;
    else
    {
      if (number_of_alloc_node1 != MAX_NODE || number_of_alloc_node2 != MAX_NODE)
      {
        fprintf(stderr,"Error processing the data\n");
        return_code = OSTaskDel(8);
        alt_ucosii_check_return_code(return_code);
        return_code = OSTaskDel(9);
        alt_ucosii_check_return_code(return_code);
        return_code = OSTaskDel(OS_PRIO_SELF);
        alt_ucosii_check_return_code(return_code);
      }
      wait_time_sec = 35;
      wait_time_min = 0;
      if (turn == 0)
      {
        for (i = 0; i < number_of_alloc_node1; i++)
        {
          sum = sum + address_node1[i]->value1;
          free(address_node1[i]);
        }
        number_of_alloc_node1 = 0;
        printf("sum0 = %d\n", sum);
      }
      else {
        for (i = 0; i < number_of_alloc_node2; i++)
        {
          sum = sum + address_node1[i]->value1 + address_node2[i]->value2;
          free(address_node2[i]);
        }
        number_of_alloc_node2 = 0;
        printf("sum1 = %d\n", sum);
      }
      turn = 1 - turn;
    }
    OSTimeDlyHMSM(0, wait_time_min, wait_time_sec, 0);
  }
}


void  initialize_task(void* pdata)
{
  INT8U return_code = OS_NO_ERR;
    
  /*create os data structures */
  initOSDataStructs();  

  /* create the tasks */
  initCreateTasks();
  
  /*This task is deleted because there is no need for it to run again */
  return_code = OSTaskDel(OS_PRIO_SELF);
  alt_ucosii_check_return_code(return_code);
  while (1);
}

/*void * malloc(int size)
{
  printf("malloc request of size %d bytes\n", size);
  return SRAM_ADDR;
}

void free(void * addr)
{
  printf("free request at address %p\n", addr);
}
*/
/* Main creates a single task and starts task switching
 */
 
int main (int argc, char* argv[], char* envp[])
{
  INT8U return_code = OS_NO_ERR;
   
  return_code = OSTaskCreateExt(initialize_task,
                             NULL,
                             (void *)&initialize_task_stk[TASK_STACKSIZE],
                             INITIALIZE_TASK_PRIORITY,
                             INITIALIZE_TASK_PRIORITY,
                             initialize_task_stk,
                             TASK_STACKSIZE,
                             NULL,
			     0);
  alt_ucosii_check_return_code(return_code);
  OSStart();
  return 0;
}

/* This function simply creates a message queue and a semaphore
 */
 
int initOSDataStructs(void)
{
  shared_resource_sem = OSSemCreate(1);
  return 0;
}
/*This function creates the tasks used in this example
 */
 
int initCreateTasks(void)
{
  INT8U return_code = OS_NO_ERR;

  return_code = OSTaskCreateExt(malloc_task1,
                             NULL,
                             (void *)&malloc_task1_stk[TASK_STACKSIZE],
                             MALLOC_TASK1_PRIORITY,
                             MALLOC_TASK1_PRIORITY,
                             malloc_task1_stk,
                             TASK_STACKSIZE,
                             NULL,
                             0);
  alt_ucosii_check_return_code(return_code);

  return_code = OSTaskCreateExt(malloc_task2,
                             NULL,
                             (void *)&malloc_task2_stk[TASK_STACKSIZE],
                             MALLOC_TASK2_PRIORITY,
                             MALLOC_TASK2_PRIORITY,
                             malloc_task2_stk,
                             TASK_STACKSIZE,
                             NULL,
                             0);
  alt_ucosii_check_return_code(return_code);

  return_code = OSTaskCreateExt(free_task,
                             NULL,
                             (void *)&free_task_stk[TASK_STACKSIZE],
                             FREE_TASK_PRIORITY,
                             FREE_TASK_PRIORITY,
                             free_task_stk,
                             TASK_STACKSIZE,
                             NULL,
                             0);
  alt_ucosii_check_return_code(return_code);

  
  return 0;
}
