package edu.unl.lasso.Learner.MyLearner;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;

import org.apache.axis.AxisEngine;
import org.apache.axis.Message;

import javax.activation.DataHandler;
import javax.activation.DataSource;

/**
 * @author Christopher Hammack (chammack@cse.unl.edu
 * @version 0.8
 * 
 * Version History (for complete history see CVS):
 * 0.5 Initial Release
 * 0.6 Implement API .6
 * 0.65 Bug Fixes, Error correction
 * 0.7 Hack session semantics
 * 0.8 Change to stateless API fc1.  All API Functions implemented
 *     Flexibility improvements - no explicit class invokes 
 */




//TODO: DOCUMENT MODIFIED AXIS
//It was necessary to patch axis because the beandeserializer does not
//handle multidimensional arrays properly.
//courtesy of Sakari Strmmer: http://nagoya.apache.org/bugzilla/show_bug.cgi?id=14033


public class LearnerBindingImpl implements LearnerPortType {
 
 	private String driverClass; 
 
	public LearnerBindingImpl() {
 		super();
                try {
                   driverClass = ((LearnerGlueBase) Class.forName("LearnerGlue").newInstance()).getClassName();
                }
                catch(Exception e) {
                   System.out.println("Glue class not properly defined.");
                   System.exit(0);
                }
 		System.out.println("Successfully initialized");
 	}
 	
 	
    /* (non-Javadoc)
	 * @see LearnerPortType#getClassifierData(java.lang.String)
	 */
	public DataHandler getClassifierData(java.lang.String name) throws java.rmi.RemoteException {
	    Message rspmsg=AxisEngine.getCurrentMessageContext().getResponseMessage();
        rspmsg.getAttachmentsImpl().setSendType(org.apache.axis.attachments.Attachments.SEND_TYPE_DIME);
       
        
		try {
			MyLearner myClassifier = (MyLearner) Class.forName(driverClass).newInstance();
			byte[] data =  myClassifier.exportClassifier(name);
			ByteArrayInputStream bais = new ByteArrayInputStream(data);
			DataHandler dh = new DataHandler(new MyDataSource(bais, "application/octet-stream", "image"));
			return dh;
		}
		catch(Exception e) {
			e.printStackTrace();
		}
		throw new java.rmi.RemoteException("IOException");
		
    }

	/**
	 * Sends classifier data 
	 * @param image - allocated space - leave null if unlimited
	 * @param name - name of classifier to send
	 * @return classifier binary data
	 */
    public byte[] sendClassifierData(java.lang.String name, byte[] image) throws java.rmi.RemoteException {
		try {
			MyLearner myClassifier = (MyLearner) Class.forName(driverClass).newInstance();
			myClassifier.importClassifier(name, image);
		}
		catch(Exception e) {
			e.printStackTrace();
			throw new java.rmi.RemoteException("IOException");
		}
		return null;
    }

	/**
	 * Soap training function for classification
	 * @param features - incoming feature array 
	 * @param labels - incoming label array
	 * @param name - Name of Classifier 
	 */
    public void train(java.lang.String name, java.lang.String[] features, java.lang.String[] labels, String[][] options) throws java.rmi.RemoteException {
		MyLearner myClassifier = null;
		String feature_type = null;
    	try {
			myClassifier = (MyLearner) Class.forName(driverClass).newInstance();
    	}
    	catch(Exception e) {
    		System.out.println("Exception...");
    		e.printStackTrace();
    		throw new java.rmi.RemoteException("IllegalOperation");
    	}
    	
    	System.out.println("Starting train");
    	if(features.length != labels.length)
    		throw new java.rmi.RemoteException("ArgumentException");
    	
		for(int i = 0; i < options.length; i++) {
			String key = (String) options[i][0];
			String value = (String) options[i][1];
			if(key.equals("feature_type")) {
				feature_type = value;
			}
			else
			{
				try {
					myClassifier.setOption(key, value);
				}
				catch(Exception e) {
					e.printStackTrace();
					throw new java.rmi.RemoteException("OptionException");
				}
			}
		}
    	try {
    		myClassifier.trainStart(name);
    	}
    	catch(Exception e) {
    		e.printStackTrace();
    		throw new java.rmi.RemoteException("InternalErrorException");
    	}
    
        System.out.println("Debug: receiving train...");
    	for(int i = 0; i < features.length; i++)
    	{
    		try {
    			Object[] newFeatures = this.featureTransform(features[i], feature_type);
    			myClassifier.train(newFeatures, labels[i]);
    		}
    		catch(Exception e) {
    			e.printStackTrace();
    			
    			if(e.getMessage().equals("NotImplementedException"))
    				throw new java.rmi.RemoteException("NotImplementedException");
    				
    			throw new java.rmi.RemoteException("TrainingException");
    		}
    	}
        System.out.println("Debug: calling trainstop...");
    	try {
    		myClassifier.trainStop();
    	}
    	catch(Exception e) {
    		e.printStackTrace();
    		throw new java.rmi.RemoteException("TrainingException");
    	}
        System.out.println("Debug: trainstop completed.");
    }

	/**
	 * Trains extractors
	 * @param features - feature array
	 * @param labels - contains fields and values to learn
	 * @param name - classifier name
	 */
    public void trainExtractor(java.lang.String name, java.lang.String[] features, java.lang.String[][] labels, String[][] options) throws java.rmi.RemoteException {
		
		MyLearner myClassifier = null;
		String feature_type = null;
		try {
			myClassifier = (MyLearner) Class.forName(driverClass).newInstance();
		}
		catch(Exception e) {
			e.printStackTrace();
			throw new java.rmi.RemoteException("IllegalOperation");
		}
		
		if(features.length != labels.length)
			throw new java.rmi.RemoteException("ArgumentException");
    	
		for(int i = 0; i < options.length; i++) {
			String key = (String) options[i][0];
			System.out.println("got key "+ key);
			String value = (String) options[i][1];
			if(key.equals("feature_type")) {
				feature_type = value;
			}
			else
			{
				try {
					myClassifier.setOption(key, value);
				}
				catch(Exception e) {
					e.printStackTrace();
					throw new java.rmi.RemoteException("OptionException");
				}
			}
		}
		
		try {
			myClassifier.trainStart(name);
		}
		catch(Exception e) {
			e.printStackTrace();
			throw new java.rmi.RemoteException("InternalErrorException");
		}
		
		for(int i = 0; i < features.length; i++)
		{
			try {
				Object[] newFeatures = this.featureTransform(features[i], feature_type);
				myClassifier.train(newFeatures, labels[i], labels[i].length);
			}
			catch(Exception e) {
				e.printStackTrace();
    			
				if(e.getMessage().equals("NotImplementedException"))
					throw new java.rmi.RemoteException("NotImplementedException");
    				
				throw new java.rmi.RemoteException("TrainingException");
			}
		}
		try {
			myClassifier.trainStop();
		}
		catch(Exception e) {
			e.printStackTrace();
			throw new java.rmi.RemoteException("TrainingException");
		}
    }

	/**
	 * Classify a set of features
	 * @param name - name of classifier
	 * @param features - features
	 * @return returns set of labels and confidences
	 */
    public ClassificationResults classify(java.lang.String name, java.lang.String[] features, String[][] options) throws java.rmi.RemoteException {
		MyLearner myClassifier = null;
		try {
			myClassifier = (MyLearner) Class.forName(driverClass).newInstance();
		}
		catch(Exception e) {
			e.printStackTrace();
			throw new java.rmi.RemoteException("IllegalOperation");
		}
		String feature_type = null;
		ClassificationResults cr = new ClassificationResults();
    	float[][] confidenceData = null;
    	String[][] labelData = null;
    	
		for(int i = 0; i < options.length; i++) {
			String key = (String) options[i][0];
			System.out.println("got key "+ key);
			String value = (String) options[i][1];
			if(key.equals("feature_type")) {
				feature_type = value;
			}
			else
			{
				try {
					myClassifier.setOption(key, value);
				}
				catch(Exception e) {
					e.printStackTrace();
					throw new java.rmi.RemoteException("OptionException");
				}
			}
		}
		
		try {
			myClassifier.classifyStart(name);
		}
		catch(Exception e) {
			e.printStackTrace();
			throw new java.rmi.RemoteException("InternalErrorException");
		}
		
		for(int i = 0; i < features.length; i++)
		{
			try {
				MyLearner.ClassifyResult res = null;
				
				Object[] newFeatures = this.featureTransform(features[i], feature_type);
				res = myClassifier.classify(newFeatures);
				

				if(confidenceData == null) {
					confidenceData = new float[features.length][res.confidences.length];
					labelData = new String[features.length][res.confidences.length];
					System.out.println("INITed ld: " + features.length + " x " + res.confidences.length);
				}
				
				for(int j = 0; j < res.confidences.length; j++) {
					System.out.println("EXPORTING: " + res.labels[j]);
					confidenceData[i][j] = res.confidences[j];
					labelData[i][j] = res.labels[j];
				}
				
			}
			catch(Exception e) {
				e.printStackTrace();
    			
				if(e.getMessage().equals("NotImplementedException"))
					throw new java.rmi.RemoteException("NotImplementedException");
    				
				throw new java.rmi.RemoteException("ClassifyException");
			}
		}
		try {
			cr.setSize(labelData.length);
			cr.setLabels(labelData);
			cr.setConfidences(confidenceData);
			myClassifier.classifyStop();
		}
		catch(Exception e) {
			e.printStackTrace();
			throw new java.rmi.RemoteException("ClassifyException");
		}
		
		return cr;
    }

	/**
	 * Perform extraction on feature vectors
	 * @param features - features
	 * @param name - classifier name
	 * @return fields and values, and associated confidences
	 */
    public ExtractionResults extract(java.lang.String name, java.lang.String[] features, String[][] options) throws java.rmi.RemoteException {
		MyLearner myClassifier = null;
		String feature_type = null;
		try {
			myClassifier = (MyLearner) Class.forName(driverClass).newInstance();
		}
		catch(Exception e) {
			e.printStackTrace();
			throw new java.rmi.RemoteException("IllegalOperation");
		}
	    	
		ExtractionResults er = new ExtractionResults();
		float[][] confidenceData = null;
		String[][][] fieldData = null;
	    	
		for(int i = 0; i < options.length; i++) {
			String key = (String) options[i][0];
			System.out.println("got key "+ key);
			String value = (String) options[i][1];
			if(key.equals("feature_type")) {
				feature_type = value;
			}
			else
			{
				try {
					myClassifier.setOption(key, value);
				}
				catch(Exception e) {
					e.printStackTrace();
					throw new java.rmi.RemoteException("OptionException");
				}
			}
		}
			
		try {
			myClassifier.classifyStart(name);
		}
		catch(Exception e) {
			e.printStackTrace();
			throw new java.rmi.RemoteException("InternalErrorException");
		}
			
		for(int i = 0; i < features.length; i++)
		{
			try {
				Object[] newFeatures = this.featureTransform(features[i], feature_type);
				MyLearner.ExtractionResult res = myClassifier.extract(newFeatures);
	
				if(confidenceData == null) {
					confidenceData = new float[features.length][res.confidences.length];
					fieldData = new String[features.length][res.confidences.length][2];
				}
					
				for(int j = 0; j < res.confidences.length; j++) {
					confidenceData[i][j] = res.confidences[j];
					fieldData[i][j][0] = res.fields[j][0];
					fieldData[i][j][1] = res.fields[j][1];
				}
					
			}
			catch(Exception e) {
				e.printStackTrace();
	    			
				if(e.getMessage().equals("NotImplementedException"))
					throw new java.rmi.RemoteException("NotImplementedException");
	    				
				throw new java.rmi.RemoteException("ExtractionException");
			}
		}
		try {
			er.setFields(fieldData);
			er.setConfidences(confidenceData);
			myClassifier.classifyStop();
		}
		catch(Exception e) {
			e.printStackTrace();
			throw new java.rmi.RemoteException("ExtractException");
		}
			
		return er;
    }
    
	public long getClassifierAge(String name) throws java.rmi.RemoteException {
		MyLearner myClassifier = null;
		try {
			myClassifier = (MyLearner) Class.forName(driverClass).newInstance();
			return myClassifier.getClassifierAge(name);
		}
		catch(Exception e) {
			e.printStackTrace();
			throw new java.rmi.RemoteException("IllegalOperation");
		}
	}


	/* Following code idea courtesy of sdkeens @ forums.sun */
	public class MyDataSource implements DataSource 
	{
		private InputStream inputStream; 
		private String contentType; 
		private String name; 

		
		public MyDataSource( InputStream inputStreamIn, String contentTypeIn, String nameIn ) { 
			inputStream = inputStreamIn; 
			contentType = contentTypeIn; 
			name = nameIn; 
		}
	
	
		public InputStream getInputStream() 
		throws java.io.IOException { 
			return inputStream; 
		}
	
	
		public OutputStream getOutputStream() throws java.io.IOException { 
			throw new IOException( "Cannot write to this stream" ); 
		}
	
	
		public String getContentType() { 
			return contentType; 
		}
	
	
		public java.lang.String getName() { 
			return name; 
		}
	

	}

	private Object[] featureTransform(String features, String feature_type) {
		if(feature_type == null || feature_type.equals("csv")) { // TODO: CHECK SYNTAX
			Vector v = new Vector();
			StringTokenizer strtok = new StringTokenizer(features, " ,");
			while(strtok.hasMoreTokens()) {
				v.add(strtok.nextToken());
			}
			Float[] newFeatures = new Float[v.size()];
			for(int j = 0; j < v.size(); j++) {
				newFeatures[j] = new Float(Float.parseFloat((String) v.get(j)));
			}
			return newFeatures;
		}
		else if(feature_type.equals("string")) { // TODO: CHECK SYNTAX
			Object[] newFeatures = new Object[1];
			newFeatures[0] = features;
			return newFeatures;
		}
		return null;
	}
	
}
