#include <iostream>
#include <sstream>

using namespace std;

/* This method should return the index of the given account name if it exists, and -1 otherwise. */
int getAccountNum(string names[], string accountName, int numAccounts);


/* This method should print out the account balance of the given customer. */
void checkBalance(string names[], int accounts[], string accountName,
                  int numAccounts);

/* This method should effectively deposit the given amount into the given 
   customer’s account. */
void deposit(string names[], int accounts[], string accountName, int amount,
             int numAccounts);


/* This method should effectively withdraw the given amount from the given 
   customer’s account. */
void withdraw(string names[], int accounts[], string accountName, int amount,
              int numAccounts);


/* This method should print out all of the customers’ names and account 
   balances on separate lines. For example:

   John Doe: $120
   Fred Flintstone: $200
*/
void printAccounts(string names[], int accounts[], int numAccounts);

/* Do not worry about these two functions. */
void initAccounts(string names[], int accounts[], int numAccounts);
int getInt();

/* Do not alter this function. */
int main() {
   int numAccounts = 5;
   string customerMsg =
      "Enter \"deposit\", \"withdraw\", or press enter to check balance: ";
   int accounts[numAccounts];
   string welcomeMsg = "Enter customer name or press enter to quit: ";
   string names[numAccounts];
   initAccounts(names, accounts, numAccounts);
   printAccounts(names, accounts, numAccounts);
   while (true) {
      cout << endl << welcomeMsg;
      string accountName;
      getline(cin, accountName);
      if (accountName.empty()) break;
      cout << customerMsg;
      string amountLine;
      getline(cin, amountLine);
      if (amountLine == "") {
         checkBalance(names, accounts, accountName, numAccounts);
      } else if (amountLine == "deposit") {
         cout << "Enter an amount (dollars) to deposit: ";
         int amount = getInt();
         deposit(names, accounts, accountName, amount, numAccounts);
         cout << "Successfully added $" << amount
              << " to the account of " << accountName << endl;
      } else if (amountLine == "withdraw") {
         cout << "Enter an amount (dollars) to withdraw: ";
         int amount = getInt();
         withdraw(names, accounts, accountName, amount, numAccounts);
         cout << "Successfully withdrew $" << amount
              << " from the account of " << accountName << endl;
      } else {
         cout << "Unrecognized command" << endl;
      }
   }
   return 0;
}


/* Do not alter these two functions. */
void initAccounts(string names[], int accounts[], int numAccounts) {
   for (int i = 0; i < numAccounts; i++) {
      accounts[i] = 100; // we have everyone start with $100
   }
   names[0] = "John Hancock";
   names[1] = "George Washington";
   names[2] = "Thomas Jefferson";
   names[3] = "Alexander Hamilton";
   names[4] = "Ben Franklin";
}

int getInt() {
   int amount;
   while (true) {
      string response;
      getline(cin, response);
      if (!(stringstream(response) >> amount)) {
         cout << "Enter a valid integer, try again: ";
      } else break;
   }
   return amount;
}

/* These are the functions you must implement. Descriptions of their behavior
 * are above
 */
int getAccountNum(string names[], string accountName, int numAccounts) {
   // Your code here
}

void checkBalance(string names[], int accounts[], string accountName,
                  int numAccounts) {
   // Your code here
}

void deposit(string names[], int accounts[], string accountName, int amount,
             int numAccounts) {
   // Your code here
}   

void withdraw(string names[], int accounts[], string accountName, int amount,
              int numAccounts) {
   // Your code here
} 


void printAccounts(string names[], int accounts[], int numAccounts) {
   // Your code here
}
