#include <iostream>
#include <time.h>  //used to generate the random state

using namespace std;

void cleanLogbook();
int currentState();
void logActivity(int index, char level);
void runTimer();

// logbook, used to record activity for the system
char logbook[100];

int main() {
   srand(time(NULL));  // initialize random seed
   cleanLogbook();
   runTimer();  // start timer
   return 0;
}

// Initializes logbook, cleaning array of possible "junk"
void cleanLogbook() {
   for (int i = 0; i < 100; i++){
      logbook[i] = '0'; // sets every value to 0
   }
}

// Returns the current state or "density" of the air traffic.
// This is an int between 1 to 100, where 1 is low and 100 is high
int currentState(){
   return rand() % 100 + 1; // generate a random int between 1 and 100
}

void runTimer(){
   int den = currentState();

   // Really "big number", for the purposes of this example, set to 100
   // instead of 232
   int bigNumber = 100;
   int timer = bigNumber;  

   // Keeps timer running, need to reboot computer to reset timer before timer
   // reaches 0
   while (true) {
      if (den < 5) logActivity(timer-1, 'L');
      else if (den > 45 && den < 55) logActivity(timer-1, 'M');
      else if (den > 95) logActivity(timer-1, 'H');
      den = currentState();
      timer--;
   }
}

// Records the activity level at the given time (index)
void logActivity(int index, char level) {
    logbook[index] = level;
    cout << "State was " << level << " at time " << index << endl;
}
